/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.user;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.user.AbstractUserCommand;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDeleteAll
extends AbstractUserCommand {
    private static final Logger LOG = LoggerFactory.getLogger(UserDeleteAll.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String DELETE_ALL_HELP_MESSAGE = "user --delete-all {REALM}";
    private final Input input;

    public UserDeleteAll(Input input) {
        this.input = input;
    }

    public void delete() {
        block10: {
            if (this.input.parameterNumber() == 1) {
                try {
                    Scanner scanIn = new Scanner(System.in);
                    System.out.println("\nRunning this operation you will delete all the realm users managed by Syncope, are you sure? [yes/no]");
                    String answer = scanIn.nextLine();
                    if ("yes".equalsIgnoreCase(answer)) {
                        System.out.println("\nUsername:");
                        String username = scanIn.nextLine();
                        System.out.println("\nPassword:");
                        String password = scanIn.nextLine();
                        if (this.userSyncopeOperations.auth(username, password)) {
                            System.out.println("Deleting process started");
                            String realm = this.input.firstParameter();
                            if (!this.realmSyncopeOperations.exists(realm)) {
                                this.userResultManager.notFoundError("Realm", realm);
                                return;
                            }
                            List<BatchResponseItem> results = this.userSyncopeOperations.deleteAll(realm);
                            HashMap<String, String> failedUsers = new HashMap<String, String>();
                            AtomicReference<Integer> deletedUsers = new AtomicReference<Integer>(0);
                            results.forEach(item -> {
                                if (item.getStatus() == Response.Status.OK.getStatusCode()) {
                                    deletedUsers.getAndSet((Integer)deletedUsers.get() + 1);
                                } else {
                                    try {
                                        ProvisioningResult user = (ProvisioningResult)MAPPER.readValue(item.getContent(), (TypeReference)new TypeReference<ProvisioningResult<UserTO>>(){});
                                        failedUsers.put(((UserTO)user.getEntity()).getUsername(), ((List)item.getHeaders().get("X-Application-Error-Code")).toString());
                                    }
                                    catch (IOException ioe) {
                                        LOG.error("Error reading {}", (Object)item.getContent(), (Object)ioe);
                                    }
                                }
                            });
                            this.userResultManager.genericMessage("Deleted users: " + deletedUsers);
                            if (!failedUsers.isEmpty()) {
                                this.userResultManager.printFailedUsers(failedUsers);
                            }
                        } else {
                            this.userResultManager.genericError("Authentication error");
                        }
                        break block10;
                    }
                    if ("no".equalsIgnoreCase(answer)) {
                        this.userResultManager.genericError("Delete all operation skipped");
                        break block10;
                    }
                    this.userResultManager.genericError("Invalid parameter, please use [yes/no]");
                }
                catch (Exception e) {
                    LOG.error("Error deleting user", (Throwable)e);
                    this.userResultManager.genericError(e.getMessage());
                }
            } else {
                this.userResultManager.commandOptionError(DELETE_ALL_HELP_MESSAGE);
            }
        }
    }
}

