/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.self;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.ws.rs.core.Response;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.helpers.IOUtils;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.self.AbstractWorkflowCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.AnyTypeKind;

public class WorkflowExportDiagram
extends AbstractWorkflowCommand {
    private static final String EXPORT_HELP_MESSAGE = "workflow --export-diagram {ANY-TYPE-KIND}\n";
    private final Input input;

    public WorkflowExportDiagram(Input input) {
        this.input = input;
    }

    public void export() {
        block20: {
            if (this.input.parameterNumber() == 1) {
                try {
                    Response response = this.workflowSyncopeOperations.exportDiagram(this.input.firstParameter());
                    byte[] diagram = IOUtils.readBytesFromStream((InputStream)((InputStream)response.getEntity()));
                    try (OutputStream os = Files.newOutputStream(Paths.get("/tmp/diagram.png", new String[0]), new OpenOption[0]);){
                        os.write(diagram);
                        os.close();
                    }
                    this.workflowResultManager.genericMessage("Diagram created: /tmp/diagram.png");
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.workflowResultManager.notFoundError("Workflow", this.input.firstParameter());
                        break block20;
                    }
                    this.workflowResultManager.genericError(ex.getMessage());
                }
                catch (IllegalArgumentException ex) {
                    this.workflowResultManager.typeNotValidError("workflow", this.input.firstParameter(), CommandUtils.fromEnumToArray(AnyTypeKind.class));
                }
                catch (IOException ex) {
                    this.workflowResultManager.genericError(ex.getMessage());
                }
            } else {
                this.workflowResultManager.commandOptionError(EXPORT_HELP_MESSAGE);
            }
        }
    }
}

