/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.configuration;

import java.util.ArrayList;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.configuration.AbstractConfigurationCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AttrTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUpdate
extends AbstractConfigurationCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationUpdate.class);
    private static final String UPDATE_HELP_MESSAGE = "configuration --update {CONF-NAME}={CONF-VALUE} {CONF-NAME}={CONF-VALUE} [...]";
    private final Input input;

    public ConfigurationUpdate(Input input) {
        this.input = input;
    }

    public void update() {
        if (this.input.parameterNumber() >= 1) {
            ArrayList<AttrTO> attrList = new ArrayList<AttrTO>();
            boolean failed = false;
            for (String parameter : this.input.getParameters()) {
                Pair<String, String> pairParameter = Input.toPairParameter(parameter);
                try {
                    AttrTO attrTO = this.configurationSyncopeOperations.get((String)pairParameter.getKey());
                    attrTO.getValues().clear();
                    attrTO.getValues().add(pairParameter.getValue());
                    this.configurationSyncopeOperations.set(attrTO);
                    attrList.add(attrTO);
                }
                catch (IllegalArgumentException ex) {
                    LOG.error("Error updating configuration", (Throwable)ex);
                    this.configurationResultManager.genericError(ex.getMessage());
                    this.configurationResultManager.genericError(UPDATE_HELP_MESSAGE);
                    failed = true;
                    break;
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error updating configuration", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.configurationResultManager.notFoundError("Configuration", (String)pairParameter.getKey());
                    } else if (ex.getMessage().startsWith("InvalidValues")) {
                        this.configurationResultManager.genericError((String)pairParameter.getValue() + " is not a valid value for " + (String)pairParameter.getKey());
                    } else {
                        this.configurationResultManager.genericError(ex.getMessage());
                    }
                    failed = true;
                    break;
                }
            }
            if (!failed) {
                this.configurationResultManager.fromUpdate(attrList);
            }
        } else {
            this.configurationResultManager.commandOptionError(UPDATE_HELP_MESSAGE);
        }
    }
}

