/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ide.eclipse.plugin.dialogs;

import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class LoginDialog
extends TitleAreaDialog {
    private Text deploymentUrlInp;
    private Text usernameInp;
    private Text passwordInp;
    private String deploymentUrl;
    private String username;
    private String password;
    private Button resetbutton;
    private Preferences instancePreferences = InstanceScope.INSTANCE.getNode("org.apache.syncope.ide.eclipse.plugin.dialogs.prefs");
    private Preferences configPreferences = ConfigurationScope.INSTANCE.getNode("org.apache.syncope.ide.eclipse.plugin.dialogs.prefs");
    private Preferences sub1 = this.configPreferences.node("depPref");
    private Preferences sub2 = this.instancePreferences.node("userPref");

    public LoginDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Login to Apache Syncope");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Login", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.resetbutton = this.createButton(parent, 3, "Reset Fields", false);
        this.resetbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoginDialog.this.deploymentUrlInp.setText("");
                LoginDialog.this.usernameInp.setText("");
                LoginDialog.this.passwordInp.setText("");
                LoginDialog.this.saveInput();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.createDeploymentUrl(container);
        this.createUsername(container);
        this.createPassword(container);
        return area;
    }

    private void createDeploymentUrl(Composite container) {
        Label lbtDeploymentUrl = new Label(container, 0);
        lbtDeploymentUrl.setText("Deployment Url");
        GridData dataDeploymentUrl = new GridData();
        dataDeploymentUrl.grabExcessHorizontalSpace = true;
        dataDeploymentUrl.horizontalAlignment = 4;
        this.deploymentUrlInp = new Text(container, 2048);
        this.deploymentUrlInp.setLayoutData((Object)dataDeploymentUrl);
        String depurl = this.sub1.get("deploymentUrl", "http://");
        if (depurl != null) {
            this.deploymentUrlInp.setText(depurl);
        }
    }

    private void createUsername(Composite container) {
        Label lbtUsername = new Label(container, 0);
        lbtUsername.setText("Username");
        GridData dataUsername = new GridData();
        dataUsername.grabExcessHorizontalSpace = true;
        dataUsername.horizontalAlignment = 4;
        this.usernameInp = new Text(container, 2048);
        this.usernameInp.setLayoutData((Object)dataUsername);
        String usernameString = this.sub2.get("username", "");
        if (usernameString != null) {
            this.usernameInp.setText(usernameString);
        }
    }

    private void createPassword(Composite container) {
        Label lbtPassword = new Label(container, 0);
        lbtPassword.setText("Password");
        GridData dataPassword = new GridData();
        dataPassword.grabExcessHorizontalSpace = true;
        dataPassword.horizontalAlignment = 4;
        this.passwordInp = new Text(container, 0x400800);
        this.passwordInp.setLayoutData((Object)dataPassword);
        String passwordString = this.sub2.get("password", "");
        if (passwordString != null) {
            this.passwordInp.setText(passwordString);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.deploymentUrl = this.deploymentUrlInp.getText();
        this.username = this.usernameInp.getText();
        this.password = this.passwordInp.getText();
        this.sub1.put("deploymentUrl", this.deploymentUrl);
        this.sub2.put("username", this.username);
        this.sub2.put("password", this.password);
        try {
            this.instancePreferences.flush();
            this.configPreferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    protected void okPressed() {
        this.saveInput();
        this.setReturnCode(200);
        super.okPressed();
    }

    public String getDeploymentUrl() {
        return this.deploymentUrl;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }
}

