/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.utilities;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import org.apache.syncope.installer.enums.DBs;

public final class DriverLoader
extends URLClassLoader {
    private static final String POSTGRES_JAR = "http://repo1.maven.org/maven2/org/postgresql/postgresql/42.2.2/postgresql-42.2.2.jar";
    private static final String MYSQL_JAR = "http://central.maven.org/maven2/mysql/mysql-connector-java/5.1.46/mysql-connector-java-5.1.46.jar";
    private static final String MARIADB_JAR = "http://repo1.maven.org/maven2/org/mariadb/jdbc/mariadb-java-client/2.2.5/mariadb-java-client-2.2.5.jar";
    private static final String POSTGRES_CLASS_DRIVER = "org.postgresql.Driver";
    private static final String MYSQL_CLASS_DRIVER = "com.mysql.jdbc.Driver";
    private static final String MARIADB_CLASS_DRIVER = "org.mariadb.jdbc.Driver";
    private static DriverLoader DRIVER_LOADER;

    private DriverLoader(URL[] urls) {
        super(urls);
        this.addURL(urls[0]);
    }

    public static Driver load(DBs selectedDB, boolean isProxyEnabled, String proxyHost, String proxyPort, String proxyUser, String proxyPwd) {
        Driver driver = null;
        switch (selectedDB) {
            case POSTGRES: {
                driver = DriverLoader.downloadDriver(POSTGRES_JAR, POSTGRES_CLASS_DRIVER, isProxyEnabled, proxyHost, proxyPort, proxyUser, proxyPwd);
                break;
            }
            case MYSQL: {
                driver = DriverLoader.downloadDriver(MYSQL_JAR, MYSQL_CLASS_DRIVER, isProxyEnabled, proxyHost, proxyPort, proxyUser, proxyPwd);
                break;
            }
            case MARIADB: {
                driver = DriverLoader.downloadDriver(MARIADB_JAR, MARIADB_CLASS_DRIVER, isProxyEnabled, proxyHost, proxyPort, proxyUser, proxyPwd);
                break;
            }
            case SQLSERVER: {
                break;
            }
            case ORACLE: {
                break;
            }
        }
        return driver;
    }

    private static Driver downloadDriver(String driverUrl, String driverClassName, boolean isProxyEnabled, String proxyHost, String proxyPort, final String proxyUser, final String proxyPwd) {
        Driver driver = null;
        try {
            if (isProxyEnabled) {
                System.setProperty("http.proxyHost", proxyHost);
                System.setProperty("http.proxyPort", proxyPort);
                if (proxyUser != null && !proxyUser.isEmpty() && proxyPwd != null) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        public PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(proxyUser, proxyPwd.toCharArray());
                        }
                    });
                    System.setProperty("http.proxyUser", proxyUser);
                    System.setProperty("http.proxyPassword", proxyPwd);
                }
            }
            DRIVER_LOADER = new DriverLoader(new URL[]{new URL(driverUrl)});
            driver = (Driver)DRIVER_LOADER.loadClass(driverClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return driver;
    }
}

