/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.ExecutableFile;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.OverrideType;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackCompression;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.PackInfo;
import com.izforge.izpack.api.data.ParsableFile;
import com.izforge.izpack.api.data.UpdateCheck;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.exception.ResourceInterruptedException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.handler.ProgressHandler;
import com.izforge.izpack.core.resource.ResourceManager;
import com.izforge.izpack.installer.bootstrap.Installer;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.event.InstallerListeners;
import com.izforge.izpack.installer.unpacker.Cancellable;
import com.izforge.izpack.installer.unpacker.CompressedFileUnpacker;
import com.izforge.izpack.installer.unpacker.DefaultFileUnpacker;
import com.izforge.izpack.installer.unpacker.FileQueueFactory;
import com.izforge.izpack.installer.unpacker.FileUnpacker;
import com.izforge.izpack.installer.unpacker.IUnpacker;
import com.izforge.izpack.installer.unpacker.LooseFileUnpacker;
import com.izforge.izpack.installer.unpacker.Pack200FileUnpacker;
import com.izforge.izpack.installer.unpacker.PackResources;
import com.izforge.izpack.installer.unpacker.ScriptParser;
import com.izforge.izpack.installer.util.PackHelper;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.LogUtils;
import com.izforge.izpack.util.NoCloseInputStream;
import com.izforge.izpack.util.PlatformModelMatcher;
import com.izforge.izpack.util.file.DirectoryScanner;
import com.izforge.izpack.util.file.GlobPatternMapper;
import com.izforge.izpack.util.file.types.FileSet;
import com.izforge.izpack.util.os.FileQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public abstract class UnpackerBase
implements IUnpacker {
    private static Logger logger = Logger.getLogger(UnpackerBase.class.getName());
    public static final String RESOURCES_PATH = "resources/";
    private final InstallData installData;
    private List<Pack> selectedPacks;
    private final UninstallData uninstallData;
    private final PackResources resources;
    private final RulesEngine rules;
    private final Variables variables;
    private final Messages messages;
    private final VariableSubstitutor variableSubstitutor;
    private final FileQueueFactory queueFactory;
    private final Housekeeper housekeeper;
    private final InstallerListeners listeners;
    private ProgressListener listener;
    private final Prompt prompt;
    private final PlatformModelMatcher matcher;
    private boolean result = true;
    private final Cancellable cancellable;
    private State state = State.READY;
    private boolean disableInterrupt = false;
    private Messages packMessages;

    public UnpackerBase(InstallData installData, PackResources resources, RulesEngine rules, VariableSubstitutor variableSubstitutor, UninstallData uninstallData, FileQueueFactory factory, Housekeeper housekeeper, InstallerListeners listeners, Prompt prompt, PlatformModelMatcher matcher) {
        this.installData = installData;
        this.resources = resources;
        this.rules = rules;
        this.variableSubstitutor = variableSubstitutor;
        this.uninstallData = uninstallData;
        this.queueFactory = factory;
        this.housekeeper = housekeeper;
        this.listeners = listeners;
        this.prompt = prompt;
        this.matcher = matcher;
        this.variables = installData.getVariables();
        this.messages = installData.getMessages();
        this.cancellable = new Cancellable(){

            @Override
            public boolean isCancelled() {
                return UnpackerBase.this.isInterrupted();
            }
        };
    }

    @Override
    public void setProgressListener(ProgressListener listener) {
        this.listener = listener;
    }

    @Override
    public void run() {
        this.resetLogging();
        this.unpack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logIntro() {
        String startMessage = this.messages.get("installer.started", new Object[0]);
        char[] chars = new char[startMessage.length()];
        Arrays.fill(chars, '=');
        logger.info(new String(chars));
        logger.info(startMessage);
        URLClassLoader cl = (URLClassLoader)this.getClass().getClassLoader();
        InputStream is = null;
        try {
            URL url = cl.findResource("META-INF/MANIFEST.MF");
            is = url.openStream();
            Manifest manifest = new Manifest(is);
            Attributes attr = manifest.getMainAttributes();
            logger.info(this.messages.get("installer.version", attr.getValue("Created-By")));
        }
        catch (IOException e) {
            try {
                logger.log(Level.WARNING, "IzPack version not found in manifest", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly(is);
        }
        IOUtils.closeQuietly(is);
        logger.info(this.messages.get("installer.platform", this.matcher.getCurrentPlatform()));
    }

    private void logEpilog() {
        logger.info(this.messages.get("installer.finished", new Object[0]));
    }

    /*
     * Exception decompiling
     */
    public void unpack() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean interrupt(long timeout) {
        boolean result;
        if (this.isInterruptDisabled()) {
            result = false;
        } else {
            UnpackerBase unpackerBase = this;
            synchronized (unpackerBase) {
                if (this.state != State.READY && this.state != State.INTERRUPTED) {
                    this.state = State.INTERRUPT;
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    result = this.state == State.INTERRUPTED;
                } else {
                    result = true;
                }
            }
        }
        return result;
    }

    @Override
    public synchronized void setDisableInterrupt(boolean disable) {
        if (this.state == State.INTERRUPT || this.state == State.INTERRUPTED) {
            throw new IllegalStateException("Cannot disable interrupts. Unpacking has already been interrupted");
        }
        this.disableInterrupt = disable;
    }

    @Override
    public synchronized boolean isInterruptDisabled() {
        return this.disableInterrupt;
    }

    protected void preUnpack(List<Pack> packs) throws InstallerException {
        logger.fine("Unpacker starting");
        this.listener.startAction("Unpacking", packs.size());
        this.listeners.beforePacks(packs, this.listener);
    }

    protected void unpack(List<PackInfo> packs, FileQueue queue) throws InstallerException {
        int count = packs.size();
        for (int i = 0; i < count; ++i) {
            PackInfo packInfo = packs.get(i);
            Pack pack = packInfo.getPack();
            if (!this.shouldUnpack(pack)) continue;
            ArrayList<ParsableFile> parsables = new ArrayList<ParsableFile>();
            ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
            ArrayList<UpdateCheck> updateChecks = new ArrayList<UpdateCheck>();
            this.listeners.beforePack(pack, i);
            this.unpack(packInfo, i, queue, parsables, executables, updateChecks);
            this.checkInterrupt();
            logger.fine("Found " + parsables.size() + " parsable files");
            this.parseFiles(parsables);
            this.checkInterrupt();
            logger.fine("Found " + executables.size() + " executable files");
            this.executeFiles(executables);
            this.checkInterrupt();
            this.performUpdateChecks(updateChecks);
            this.checkInterrupt();
            this.listeners.afterPack(pack);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void unpack(PackInfo packInfo, int packNo, FileQueue queue, List<ParsableFile> parsables, List<ExecutableFile> executables, List<UpdateCheck> updateChecks) {
        InputStream in = null;
        Pack pack = packInfo.getPack();
        PackFile[] packFiles = packInfo.getPackFiles().toArray(new PackFile[0]);
        try {
            int len = packFiles.length;
            String stepName = this.getStepName(pack);
            this.selectedPacks = this.installData.getSelectedPacks();
            this.listener.nextStep(stepName, this.selectedPacks.indexOf(pack) + 1, len);
            in = this.resources.getPackStream(pack.getName());
            for (int i = 0; i < len; ++i) {
                PackFile packFile = packFiles[i];
                boolean isDirectory = packFile.isDirectory();
                logger.fine("Unpacking " + (isDirectory ? "directory" : "file") + " " + packFile.getTargetPath() + " (backreference: " + packFile.isBackReference() + ")");
                if (this.shouldUnpack(packFile)) {
                    this.unpack(packFile, in, i + 1, pack, queue);
                    continue;
                }
                if (isDirectory) continue;
                this.skip(packFile, pack, in);
            }
            this.readParsableFiles(packInfo, parsables);
            this.readExecutableFiles(packInfo, executables);
            this.readUpdateChecks(packInfo, updateChecks);
        }
        catch (IzPackException exception) {
            try {
                throw exception;
                catch (Exception exception2) {
                    throw new InstallerException("Failed to unpack pack: " + pack.getName(), exception2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
    }

    private boolean shouldUnpack(PackFile file) {
        boolean result = true;
        if (file.hasCondition()) {
            result = this.isConditionTrue(file.getCondition());
        }
        if (result && file.osConstraints() != null && !file.osConstraints().isEmpty()) {
            result = this.matcher.matchesCurrentPlatform(file.osConstraints());
        }
        return result;
    }

    protected void unpack(PackFile packFile, InputStream packInputStream, int fileNo, Pack pack, FileQueue queue) throws IOException {
        File target;
        String targetPath = packFile.getTargetPath();
        String path = IoHelper.translatePath(targetPath, this.variables);
        File dir = target = new File(path);
        if (!packFile.isDirectory()) {
            dir = target.getParentFile();
        }
        this.createDirectory(dir, packFile, pack);
        this.getUninstallData().addFile(path, pack.isUninstall());
        if (packFile.isDirectory()) {
            return;
        }
        this.listeners.beforeFile(target, packFile, pack);
        this.listener.progress(fileNo, path);
        if (target.exists() && packFile.override() != OverrideType.OVERRIDE_TRUE && !this.isOverwriteFile(packFile, target)) {
            if (!(packFile.isBackReference() || pack.isLoose() || packFile.isPack200Jar())) {
                long size = packFile.size();
                logger.fine("|- No overwrite - skipping pack stream by " + size + " bytes");
                this.skip(packInputStream, size);
            }
        } else {
            this.handleOverrideRename(packFile, target);
            this.extract(packFile, target, packInputStream, pack, queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extract(PackFile packFile, File target, InputStream packInputStream, Pack pack, FileQueue queue) throws IOException {
        InputStream packStream;
        block7: {
            packStream = null;
            try {
                if (!pack.isLoose() && packFile.isBackReference()) {
                    PackFile linkedPackFile = packFile.getLinkedPackFile();
                    packStream = this.resources.getInputStream("/resources/" + linkedPackFile.getStreamResourceName());
                    if (!packFile.isPack200Jar()) {
                        long size = linkedPackFile.getStreamOffset();
                        logger.fine("|- Backreference to pack stream (offset: " + size + " bytes");
                        this.skip(packStream, size);
                    }
                } else {
                    packStream = packFile.isPack200Jar() ? this.resources.getInputStream("/resources/" + packFile.getStreamResourceName()) : new NoCloseInputStream(packInputStream);
                }
                FileUnpacker unpacker = this.createFileUnpacker(packFile, pack, queue, this.cancellable);
                logger.fine("|- Extracting file using " + unpacker.getClass().getName() + ")");
                unpacker.unpack(packFile, packStream, target);
                this.checkInterrupt();
                if (unpacker.isQueued()) break block7;
                this.listeners.afterFile(target, packFile, pack);
            }
            catch (Throwable throwable) {
                if (!(packStream instanceof NoCloseInputStream)) {
                    IOUtils.closeQuietly(packStream);
                }
                throw throwable;
            }
        }
        if (!(packStream instanceof NoCloseInputStream)) {
            IOUtils.closeQuietly(packStream);
        }
    }

    protected void skip(PackFile packFile, Pack pack, InputStream packInputStream) throws IOException {
        if (!(pack.isLoose() || packFile.isBackReference() || packFile.isPack200Jar())) {
            long size = packFile.size();
            logger.fine("|- Condition not fulfilled - skipping pack stream " + packFile.getTargetPath() + " by " + size + " bytes ");
            this.skip(packInputStream, packFile.size());
        }
    }

    protected FileUnpacker createFileUnpacker(PackFile file, Pack pack, FileQueue queue, Cancellable cancellable) throws InstallerException {
        PackCompression compressionFormat = this.getInstallData().getInfo().getCompressionFormat();
        FileUnpacker unpacker = pack.isLoose() ? new LooseFileUnpacker(cancellable, queue, this.prompt) : (file.isPack200Jar() ? new Pack200FileUnpacker(cancellable, this.resources, queue) : (compressionFormat != PackCompression.DEFAULT ? new CompressedFileUnpacker(cancellable, queue, compressionFormat) : new DefaultFileUnpacker(cancellable, queue)));
        return unpacker;
    }

    protected void postUnpack(List<Pack> packs, FileQueue queue) throws IOException, InstallerException {
        InstallData installData = this.getInstallData();
        if (queue != null && !queue.isEmpty()) {
            queue.execute();
            installData.setRebootNecessary(queue.isRebootNecessary());
        }
        this.checkInterrupt();
        this.listeners.afterPacks(packs, this.listener);
        this.checkInterrupt();
        this.writeInstallationInformation();
        this.listener.stopAction();
    }

    protected void cleanup() {
        this.state = State.READY;
    }

    protected InstallData getInstallData() {
        return this.installData;
    }

    protected UninstallData getUninstallData() {
        return this.uninstallData;
    }

    protected PackResources getResources() {
        return this.resources;
    }

    protected VariableSubstitutor getVariableSubstitutor() {
        return this.variableSubstitutor;
    }

    protected Prompt getPrompt() {
        return this.prompt;
    }

    protected boolean shouldUnpack(Pack pack) {
        return this.selectedPacks.contains(pack) && (!pack.hasCondition() || this.rules.isConditionTrue(pack.getCondition()));
    }

    protected void setResult(boolean result) {
        this.result = result;
    }

    protected boolean isConditionTrue(String id) {
        return this.rules.isConditionTrue(id);
    }

    protected String getStepName(Pack pack) {
        if (this.packMessages == null && this.messages != null) {
            try {
                this.packMessages = this.messages.newMessages("packsLang.xml");
            }
            catch (Exception ex) {
                logger.fine(ex.getLocalizedMessage());
            }
        }
        return pack.isHidden() ? "" : PackHelper.getPackName(pack, this.packMessages);
    }

    protected void createDirectory(File dir, PackFile file, Pack pack) {
        if (!dir.exists()) {
            if (!this.listeners.isFileListener()) {
                if (!dir.mkdirs()) {
                    throw new IzPackException("Could not create directory: " + dir.getPath());
                }
            } else {
                File parent = dir.getParentFile();
                if (parent != null) {
                    this.createDirectory(parent, file, pack);
                }
                this.listeners.beforeDir(dir, file, pack);
                if (!dir.mkdir()) {
                    throw new IzPackException("Could not create directory: " + dir.getPath());
                }
                this.listeners.afterDir(dir, file, pack);
            }
        }
    }

    private void parseFiles(List<ParsableFile> files) {
        if (!files.isEmpty()) {
            ScriptParser parser = new ScriptParser(this.getVariableSubstitutor(), this.matcher);
            for (ParsableFile file : files) {
                try {
                    parser.parse(file);
                }
                catch (Exception exception) {
                    throw new InstallerException("Failed to parse: " + file.getPath(), exception);
                }
                this.checkInterrupt();
            }
        }
    }

    private void executeFiles(List<ExecutableFile> executables) {
        ProgressHandler handler;
        FileExecutor executor;
        if (!executables.isEmpty() && (executor = new FileExecutor(executables)).executeFiles(0, this.matcher, handler = new ProgressHandler(this.listener, this.prompt)) != 0) {
            throw new InstallerException("File execution failed");
        }
    }

    protected synchronized boolean isInterrupted() {
        boolean result = false;
        if (this.state == State.INTERRUPT) {
            this.setResult(false);
            this.state = State.INTERRUPTED;
            result = true;
            this.notifyAll();
        } else if (this.state == State.INTERRUPTED) {
            result = true;
        }
        return result;
    }

    protected void checkInterrupt() {
        if (this.isInterrupted()) {
            throw new ResourceInterruptedException("Installation cancelled");
        }
    }

    protected void performUpdateChecks(List<UpdateCheck> checks) {
        if (checks != null && !checks.isEmpty()) {
            File[] files;
            File d;
            logger.info("Cleaning up the target folder ...");
            File absoluteInstallPath = new File(this.installData.getInstallPath()).getAbsoluteFile();
            FileSet fileset = new FileSet();
            ArrayList<File> filesToDelete = new ArrayList<File>();
            ArrayList<File> dirsToDelete = new ArrayList<File>();
            try {
                fileset.setDir(absoluteInstallPath);
                for (UpdateCheck check : checks) {
                    if (check.includesList != null) {
                        for (String include : check.includesList) {
                            fileset.createInclude().setName(this.variableSubstitutor.substitute(include));
                        }
                    }
                    if (check.excludesList == null) continue;
                    for (String exclude : check.excludesList) {
                        fileset.createExclude().setName(this.variableSubstitutor.substitute(exclude));
                    }
                }
                DirectoryScanner scanner = fileset.getDirectoryScanner();
                scanner.scan();
                String[] srcFiles = scanner.getIncludedFiles();
                String[] srcDirs = scanner.getIncludedDirectories();
                TreeSet<File> installedFiles = new TreeSet<File>();
                for (String name : this.uninstallData.getInstalledFilesList()) {
                    File file = new File(name);
                    if (!file.isAbsolute()) {
                        file = new File(absoluteInstallPath, name);
                    }
                    installedFiles.add(file);
                }
                for (String srcFile : srcFiles) {
                    File newFile = new File(scanner.getBasedir(), srcFile);
                    if (installedFiles.contains(newFile)) continue;
                    filesToDelete.add(newFile);
                }
                for (String srcDir : srcDirs) {
                    File newDir;
                    if (srcDir.isEmpty() || installedFiles.contains(newDir = new File(scanner.getBasedir(), srcDir))) continue;
                    dirsToDelete.add(newDir);
                }
            }
            catch (IzPackException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new IzPackException(exception);
            }
            for (File f : filesToDelete) {
                if (!f.delete()) {
                    logger.warning("Cleanup: Unable to delete file " + f);
                    continue;
                }
                logger.fine("Cleanup: Deleted file " + f);
            }
            Collections.sort(dirsToDelete);
            Collections.reverse(dirsToDelete);
            Iterator<UpdateCheck> i$ = dirsToDelete.iterator();
            while (i$.hasNext() && (d = (File)((Object)i$.next())).exists() && ((files = d.listFiles()) == null || files.length == 0)) {
                if (!d.delete()) {
                    logger.warning("Cleanup: Unable to delete directory " + d);
                    continue;
                }
                logger.fine("Cleanup: Deleted directory " + d);
            }
        }
    }

    protected void writeInstallationInformation() throws IOException {
        if (!this.installData.getInfo().isWriteInstallationInformation()) {
            logger.fine("Skip writing installation information");
            return;
        }
        logger.fine("Writing installation information");
        String installDir = this.installData.getInstallPath();
        ArrayList<Pack> installedPacks = new ArrayList<Pack>(this.selectedPacks);
        File installationInfo = new File(installDir + File.separator + ".installationinformation");
        if (!installationInfo.exists()) {
            logger.fine("Creating info file " + installationInfo.getAbsolutePath());
            File dir = new File(this.installData.getInstallPath());
            if (!dir.exists() && !dir.mkdirs()) {
                throw new InstallerException("Failed to create directory: " + dir);
            }
            if (!installationInfo.createNewFile()) {
                throw new InstallerException("Failed to create file: " + installationInfo);
            }
        } else {
            List packs;
            logger.fine("Previous installation information found");
            FileInputStream fin = new FileInputStream(installationInfo);
            ObjectInputStream oin = new ObjectInputStream(fin);
            try {
                packs = (List)oin.readObject();
            }
            catch (Exception exception) {
                throw new InstallerException("Failed to read previous installation information", exception);
            }
            finally {
                IOUtils.closeQuietly(oin);
                IOUtils.closeQuietly(fin);
            }
            installedPacks.addAll(packs);
        }
        FileOutputStream fout = new FileOutputStream(installationInfo);
        ObjectOutputStream oout = new ObjectOutputStream(fout);
        oout.writeObject(installedPacks);
        oout.writeObject(this.variables.getProperties());
        logger.fine("Writing installation information finished");
        IOUtils.closeQuietly(oout);
        IOUtils.closeQuietly(fout);
        this.uninstallData.addFile(installationInfo.getAbsolutePath(), true);
    }

    protected void skip(InputStream stream, long bytes) throws IOException {
        long skipped = stream.skip(bytes);
        if (skipped != bytes) {
            throw new IOException("Expected to skip: " + bytes + " in stream but skipped: " + skipped);
        }
    }

    protected boolean isOverwriteFile(PackFile pf, File file) {
        boolean result = false;
        if (pf.override() != OverrideType.OVERRIDE_FALSE) {
            if (pf.override() == OverrideType.OVERRIDE_TRUE) {
                result = true;
            } else if (pf.override() == OverrideType.OVERRIDE_UPDATE) {
                result = file.lastModified() < pf.lastModified();
            } else {
                Prompt.Option answer;
                Prompt.Option defChoice = null;
                if (pf.override() == OverrideType.OVERRIDE_ASK_FALSE) {
                    defChoice = Prompt.Option.NO;
                } else if (pf.override() == OverrideType.OVERRIDE_ASK_TRUE) {
                    defChoice = Prompt.Option.YES;
                }
                result = Installer.getInstallerMode() == 1 ? defChoice == Prompt.Option.YES : (answer = this.prompt.confirm(Prompt.Type.QUESTION, this.messages.get("InstallPanel.overwrite.title", new Object[0]) + " - " + file.getName(), this.messages.get("InstallPanel.overwrite.question", new Object[0]) + file.getAbsolutePath(), Prompt.Options.YES_NO, defChoice)) == Prompt.Option.YES;
            }
        }
        return result;
    }

    protected void handleOverrideRename(PackFile pf, File file) {
        if (file.exists() && pf.overrideRenameTo() != null) {
            GlobPatternMapper mapper = new GlobPatternMapper();
            mapper.setFrom("*");
            mapper.setTo(pf.overrideRenameTo());
            mapper.setCaseSensitive(true);
            String[] newFileNameArr = mapper.mapFileName(file.getName());
            if (newFileNameArr != null) {
                String newFileName = newFileNameArr[0];
                File newPathFile = new File(file.getParent(), newFileName);
                if (newPathFile.exists() && !newPathFile.delete()) {
                    logger.warning("Failed to delete: " + newPathFile);
                }
                if (!file.renameTo(newPathFile)) {
                    throw new InstallerException("The file " + file + " could not be renamed to " + newPathFile);
                }
            } else {
                throw new InstallerException("File name " + file.getName() + " cannot be mapped using the expression \"" + pf.overrideRenameTo() + "\"");
            }
        }
    }

    protected void readParsableFiles(PackInfo packInfo, List<ParsableFile> parsables) {
        for (ParsableFile parsableFile : packInfo.getParsables()) {
            logger.fine("Unpacked parsable: " + parsableFile.toString());
            if (parsableFile.hasCondition() && !this.isConditionTrue(parsableFile.getCondition())) continue;
            String path = IoHelper.translatePath(parsableFile.getPath(), this.variables);
            parsableFile.setPath(path);
            parsables.add(parsableFile);
        }
    }

    protected void readExecutableFiles(PackInfo packInfo, List<ExecutableFile> executables) {
        for (ExecutableFile executableFile : packInfo.getExecutables()) {
            logger.fine("Unpacked executable: " + executableFile.toString());
            if (executableFile.hasCondition() && !this.isConditionTrue(executableFile.getCondition())) continue;
            executableFile.path = IoHelper.translatePath(executableFile.path, this.variables);
            if (null != executableFile.argList && !executableFile.argList.isEmpty()) {
                for (int j = 0; j < executableFile.argList.size(); ++j) {
                    String arg = executableFile.argList.get(j);
                    arg = IoHelper.translatePath(arg, this.variables);
                    executableFile.argList.set(j, arg);
                }
            }
            executables.add(executableFile);
            if (executableFile.executionStage != 2) continue;
            this.uninstallData.addExecutable(executableFile);
        }
    }

    protected void readUpdateChecks(PackInfo packInfo, List<UpdateCheck> updateChecks) {
        updateChecks.addAll(packInfo.getUpdateChecks());
    }

    private void resetLogging() {
        try {
            LogUtils.loadConfiguration(ResourceManager.getInstallLoggingConfigurationResourceName(), this.variables);
        }
        catch (IOException e) {
            throw new IzPackException(e, Prompt.Type.WARNING);
        }
        logger = Logger.getLogger(UnpackerBase.class.getName());
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$com$izforge$izpack$api$handler$Prompt$Type;

        static {
            $SwitchMap$com$izforge$izpack$api$handler$Prompt$Type = new int[Prompt.Type.values().length];
            try {
                2.$SwitchMap$com$izforge$izpack$api$handler$Prompt$Type[Prompt.Type.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$izforge$izpack$api$handler$Prompt$Type[Prompt.Type.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private static enum State {
        READY,
        UNPACKING,
        INTERRUPT,
        INTERRUPTED;

    }
}

