/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.syncope.common.lib.info.NumbersInfo;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Syncope")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="")
public interface SyncopeService
extends JAXRSService {
    @GET
    @Path(value="/platform")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public PlatformInfo platform();

    @GET
    @Path(value="/system")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public SystemInfo system();

    @GET
    @Path(value="/numbers")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public NumbersInfo numbers();

    @POST
    @Path(value="/assignableGroups/{realm:.*}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public PagedResult<GroupTO> searchAssignableGroups(@NotNull @PathParam(value="realm") String var1, @QueryParam(value="term") String var2, @Min(value=1L) @QueryParam(value="page") @DefaultValue(value="1") int var3, @Min(value=1L) @QueryParam(value="size") @DefaultValue(value="25") int var4);

    @GET
    @Path(value="/userTypeExtension/{groupName}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public TypeExtensionTO readUserTypeExtension(@NotNull @PathParam(value="groupName") String var1);
}

