/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.patch.AssociationPatch;
import org.apache.syncope.common.lib.patch.DeassociationPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.BulkAction;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.ResourceAssociationAction;
import org.apache.syncope.common.lib.types.ResourceDeassociationAction;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

public interface AnyService<TO extends AnyTO>
extends JAXRSService {
    @GET
    @Path(value="{key}/{schemaType}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Set<AttrTO> read(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="schemaType") SchemaType var2);

    @GET
    @Path(value="{key}/{schemaType}/{schema}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public AttrTO read(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="schemaType") SchemaType var2, @NotNull @PathParam(value="schema") String var3);

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public TO read(@NotNull @PathParam(value="key") String var1);

    @GET
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public PagedResult<TO> search(@BeanParam AnyQuery var1);

    @Parameter(name="schema", description="Attribute schema's key", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @PUT
    @Path(value="{key}/{schemaType}/{schema}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response update(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="schemaType") SchemaType var2, @NotNull AttrTO var3);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{key}/{schemaType}/{schema}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="schemaType") SchemaType var2, @NotNull @PathParam(value="schema") String var3);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="If-Match", in=ParameterIn.HEADER, description="When the provided ETag value does not match the latest modification date of the entity, an error is reported and the requested operation is not performed.", allowEmptyValue=true, schema=@Schema(type="string")), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User, Group or Any Object successfully deleted enriched with propagation status information, as Entity", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")}), @ApiResponse(responseCode="412", description="The ETag value provided via the 'If-Match' header does not match the latest modification date of the entity")})
    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response delete(@NotNull @PathParam(value="key") String var1);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="If-Match", in=ParameterIn.HEADER, description="When the provided ETag value does not match the latest modification date of the entity, an error is reported and the requested operation is not performed.", allowEmptyValue=true, schema=@Schema(type="string")), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false")), @Parameter(name="key", description="Entity's key", in=ParameterIn.PATH, schema=@Schema(type="string")), @Parameter(name="action", description="Deassociation action", in=ParameterIn.PATH, schema=@Schema(implementation=ResourceDeassociationAction.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Bulk action result", content={@Content(schema=@Schema(implementation=BulkActionResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")}), @ApiResponse(responseCode="412", description="The ETag value provided via the 'If-Match' header does not match the latest modification date of the entity")})
    @POST
    @Path(value="{key}/deassociate/{action}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response deassociate(@NotNull DeassociationPatch var1);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="If-Match", in=ParameterIn.HEADER, description="When the provided ETag value does not match the latest modification date of the entity, an error is reported and the requested operation is not performed.", allowEmptyValue=true, schema=@Schema(type="string")), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false")), @Parameter(name="key", description="Entity's key", in=ParameterIn.PATH, schema=@Schema(type="string")), @Parameter(name="action", description="Association action", in=ParameterIn.PATH, schema=@Schema(implementation=ResourceAssociationAction.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Bulk action result", content={@Content(schema=@Schema(implementation=BulkActionResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")}), @ApiResponse(responseCode="412", description="The ETag value provided via the 'If-Match' header does not match the latest modification date of the entity")})
    @POST
    @Path(value="{key}/associate/{action}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response associate(@NotNull AssociationPatch var1);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Bulk action result", content={@Content(schema=@Schema(implementation=BulkActionResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @POST
    @Path(value="bulk")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response bulk(@NotNull BulkAction var1);
}

