/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.info;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.info.JavaImplInfo;
import org.apache.syncope.common.lib.types.ImplementationType;

@XmlRootElement(name="platformInfo")
@XmlType
public class PlatformInfo
extends AbstractBaseBean {
    private static final long serialVersionUID = -7941853999417673827L;
    private String version;
    private String buildNumber;
    private boolean selfRegAllowed;
    private boolean pwdResetAllowed;
    private boolean pwdResetRequiringSecurityQuestions;
    private final Set<String> connIdLocations = new HashSet<String>();
    private String propagationTaskExecutor;
    private String anyObjectWorkflowAdapter;
    private String userWorkflowAdapter;
    private String groupWorkflowAdapter;
    private String anyObjectProvisioningManager;
    private String userProvisioningManager;
    private String groupProvisioningManager;
    private String virAttrCache;
    private String passwordGenerator;
    private String anySearchDAO;
    private final List<String> anyTypes = new ArrayList<String>();
    private final List<String> userClasses = new ArrayList<String>();
    private final List<String> anyTypeClasses = new ArrayList<String>();
    private final List<String> resources = new ArrayList<String>();
    private final Set<String> entitlements = new HashSet<String>();
    private final Set<JavaImplInfo> javaImplInfos = new HashSet<JavaImplInfo>();

    public String getVersion() {
        return this.version;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public boolean isSelfRegAllowed() {
        return this.selfRegAllowed;
    }

    public boolean isPwdResetAllowed() {
        return this.pwdResetAllowed;
    }

    public boolean isPwdResetRequiringSecurityQuestions() {
        return this.pwdResetRequiringSecurityQuestions;
    }

    @XmlElementWrapper(name="connIdLocations")
    @XmlElement(name="connIdLocation")
    @JsonProperty(value="connIdLocations")
    public Set<String> getConnIdLocations() {
        return this.connIdLocations;
    }

    public String getPropagationTaskExecutor() {
        return this.propagationTaskExecutor;
    }

    public String getAnyObjectWorkflowAdapter() {
        return this.anyObjectWorkflowAdapter;
    }

    public String getUserWorkflowAdapter() {
        return this.userWorkflowAdapter;
    }

    public String getGroupWorkflowAdapter() {
        return this.groupWorkflowAdapter;
    }

    public String getAnyObjectProvisioningManager() {
        return this.anyObjectProvisioningManager;
    }

    public String getUserProvisioningManager() {
        return this.userProvisioningManager;
    }

    public String getGroupProvisioningManager() {
        return this.groupProvisioningManager;
    }

    public String getVirAttrCache() {
        return this.virAttrCache;
    }

    public String getPasswordGenerator() {
        return this.passwordGenerator;
    }

    public void setPasswordGenerator(String passwordGenerator) {
        this.passwordGenerator = passwordGenerator;
    }

    public String getAnySearchDAO() {
        return this.anySearchDAO;
    }

    public void setAnySearchDAO(String anySearchDAO) {
        this.anySearchDAO = anySearchDAO;
    }

    @XmlElementWrapper(name="anyTypes")
    @XmlElement(name="anyType")
    @JsonProperty(value="anyTypes")
    public List<String> getAnyTypes() {
        return this.anyTypes;
    }

    @XmlElementWrapper(name="userClasses")
    @XmlElement(name="userClass")
    @JsonProperty(value="userClasses")
    public List<String> getUserClasses() {
        return this.userClasses;
    }

    @XmlElementWrapper(name="anyTypeClasses")
    @XmlElement(name="anyTypeClass")
    @JsonProperty(value="anyTypeClasses")
    public List<String> getAnyTypeClasses() {
        return this.anyTypeClasses;
    }

    @XmlElementWrapper(name="resources")
    @XmlElement(name="resource")
    @JsonProperty(value="resources")
    public List<String> getResources() {
        return this.resources;
    }

    @XmlElementWrapper(name="entitlements")
    @XmlElement(name="entitlement")
    @JsonProperty(value="entitlements")
    public Set<String> getEntitlements() {
        return this.entitlements;
    }

    @JsonIgnore
    public Optional<JavaImplInfo> getJavaImplInfo(ImplementationType type) {
        return this.javaImplInfos.stream().filter(javaImplInfo -> javaImplInfo.getType() == type).findFirst();
    }

    @XmlElementWrapper(name="javaImplInfos")
    @XmlElement(name="javaImplInfo")
    @JsonProperty(value="javaImplInfos")
    public Set<JavaImplInfo> getJavaImplInfos() {
        return this.javaImplInfos;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public void setSelfRegAllowed(boolean selfRegAllowed) {
        this.selfRegAllowed = selfRegAllowed;
    }

    public void setPwdResetAllowed(boolean pwdResetAllowed) {
        this.pwdResetAllowed = pwdResetAllowed;
    }

    public void setPwdResetRequiringSecurityQuestions(boolean pwdResetRequiringSecurityQuestions) {
        this.pwdResetRequiringSecurityQuestions = pwdResetRequiringSecurityQuestions;
    }

    public void setPropagationTaskExecutor(String propagationTaskExecutor) {
        this.propagationTaskExecutor = propagationTaskExecutor;
    }

    public void setAnyObjectWorkflowAdapter(String anyObjectWorkflowAdapter) {
        this.anyObjectWorkflowAdapter = anyObjectWorkflowAdapter;
    }

    public void setUserWorkflowAdapter(String userWorkflowAdapter) {
        this.userWorkflowAdapter = userWorkflowAdapter;
    }

    public void setGroupWorkflowAdapter(String groupWorkflowAdapter) {
        this.groupWorkflowAdapter = groupWorkflowAdapter;
    }

    public void setAnyObjectProvisioningManager(String anyObjectProvisioningManager) {
        this.anyObjectProvisioningManager = anyObjectProvisioningManager;
    }

    public void setUserProvisioningManager(String userProvisioningManager) {
        this.userProvisioningManager = userProvisioningManager;
    }

    public void setGroupProvisioningManager(String groupProvisioningManager) {
        this.groupProvisioningManager = groupProvisioningManager;
    }

    public void setVirAttrCache(String virAttrCache) {
        this.virAttrCache = virAttrCache;
    }
}

