/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.user;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.syncope.client.cli.SyncopeServices;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.to.BulkAction;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.service.UserService;

public class UserSyncopeOperations {
    private static final int PAGE_SIZE = 100;
    private final UserService userService = SyncopeServices.get(UserService.class);

    public boolean auth(String username, String password) {
        try {
            SyncopeServices.testUsernameAndPassword(username, password);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<UserTO> searchByRole(String realm, String role) {
        return this.search((AnyQuery)new AnyQuery.Builder().realm(realm).fiql(SyncopeClient.getUserSearchConditionBuilder().inRoles(role, new String[0]).query()).build());
    }

    public List<UserTO> searchByResource(String realm, String resource) {
        return this.search((AnyQuery)new AnyQuery.Builder().realm(realm).fiql(SyncopeClient.getUserSearchConditionBuilder().hasResources(resource, new String[0]).query()).build());
    }

    public List<UserTO> searchByAttribute(String realm, String attributeName, String attributeValue) {
        return this.search((AnyQuery)new AnyQuery.Builder().realm(realm).fiql(SyncopeClient.getUserSearchConditionBuilder().is(attributeName).equalTo(attributeValue, new String[0]).query()).build());
    }

    public List<UserTO> list() {
        return this.search(new AnyQuery());
    }

    private List<UserTO> search(AnyQuery query) {
        query.setPage(Integer.valueOf(0));
        query.setSize(Integer.valueOf(0));
        int count = this.userService.search(query).getTotalCount();
        ArrayList<UserTO> result = new ArrayList<UserTO>();
        query.setSize(Integer.valueOf(100));
        for (int page = 1; page <= count / 100 + 1; ++page) {
            query.setPage(Integer.valueOf(page));
            result.addAll(this.userService.search(query).getResult());
        }
        return result;
    }

    public UserTO read(String userKey) {
        return this.userService.read(userKey);
    }

    public void delete(String userKey) {
        this.userService.delete(userKey);
    }

    public Map<String, BulkActionResult.Status> deleteByAttribute(String realm, String attributeName, String attributeValue) {
        return this.bulkDelete((AnyQuery)new AnyQuery.Builder().realm(realm).fiql(SyncopeClient.getUserSearchConditionBuilder().is(attributeName).equalTo(attributeValue, new String[0]).query()).build());
    }

    public Map<String, BulkActionResult.Status> deleteAll(String realm) {
        return this.bulkDelete((AnyQuery)new AnyQuery.Builder().realm(realm).details(false).build());
    }

    private Map<String, BulkActionResult.Status> bulkDelete(AnyQuery query) {
        query.setPage(Integer.valueOf(0));
        query.setSize(Integer.valueOf(0));
        int count = this.userService.search(query).getTotalCount();
        BulkAction bulkAction = new BulkAction();
        bulkAction.setType(BulkAction.Type.DELETE);
        query.setSize(Integer.valueOf(100));
        for (int page = 1; page <= count / 100 + 1; ++page) {
            query.setPage(Integer.valueOf(page));
            bulkAction.getTargets().addAll(this.userService.search(query).getResult().stream().map(EntityTO::getKey).collect(Collectors.toList()));
        }
        return ((BulkActionResult)this.userService.bulk(bulkAction).readEntity(BulkActionResult.class)).getResults();
    }
}

