/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.task;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.task.AbstractTaskCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutionDelete
extends AbstractTaskCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutionDelete.class);
    private static final String DELETE_HELP_MESSAGE = "task --delete-execution {TASK-EXEC-KEY} {TASK-EXEC-KEY} [...]";
    private final Input input;

    public TaskExecutionDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.taskSyncopeOperations.deleteExecution(parameter);
                    this.taskResultManager.deletedMessage("Task execution", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error deleting execution", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.taskResultManager.notFoundError("Task execution", parameter);
                        continue;
                    }
                    if (ex.getMessage().startsWith("DataIntegrityViolation")) {
                        this.taskResultManager.genericError("You cannot delete task execution" + parameter);
                        continue;
                    }
                    this.taskResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error deleting execution", (Throwable)ex);
                    this.taskResultManager.notBooleanDeletedError("task execution", parameter);
                }
            }
        } else {
            this.taskResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

