/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.task;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.task.TaskDelete;
import org.apache.syncope.client.cli.commands.task.TaskDeleteAllProp;
import org.apache.syncope.client.cli.commands.task.TaskDetails;
import org.apache.syncope.client.cli.commands.task.TaskExecute;
import org.apache.syncope.client.cli.commands.task.TaskExecutionDelete;
import org.apache.syncope.client.cli.commands.task.TaskList;
import org.apache.syncope.client.cli.commands.task.TaskListJobs;
import org.apache.syncope.client.cli.commands.task.TaskRead;
import org.apache.syncope.client.cli.commands.task.TaskResultManager;

@Command(name="task")
public class TaskCommand
extends AbstractCommand {
    private final TaskResultManager taskResultManager = new TaskResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(Options.HELP.getOptionName());
        }
        switch (Options.fromName(input.getOption())) {
            case DETAILS: {
                new TaskDetails(input).details();
                break;
            }
            case LIST: {
                new TaskList(input).list();
                break;
            }
            case LIST_JOBS: {
                new TaskListJobs(input).list();
                break;
            }
            case READ: {
                new TaskRead(input).read();
                break;
            }
            case DELETE: {
                new TaskDelete(input).delete();
                break;
            }
            case DELETE_PROP_TASK: {
                new TaskDeleteAllProp(input).delete();
                break;
            }
            case DELETE_EXECUTION: {
                new TaskExecutionDelete(input).delete();
                break;
            }
            case EXECUTE: {
                new TaskExecute(input).execute();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.taskResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.taskResultManager.commandHelpMessage(this.getClass());
    }

    private static enum Options {
        HELP("--help"),
        DETAILS("--details"),
        LIST("--list"),
        LIST_JOBS("--list-jobs"),
        READ("--read"),
        DELETE("--delete"),
        DELETE_PROP_TASK("--delete-all-prop"),
        DELETE_EXECUTION("--delete-execution"),
        EXECUTE("--execute");

        private final String optionName;

        private Options(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static Options fromName(String name) {
            Options optionToReturn = HELP;
            for (Options option : Options.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (Options value : Options.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

