/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.TimeZone;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class ClientProperties
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private int browserHeight = -1;
    private boolean browserInternetExplorer;
    private boolean browserKonqueror;
    private boolean browserMozilla;
    private boolean browserMozillaFirefox;
    private boolean browserOpera;
    private boolean browserSafari;
    private boolean browserChrome;
    private boolean browserEdge;
    private int browserVersionMajor = -1;
    private int browserVersionMinor = -1;
    private int browserWidth = -1;
    private boolean navigatorCookieEnabled;
    private boolean navigatorJavaEnabled;
    private String navigatorAppCodeName;
    private String navigatorAppName;
    private String navigatorAppVersion;
    private String navigatorLanguage;
    private String navigatorPlatform;
    private String navigatorUserAgent;
    private String remoteAddress;
    private int screenColorDepth = -1;
    private int screenHeight = -1;
    private int screenWidth = -1;
    private String utcDSTOffset;
    private String utcOffset;
    private String hostname;
    private boolean javaScriptEnabled;
    private transient TimeZone timeZone;

    public int getBrowserHeight() {
        return this.browserHeight;
    }

    public int getBrowserVersionMajor() {
        return this.browserVersionMajor;
    }

    public int getBrowserVersionMinor() {
        return this.browserVersionMinor;
    }

    public int getBrowserWidth() {
        return this.browserWidth;
    }

    public String getNavigatorAppCodeName() {
        return this.navigatorAppCodeName;
    }

    public String getNavigatorAppName() {
        return this.navigatorAppName;
    }

    public String getNavigatorAppVersion() {
        return this.navigatorAppVersion;
    }

    public String getNavigatorLanguage() {
        return this.navigatorLanguage;
    }

    public String getNavigatorPlatform() {
        return this.navigatorPlatform;
    }

    public String getNavigatorUserAgent() {
        return this.navigatorUserAgent;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getScreenColorDepth() {
        return this.screenColorDepth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public TimeZone getTimeZone() {
        String utc;
        if (this.timeZone == null && (utc = this.getUtcOffset()) != null) {
            int dotPos = utc.indexOf(46);
            if (dotPos >= 0) {
                String hours = utc.substring(0, dotPos);
                String hourPart = utc.substring(dotPos + 1);
                if (hours.startsWith("+")) {
                    hours = hours.substring(1);
                }
                int offsetHours = Integer.parseInt(hours);
                int offsetMins = (int)(Double.parseDouble(hourPart) * 6.0);
                AppendingStringBuffer sb = new AppendingStringBuffer((CharSequence)"GMT");
                sb.append(offsetHours > 0 ? (char)'+' : '-');
                sb.append(Math.abs(offsetHours));
                sb.append(':');
                if (offsetMins < 10) {
                    sb.append('0');
                }
                sb.append(offsetMins);
                this.timeZone = TimeZone.getTimeZone(sb.toString());
            } else {
                int offset = Integer.parseInt(utc);
                if (offset < 0) {
                    utc = utc.substring(1);
                }
                this.timeZone = TimeZone.getTimeZone("GMT" + (offset > 0 ? (char)'+' : '-') + utc);
            }
            String dstOffset = this.getUtcDSTOffset();
            if (this.timeZone != null && dstOffset != null) {
                TimeZone dstTimeZone;
                dotPos = dstOffset.indexOf(46);
                if (dotPos >= 0) {
                    String hours = dstOffset.substring(0, dotPos);
                    String hourPart = dstOffset.substring(dotPos + 1);
                    if (hours.startsWith("+")) {
                        hours = hours.substring(1);
                    }
                    int offsetHours = Integer.parseInt(hours);
                    int offsetMins = (int)(Double.parseDouble(hourPart) * 6.0);
                    AppendingStringBuffer sb = new AppendingStringBuffer((CharSequence)"GMT");
                    sb.append(offsetHours > 0 ? (char)'+' : '-');
                    sb.append(Math.abs(offsetHours));
                    sb.append(':');
                    if (offsetMins < 10) {
                        sb.append('0');
                    }
                    sb.append(offsetMins);
                    dstTimeZone = TimeZone.getTimeZone(sb.toString());
                } else {
                    int offset = Integer.parseInt(dstOffset);
                    if (offset < 0) {
                        dstOffset = dstOffset.substring(1);
                    }
                    dstTimeZone = TimeZone.getTimeZone("GMT" + (offset > 0 ? (char)'+' : '-') + dstOffset);
                }
                if (dstTimeZone != null && dstTimeZone.getRawOffset() != this.timeZone.getRawOffset()) {
                    String[] availableIDs;
                    int dstSaving = dstTimeZone.getRawOffset() - this.timeZone.getRawOffset();
                    for (String availableID : availableIDs = TimeZone.getAvailableIDs(this.timeZone.getRawOffset())) {
                        TimeZone zone = TimeZone.getTimeZone(availableID);
                        if (zone.getDSTSavings() != dstSaving) continue;
                        this.timeZone = zone;
                        break;
                    }
                }
            }
        }
        return this.timeZone;
    }

    public String getUtcDSTOffset() {
        return this.utcDSTOffset;
    }

    public String getUtcOffset() {
        return this.utcOffset;
    }

    public boolean isJavaScriptEnabled() {
        return this.javaScriptEnabled;
    }

    public boolean isBrowserInternetExplorer() {
        return this.browserInternetExplorer;
    }

    public boolean isBrowserKonqueror() {
        return this.browserKonqueror;
    }

    public boolean isBrowserMozilla() {
        return this.browserMozilla;
    }

    public boolean isBrowserMozillaFirefox() {
        return this.browserMozillaFirefox;
    }

    public boolean isBrowserOpera() {
        return this.browserOpera;
    }

    public boolean isBrowserSafari() {
        return this.browserSafari;
    }

    public boolean isBrowserChrome() {
        return this.browserChrome;
    }

    public boolean isBrowserEdge() {
        return this.browserEdge;
    }

    public boolean isCookiesEnabled() {
        return this.isNavigatorCookieEnabled();
    }

    public boolean isJavaEnabled() {
        return this.isNavigatorJavaEnabled();
    }

    public boolean isNavigatorCookieEnabled() {
        if (!this.navigatorCookieEnabled && RequestCycle.get() != null) {
            List cookies = ((WebRequest)RequestCycle.get().getRequest()).getCookies();
            this.navigatorCookieEnabled = cookies != null && cookies.size() > 0;
        }
        return this.navigatorCookieEnabled;
    }

    public boolean isNavigatorJavaEnabled() {
        return this.navigatorJavaEnabled;
    }

    public void setBrowserHeight(int browserHeight) {
        this.browserHeight = browserHeight;
    }

    public void setBrowserInternetExplorer(boolean browserInternetExplorer) {
        this.browserInternetExplorer = browserInternetExplorer;
    }

    public void setBrowserKonqueror(boolean browserKonqueror) {
        this.browserKonqueror = browserKonqueror;
    }

    public void setBrowserMozilla(boolean browserMozilla) {
        this.browserMozilla = browserMozilla;
    }

    public void setBrowserMozillaFirefox(boolean browserMozillaFirefox) {
        this.browserMozillaFirefox = browserMozillaFirefox;
    }

    public void setBrowserOpera(boolean browserOpera) {
        this.browserOpera = browserOpera;
    }

    public void setBrowserSafari(boolean browserSafari) {
        this.browserSafari = browserSafari;
    }

    public void setBrowserChrome(boolean browserChrome) {
        this.browserChrome = browserChrome;
    }

    public void setBrowserEdge(boolean browserEdge) {
        this.browserEdge = browserEdge;
    }

    public void setBrowserVersionMajor(int browserVersionMajor) {
        this.browserVersionMajor = browserVersionMajor;
    }

    public void setBrowserVersionMinor(int browserVersionMinor) {
        this.browserVersionMinor = browserVersionMinor;
    }

    public void setBrowserWidth(int browserWidth) {
        this.browserWidth = browserWidth;
    }

    public void setNavigatorCookieEnabled(boolean cookiesEnabled) {
        this.navigatorCookieEnabled = cookiesEnabled;
    }

    public void setNavigatorJavaEnabled(boolean navigatorJavaEnabled) {
        this.navigatorJavaEnabled = navigatorJavaEnabled;
    }

    public void setNavigatorAppCodeName(String navigatorAppCodeName) {
        this.navigatorAppCodeName = navigatorAppCodeName;
    }

    public void setNavigatorAppName(String navigatorAppName) {
        this.navigatorAppName = navigatorAppName;
    }

    public void setNavigatorAppVersion(String navigatorAppVersion) {
        this.navigatorAppVersion = navigatorAppVersion;
    }

    public void setNavigatorLanguage(String navigatorLanguage) {
        this.navigatorLanguage = navigatorLanguage;
    }

    public void setNavigatorPlatform(String navigatorPlatform) {
        this.navigatorPlatform = navigatorPlatform;
    }

    public void setNavigatorUserAgent(String navigatorUserAgent) {
        this.navigatorUserAgent = navigatorUserAgent;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setScreenColorDepth(int screenColorDepth) {
        this.screenColorDepth = screenColorDepth;
    }

    public void setScreenHeight(int screenHeight) {
        this.screenHeight = screenHeight;
    }

    public void setScreenWidth(int screenWidth) {
        this.screenWidth = screenWidth;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setUtcDSTOffset(String utcDSTOffset) {
        this.utcDSTOffset = utcDSTOffset;
    }

    public void setUtcOffset(String utcOffset) {
        this.utcOffset = utcOffset;
    }

    public void setJavaScriptEnabled(boolean javaScriptEnabled) {
        this.javaScriptEnabled = javaScriptEnabled;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Class<?> clazz = this.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Object value;
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || field.isSynthetic()) continue;
                field.setAccessible(true);
                try {
                    value = field.get(this);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (field.getType().equals(Integer.TYPE) && Integer.valueOf(-1).equals(value)) {
                    value = null;
                }
                if (value == null) continue;
                b.append(field.getName());
                b.append('=');
                b.append(value);
                b.append('\n');
            }
        }
        return b.toString();
    }

    public void read(IRequestParameters parameters) {
        this.setNavigatorAppCodeName(parameters.getParameterValue("navigatorAppCodeName").toString("N/A"));
        this.setNavigatorAppName(parameters.getParameterValue("navigatorAppName").toString("N/A"));
        this.setNavigatorAppVersion(parameters.getParameterValue("navigatorAppVersion").toString("N/A"));
        this.setNavigatorCookieEnabled(parameters.getParameterValue("navigatorCookieEnabled").toBoolean(false));
        this.setNavigatorJavaEnabled(parameters.getParameterValue("navigatorJavaEnabled").toBoolean(false));
        this.setNavigatorLanguage(parameters.getParameterValue("navigatorLanguage").toString("N/A"));
        this.setNavigatorPlatform(parameters.getParameterValue("navigatorPlatform").toString("N/A"));
        this.setNavigatorUserAgent(parameters.getParameterValue("navigatorUserAgent").toString("N/A"));
        this.setScreenWidth(parameters.getParameterValue("screenWidth").toInt(-1));
        this.setScreenHeight(parameters.getParameterValue("screenHeight").toInt(-1));
        this.setScreenColorDepth(parameters.getParameterValue("screenColorDepth").toInt(-1));
        this.setUtcOffset(parameters.getParameterValue("utcOffset").toString(null));
        this.setUtcDSTOffset(parameters.getParameterValue("utcDSTOffset").toString(null));
        this.setBrowserWidth(parameters.getParameterValue("browserWidth").toInt(-1));
        this.setBrowserHeight(parameters.getParameterValue("browserHeight").toInt(-1));
        this.setHostname(parameters.getParameterValue("hostname").toString("N/A"));
    }
}

