/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.saml2lsp.agent;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.to.SAML2RequestTO;
import org.apache.syncope.common.rest.api.service.SAML2SPService;
import org.apache.syncope.ext.saml2lsp.agent.AbstractSAML2SPServlet;

@WebServlet(name="saml2spLogin", urlPatterns={"/saml2sp/login"})
public class Login
extends AbstractSAML2SPServlet {
    private static final long serialVersionUID = 968480296813639041L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String idp = request.getParameter("idp");
        SyncopeClient anonymous = (SyncopeClient)request.getServletContext().getAttribute("SyncopeAnonymousClient");
        try {
            SAML2RequestTO requestTO = ((SAML2SPService)anonymous.getService(SAML2SPService.class)).createLoginRequest(StringUtils.substringBefore((String)request.getRequestURL().toString(), (String)"/saml2sp"), idp);
            this.prepare(response, requestTO);
        }
        catch (Exception e) {
            LOG.error("While preparing authentication request to IdP", (Throwable)e);
            String errorURL = this.getServletContext().getInitParameter("saml2sp.login.error.url");
            if (errorURL == null) {
                request.setAttribute("exception", (Object)e);
                request.getRequestDispatcher("loginError.jsp").forward((ServletRequest)request, (ServletResponse)response);
                e.printStackTrace(response.getWriter());
            }
            response.sendRedirect(errorURL + "?errorMessage=" + URLEncoder.encode(e.getMessage(), StandardCharsets.UTF_8.name()));
        }
    }
}

