/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.CamelEntitlement;
import org.apache.syncope.core.persistence.api.DomainsHolder;
import org.apache.syncope.core.persistence.api.SyncopeLoader;
import org.apache.syncope.core.persistence.api.entity.CamelRoute;
import org.apache.syncope.core.provisioning.api.EntitlementsHolder;
import org.apache.syncope.core.provisioning.java.utils.VoidURIResolver;
import org.apache.syncope.core.spring.ResourceWithFallbackLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

@Component
public class CamelRouteLoader
implements SyncopeLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CamelRouteLoader.class);
    private static final boolean IS_JBOSS = CamelRouteLoader.isJBoss();
    @Resource(name="userRoutes")
    private ResourceWithFallbackLoader userRoutesLoader;
    @Resource(name="groupRoutes")
    private ResourceWithFallbackLoader groupRoutesLoader;
    @Resource(name="anyObjectRoutes")
    private ResourceWithFallbackLoader anyObjectRoutesLoader;
    @Autowired
    private DomainsHolder domainsHolder;

    private static boolean isJBoss() {
        try {
            Class.forName("org.jboss.vfs.VirtualFile");
            LOG.debug("Running in JBoss AS / Wildfly, disabling {}", (Object)DOMImplementationRegistry.class.getName());
            return true;
        }
        catch (Throwable ex) {
            LOG.debug("Not running in JBoss AS / Wildfly, enabling {}", (Object)DOMImplementationRegistry.class.getName());
            return false;
        }
    }

    public Integer getPriority() {
        return 1000;
    }

    public void load() {
        for (Map.Entry entry : this.domainsHolder.getDomains().entrySet()) {
            this.loadRoutes((String)entry.getKey(), (DataSource)entry.getValue(), this.userRoutesLoader.getResource(), AnyTypeKind.USER);
            this.loadRoutes((String)entry.getKey(), (DataSource)entry.getValue(), this.groupRoutesLoader.getResource(), AnyTypeKind.GROUP);
            this.loadRoutes((String)entry.getKey(), (DataSource)entry.getValue(), this.anyObjectRoutesLoader.getResource(), AnyTypeKind.ANY_OBJECT);
        }
        EntitlementsHolder.getInstance().init((Collection)CamelEntitlement.values());
    }

    private String nodeToString(Node content, DOMImplementationLS domImpl) {
        StringWriter writer = new StringWriter();
        try {
            LSSerializer serializer = domImpl.createLSSerializer();
            serializer.getDomConfig().setParameter("xml-declaration", false);
            LSOutput lso = domImpl.createLSOutput();
            lso.setCharacterStream(writer);
            serializer.write(content, lso);
        }
        catch (Exception e) {
            LOG.debug("While serializing route node", (Throwable)e);
        }
        return writer.toString();
    }

    private String nodeToString(Node content, TransformerFactory tf) {
        String output = "";
        try {
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(content), new StreamResult(writer));
            output = writer.getBuffer().toString();
        }
        catch (TransformerException e) {
            LOG.debug("While serializing route node", (Throwable)e);
        }
        return output;
    }

    private void loadRoutes(String domain, DataSource dataSource, org.springframework.core.io.Resource resource, AnyTypeKind anyTypeKind) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        boolean shouldLoadRoutes = jdbcTemplate.queryForList(String.format("SELECT * FROM %s WHERE ANYTYPEKIND = ?", CamelRoute.class.getSimpleName()), new Object[]{anyTypeKind.name()}).isEmpty();
        if (shouldLoadRoutes) {
            try {
                NodeList routeNodes;
                TransformerFactory tf = null;
                DOMImplementationLS domImpl = null;
                if (IS_JBOSS) {
                    tf = TransformerFactory.newInstance();
                    tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    tf.setURIResolver((URIResolver)new VoidURIResolver());
                    Document doc = StaxUtils.read((InputStream)resource.getInputStream());
                    routeNodes = doc.getDocumentElement().getElementsByTagName("route");
                } else {
                    DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
                    domImpl = (DOMImplementationLS)((Object)reg.getDOMImplementation("LS"));
                    LSInput lsinput = domImpl.createLSInput();
                    lsinput.setByteStream(resource.getInputStream());
                    LSParser parser = domImpl.createLSParser((short)1, null);
                    routeNodes = parser.parse(lsinput).getDocumentElement().getElementsByTagName("route");
                }
                for (int s = 0; s < routeNodes.getLength(); ++s) {
                    Node routeElement = routeNodes.item(s);
                    String routeContent = IS_JBOSS ? this.nodeToString(routeNodes.item(s), tf) : this.nodeToString(routeNodes.item(s), domImpl);
                    String routeId = ((Element)routeElement).getAttribute("id");
                    jdbcTemplate.update(String.format("INSERT INTO %s(ID, ANYTYPEKIND, CONTENT) VALUES (?, ?, ?)", CamelRoute.class.getSimpleName()), new Object[]{routeId, anyTypeKind.name(), routeContent});
                    LOG.info("[{}] Route successfully loaded: {}", (Object)domain, (Object)routeId);
                }
            }
            catch (Exception e) {
                LOG.error("[{}] Route load failed", (Object)domain, (Object)e);
            }
        }
    }
}

