/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.oidcclient.agent;

import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.common.lib.PropertyUtils;

@WebListener
public class OIDCClientAgentSetup
implements ServletContextListener {
    private static final String OIDCCLIENT_AGENT_PROPERTIES = "oidcclient-agent.properties";

    private static <T> T assertNotNull(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument '" + name + "' may not be null.");
        }
        return argument;
    }

    public void contextInitialized(ServletContextEvent sce) {
        Properties props = (Properties)PropertyUtils.read(this.getClass(), (String)OIDCCLIENT_AGENT_PROPERTIES, (String)"conf.directory").getLeft();
        String anonymousUser = props.getProperty("anonymousUser");
        OIDCClientAgentSetup.assertNotNull(anonymousUser, "<anonymousUser>");
        String anonymousKey = props.getProperty("anonymousKey");
        OIDCClientAgentSetup.assertNotNull(anonymousKey, "<anonymousKey>");
        String scheme = props.getProperty("scheme");
        OIDCClientAgentSetup.assertNotNull(scheme, "<scheme>");
        String host = props.getProperty("host");
        OIDCClientAgentSetup.assertNotNull(host, "<host>");
        String port = props.getProperty("port");
        OIDCClientAgentSetup.assertNotNull(port, "<port>");
        String rootPath = props.getProperty("rootPath");
        OIDCClientAgentSetup.assertNotNull(rootPath, "<rootPath>");
        String useGZIPCompression = props.getProperty("useGZIPCompression");
        OIDCClientAgentSetup.assertNotNull(useGZIPCompression, "<useGZIPCompression>");
        SyncopeClientFactoryBean clientFactory = new SyncopeClientFactoryBean().setAddress(scheme + "://" + host + ":" + port + "/" + rootPath).setUseCompression(BooleanUtils.toBoolean((String)useGZIPCompression));
        sce.getServletContext().setAttribute("SyncopeClientFactory", (Object)clientFactory);
        sce.getServletContext().setAttribute("SyncopeAnonymousClient", (Object)clientFactory.create((AuthenticationHandler)new AnonymousAuthenticationHandler(anonymousUser, anonymousKey)));
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

