/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ItemTO;
import org.apache.syncope.common.lib.to.OIDCProviderTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.init.OIDCClientClassPathScanImplementationLookup;
import org.apache.syncope.core.logic.model.OIDCProviderDiscoveryDocument;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.OIDCProviderDAO;
import org.apache.syncope.core.persistence.api.entity.OIDCProvider;
import org.apache.syncope.core.provisioning.api.data.OIDCProviderDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class OIDCProviderLogic
extends AbstractTransactionalLogic<OIDCProviderTO> {
    @Autowired
    private OIDCProviderDAO opDAO;
    @Autowired
    private OIDCProviderDataBinder binder;
    @Autowired
    private OIDCClientClassPathScanImplementationLookup implLookup;

    @PreAuthorize(value="isAuthenticated()")
    public Set<String> getActionsClasses() {
        return this.implLookup.getActionsClasses();
    }

    private OIDCProviderDiscoveryDocument getDiscoveryDocument(String issuer) {
        WebClient client = WebClient.create((String)(issuer + "/.well-known/openid-configuration"), Arrays.asList(new JacksonJsonProvider())).accept(new String[]{"application/json"});
        return (OIDCProviderDiscoveryDocument)client.get(OIDCProviderDiscoveryDocument.class);
    }

    @PreAuthorize(value="hasRole('OP_CREATE')")
    public String createFromDiscovery(OIDCProviderTO opTO) {
        OIDCProviderDiscoveryDocument discoveryDocument = this.getDiscoveryDocument(opTO.getIssuer());
        opTO.setAuthorizationEndpoint(discoveryDocument.getAuthorizationEndpoint());
        opTO.setIssuer(discoveryDocument.getIssuer());
        opTO.setJwksUri(discoveryDocument.getJwksUri());
        opTO.setTokenEndpoint(discoveryDocument.getTokenEndpoint());
        opTO.setUserinfoEndpoint(discoveryDocument.getUserinfoEndpoint());
        opTO.setEndSessionEndpoint(discoveryDocument.getEndSessionEndpoint());
        return this.create(opTO);
    }

    @PreAuthorize(value="hasRole('OP_CREATE')")
    public String create(OIDCProviderTO opTO) {
        if (opTO.getConnObjectKeyItem() == null) {
            ItemTO connObjectKeyItem = new ItemTO();
            connObjectKeyItem.setIntAttrName("username");
            connObjectKeyItem.setExtAttrName("email");
            opTO.setConnObjectKeyItem(connObjectKeyItem);
        }
        OIDCProvider provider = this.opDAO.save(this.binder.create(opTO));
        return provider.getKey();
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<OIDCProviderTO> list() {
        return (List)CollectionUtils.collect((Iterable)this.opDAO.findAll(), (Transformer)new Transformer<OIDCProvider, OIDCProviderTO>(){

            public OIDCProviderTO transform(OIDCProvider input) {
                return OIDCProviderLogic.this.binder.getOIDCProviderTO(input);
            }
        }, new ArrayList());
    }

    @PreAuthorize(value="hasRole('OP_READ')")
    @Transactional(readOnly=true)
    public OIDCProviderTO read(String key) {
        OIDCProvider op = this.opDAO.find(key);
        if (op == null) {
            throw new NotFoundException("OIDC Provider '" + key + "'");
        }
        return this.binder.getOIDCProviderTO(op);
    }

    @PreAuthorize(value="hasRole('OP_UPDATE')")
    public void update(OIDCProviderTO oidcProviderTO) {
        OIDCProvider oidcProvider = this.opDAO.find(oidcProviderTO.getKey());
        if (oidcProvider == null) {
            throw new NotFoundException("OIDC Provider '" + oidcProviderTO.getKey() + "'");
        }
        if (!oidcProvider.getIssuer().equals(oidcProviderTO.getIssuer())) {
            LOG.error("Issuers do not match: expected {}, found {}", (Object)oidcProvider.getIssuer(), (Object)oidcProviderTO.getIssuer());
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidEntity);
            sce.getElements().add("Issuers do not match");
            throw sce;
        }
        this.opDAO.save(this.binder.update(oidcProvider, oidcProviderTO));
    }

    @PreAuthorize(value="hasRole('OP_DELETE')")
    public void delete(String key) {
        OIDCProvider op = this.opDAO.find(key);
        if (op == null) {
            throw new NotFoundException("OIDC Provider '" + key + "'");
        }
        this.opDAO.delete(key);
    }

    protected OIDCProviderTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof OIDCProviderTO)) continue;
                key = ((OIDCProviderTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getOIDCProviderTO(this.opDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

