/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.syncope.client.console.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wizards.AbstractMappingPanel;
import org.apache.syncope.client.console.wizards.resources.ItemTransformersTogglePanel;
import org.apache.syncope.client.console.wizards.resources.JEXLTransformersTogglePanel;
import org.apache.syncope.client.console.wizards.resources.ResourceProvision;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.ItemTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.util.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceMappingPanel
extends AbstractMappingPanel {
    private static final long serialVersionUID = -7982691107029848579L;
    private static final Logger LOG = LoggerFactory.getLogger(ResourceMappingPanel.class);
    private final ResourceProvision provision;
    private final LoadableDetachableModel<List<String>> extAttrNames;

    public ResourceMappingPanel(String id, final ResourceTO resourceTO, final String adminRealm, final ResourceProvision provision, ItemTransformersTogglePanel itemTransformers, JEXLTransformersTogglePanel jexlTransformers) {
        super(id, itemTransformers, jexlTransformers, (IModel<List<ItemTO>>)new ListModel(provision.getItems()), resourceTO.getConnector() != null, false, MappingPurpose.BOTH);
        this.setOutputMarkupId(true);
        this.provision = provision;
        this.extAttrNames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return new ConnectorRestClient().getExtAttrNames(adminRealm, provision.getObjectClass(), resourceTO.getConnector(), resourceTO.getConfOverride());
            }
        };
    }

    @Override
    protected boolean hidePassword() {
        return !AnyTypeKind.USER.name().equals(this.provision.getAnyType());
    }

    @Override
    protected IModel<List<String>> getExtAttrNames() {
        return this.extAttrNames;
    }

    @Override
    protected void onBeforeRender() {
        super.onBeforeRender();
        this.passwordLabel.setVisible(AnyTypeKind.USER.name().equals(this.provision.getAnyType()));
    }

    @Override
    protected void setAttrNames(AjaxTextFieldPanel toBeUpdated) {
        toBeUpdated.setRequired(true);
        toBeUpdated.setEnabled(true);
        HashSet<String> choices = new HashSet<String>();
        if ("REALM".equals(this.provision.getAnyType())) {
            choices.add("key");
            choices.add("name");
            choices.add("fullpath");
        } else {
            AnyTypeTO anyType = null;
            try {
                anyType = this.anyTypeRestClient.read(this.provision.getAnyType());
            }
            catch (Exception e) {
                LOG.error("Could not read AnyType {}", (Object)this.provision.getAnyType(), (Object)e);
            }
            ArrayList<AnyTypeClassTO> anyTypeClassTOs = new ArrayList<AnyTypeClassTO>();
            if (anyType != null) {
                try {
                    anyTypeClassTOs.addAll(this.anyTypeClassRestClient.list(anyType.getClasses()));
                }
                catch (Exception e) {
                    LOG.error("Could not read AnyType classes for {}", (Object)anyType.getClasses(), (Object)e);
                }
            }
            for (String auxClass : this.provision.getAuxClasses()) {
                try {
                    anyTypeClassTOs.add(this.anyTypeClassRestClient.read(auxClass));
                }
                catch (Exception e) {
                    LOG.error("Could not read AnyTypeClass for {}", (Object)auxClass, (Object)e);
                }
            }
            switch (this.provision.getAnyType()) {
                case "USER": {
                    choices.addAll(ClassPathScanImplementationLookup.USER_FIELD_NAMES);
                    break;
                }
                case "GROUP": {
                    choices.addAll(ClassPathScanImplementationLookup.GROUP_FIELD_NAMES);
                    break;
                }
                default: {
                    choices.addAll(ClassPathScanImplementationLookup.ANY_OBJECT_FIELD_NAMES);
                }
            }
            for (AnyTypeClassTO anyTypeClassTO : anyTypeClassTOs) {
                choices.addAll(anyTypeClassTO.getPlainSchemas());
                choices.addAll(anyTypeClassTO.getDerSchemas());
                choices.addAll(anyTypeClassTO.getVirSchemas());
            }
        }
        ArrayList<String> names = new ArrayList<String>(choices);
        Collections.sort(names);
        toBeUpdated.setChoices(names);
    }
}

