/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.AjaxBootstrapTabbedPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ExecMessageModal;
import org.apache.syncope.client.console.reports.ReportWizardBuilder;
import org.apache.syncope.client.console.reports.ReportletDirectoryPanel;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.client.console.rest.NotificationRestClient;
import org.apache.syncope.client.console.rest.ReportRestClient;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.tasks.SchedTaskWizardBuilder;
import org.apache.syncope.client.console.wicket.ajax.IndicatorAjaxTimerBehavior;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.widgets.BaseWidget;
import org.apache.syncope.client.console.widgets.JobActionPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.time.Duration;

public class JobWidget
extends BaseWidget {
    private static final long serialVersionUID = 7667120094526529934L;
    private static final int ROWS = 5;
    private final ActionLinksTogglePanel<JobTO> actionTogglePanel;
    private final BaseModal<Serializable> modal = new BaseModal<Serializable>("modal"){
        private static final long serialVersionUID = 389935548143327858L;

        protected void onConfigure() {
            super.onConfigure();
            this.setFooterVisible(false);
        }
    };
    private final BaseModal<Serializable> detailModal = new BaseModal<Serializable>("detailModal"){
        private static final long serialVersionUID = 389935548143327858L;

        protected void onConfigure() {
            super.onConfigure();
            this.setFooterVisible(true);
        }
    };
    private final BaseModal<ReportTO> reportModal = new BaseModal<ReportTO>("reportModal"){
        private static final long serialVersionUID = 389935548143327858L;

        protected void onConfigure() {
            super.onConfigure();
            this.setFooterVisible(false);
        }
    };
    private final NotificationRestClient notificationRestClient = new NotificationRestClient();
    private final TaskRestClient taskRestClient = new TaskRestClient();
    private final ReportRestClient reportRestClient = new ReportRestClient();
    private final WebMarkupContainer container;
    private final List<JobTO> available;
    private AvailableJobsPanel availableJobsPanel;
    private final List<ExecTO> recent;
    private RecentExecPanel recentExecPanel;

    public JobWidget(String id, PageReference pageRef) {
        super(id);
        this.setOutputMarkupId(true);
        this.add(new Component[]{this.modal});
        this.modal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                JobWidget.this.modal.show(false);
            }
        });
        this.add(new Component[]{this.detailModal});
        this.detailModal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                JobWidget.this.detailModal.show(false);
            }
        });
        this.add(new Component[]{this.reportModal});
        this.reportModal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                JobWidget.this.reportModal.show(false);
            }
        });
        this.reportModal.size(Modal.Size.Large);
        this.available = this.getUpdatedAvailable();
        this.recent = this.getUpdatedRecent();
        this.container = new WebMarkupContainer("jobContainer");
        this.container.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.seconds((int)10)){
            private static final long serialVersionUID = 7298597675929755960L;

            protected void onTimer(AjaxRequestTarget target) {
                List updatedRecent;
                List updatedAvailable = JobWidget.this.getUpdatedAvailable();
                if (!updatedAvailable.equals(JobWidget.this.available)) {
                    JobWidget.this.available.clear();
                    JobWidget.this.available.addAll(updatedAvailable);
                    if (JobWidget.this.availableJobsPanel != null) {
                        JobWidget.this.availableJobsPanel.modelChanged();
                        target.add(new Component[]{JobWidget.this.availableJobsPanel});
                    }
                }
                if (!(updatedRecent = JobWidget.this.getUpdatedRecent()).equals(JobWidget.this.recent)) {
                    JobWidget.this.recent.clear();
                    JobWidget.this.recent.addAll(updatedRecent);
                    if (JobWidget.this.recentExecPanel != null) {
                        JobWidget.this.recentExecPanel.modelChanged();
                        target.add(new Component[]{JobWidget.this.recentExecPanel});
                    }
                }
            }
        }});
        this.add(new Component[]{this.container});
        this.container.add(new Component[]{new AjaxBootstrapTabbedPanel("tabbedPanel", this.buildTabList(pageRef))});
        this.actionTogglePanel = new ActionLinksTogglePanel("actionTogglePanel", pageRef);
        this.add(new Component[]{this.actionTogglePanel});
    }

    private List<JobTO> getUpdatedAvailable() {
        JobTO notificationJob;
        ArrayList<JobTO> updatedAvailable = new ArrayList<JobTO>();
        if (SyncopeConsoleSession.get().owns("NOTIFICATION_LIST") && (notificationJob = this.notificationRestClient.getJob()) != null) {
            updatedAvailable.add(notificationJob);
        }
        if (SyncopeConsoleSession.get().owns("TASK_LIST")) {
            updatedAvailable.addAll(this.taskRestClient.listJobs());
        }
        if (SyncopeConsoleSession.get().owns("REPORT_LIST")) {
            updatedAvailable.addAll(this.reportRestClient.listJobs());
        }
        return updatedAvailable;
    }

    private List<ExecTO> getUpdatedRecent() {
        ArrayList<ExecTO> updatedRecent = new ArrayList<ExecTO>();
        if (SyncopeConsoleSession.get().owns("TASK_LIST")) {
            updatedRecent.addAll(this.taskRestClient.listRecentExecutions(10));
        }
        if (SyncopeConsoleSession.get().owns("REPORT_LIST")) {
            updatedRecent.addAll(this.reportRestClient.listRecentExecutions(10));
        }
        return updatedRecent;
    }

    private List<ITab> buildTabList(final PageReference pageRef) {
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("available")){
            private static final long serialVersionUID = -6815067322125799251L;

            public Panel getPanel(String panelId) {
                JobWidget.this.availableJobsPanel = new AvailableJobsPanel(panelId, pageRef);
                JobWidget.this.availableJobsPanel.setOutputMarkupId(true);
                return JobWidget.this.availableJobsPanel;
            }
        });
        tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("recent")){
            private static final long serialVersionUID = -6815067322125799251L;

            public Panel getPanel(String panelId) {
                JobWidget.this.recentExecPanel = new RecentExecPanel(panelId, pageRef);
                JobWidget.this.recentExecPanel.setOutputMarkupId(true);
                return JobWidget.this.recentExecPanel;
            }
        });
        return tabs;
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof JobActionPanel.JobActionPayload) {
            this.available.clear();
            this.available.addAll(this.getUpdatedAvailable());
            this.availableJobsPanel.modelChanged();
            ((JobActionPanel.JobActionPayload)JobActionPanel.JobActionPayload.class.cast(event.getPayload())).getTarget().add(new Component[]{this.availableJobsPanel});
        }
    }

    private class RecentExecPanel
    extends DirectoryPanel<ExecTO, ExecTO, RecentExecProvider, BaseRestClient> {
        private static final long serialVersionUID = -8214546246301342868L;

        RecentExecPanel(String id, PageReference pageRef) {
            super(id, new DirectoryPanel.Builder<ExecTO, ExecTO, BaseRestClient>(null, pageRef){
                private static final long serialVersionUID = 8769126634538601689L;

                @Override
                protected WizardMgtPanel<ExecTO> newInstance(String id, boolean wizardInModal) {
                    throw new UnsupportedOperationException();
                }
            }.disableCheckBoxes().hidePaginator());
            this.rows = 5;
            this.initResultTable();
        }

        @Override
        protected RecentExecProvider dataProvider() {
            return new RecentExecProvider();
        }

        @Override
        protected String paginatorRowsKey() {
            return "";
        }

        @Override
        protected Collection<ActionLink.ActionType> getBulkActions() {
            return Collections.emptyList();
        }

        @Override
        protected List<IColumn<ExecTO, String>> getColumns() {
            ArrayList<IColumn<ExecTO, String>> columns = new ArrayList<IColumn<ExecTO, String>>();
            columns.add((IColumn<ExecTO, String>)new PropertyColumn((IModel)new ResourceModel("refDesc"), (Object)"refDesc", "refDesc"));
            columns.add((IColumn<ExecTO, String>)new DatePropertyColumn((IModel<String>)new ResourceModel("start"), "start", "start"));
            columns.add((IColumn<ExecTO, String>)new DatePropertyColumn((IModel<String>)new ResourceModel("end"), "end", "end"));
            columns.add((IColumn<ExecTO, String>)new PropertyColumn((IModel)new ResourceModel("status"), (Object)"status", "status"));
            return columns;
        }

        @Override
        public ActionsPanel<ExecTO> getActions(final IModel<ExecTO> model) {
            ActionsPanel<ExecTO> panel = super.getActions(model);
            panel.add(new ActionLink<ExecTO>(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target, ExecTO ignore) {
                    JobWidget.this.detailModal.header((IModel)new StringResourceModel("execution.view", (Component)JobWidget.this, model));
                    JobWidget.this.detailModal.setContent(new ExecMessageModal(((ExecTO)model.getObject()).getMessage()));
                    JobWidget.this.detailModal.show(true);
                    target.add(new Component[]{JobWidget.this.detailModal});
                }
            }, ActionLink.ActionType.VIEW, "TASK_READ");
            return panel;
        }

        protected final class RecentExecProvider
        extends DirectoryDataProvider<ExecTO> {
            private static final long serialVersionUID = 2835707012690698633L;
            private final SortableDataProviderComparator<ExecTO> comparator;

            private RecentExecProvider() {
                super(5);
                this.setSort("end", SortOrder.DESCENDING);
                this.comparator = new SortableDataProviderComparator<ExecTO>(this);
            }

            public Iterator<ExecTO> iterator(long first, long count) {
                Collections.sort(JobWidget.this.recent, this.comparator);
                return JobWidget.this.recent.subList((int)first, (int)first + (int)count).iterator();
            }

            public long size() {
                return JobWidget.this.recent.size();
            }

            public IModel<ExecTO> model(ExecTO object) {
                return new CompoundPropertyModel((Object)object);
            }
        }
    }

    protected final class AvailableJobsProvider
    extends DirectoryDataProvider<JobTO> {
        private static final long serialVersionUID = 3191573490219472572L;
        private final SortableDataProviderComparator<JobTO> comparator;

        private AvailableJobsProvider() {
            super(5);
            this.setSort("type", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<JobTO>(this);
        }

        public Iterator<JobTO> iterator(long first, long count) {
            Collections.sort(JobWidget.this.available, this.comparator);
            return JobWidget.this.available.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return JobWidget.this.available.size();
        }

        public IModel<JobTO> model(JobTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }

    private class AvailableJobsPanel
    extends DirectoryPanel<JobTO, JobTO, AvailableJobsProvider, BaseRestClient> {
        private static final long serialVersionUID = -8214546246301342868L;
        private final BaseModal<ReportTO> reportModal;
        private final BaseModal<Serializable> jobModal;

        AvailableJobsPanel(String id, PageReference pageRef) {
            super(id, new DirectoryPanel.Builder<JobTO, JobTO, BaseRestClient>(null, pageRef){
                private static final long serialVersionUID = 8769126634538601689L;

                @Override
                protected WizardMgtPanel<JobTO> newInstance(String id, boolean wizardInModal) {
                    throw new UnsupportedOperationException();
                }
            }.disableCheckBoxes().hidePaginator());
            super.setTogglePanel(this.actionTogglePanel);
            this.reportModal = JobWidget.this.reportModal;
            this.setWindowClosedReloadCallback(this.reportModal);
            this.jobModal = JobWidget.this.modal;
            this.setWindowClosedReloadCallback(this.jobModal);
            this.rows = 5;
            this.initResultTable();
        }

        @Override
        protected AvailableJobsProvider dataProvider() {
            return new AvailableJobsProvider();
        }

        @Override
        protected String paginatorRowsKey() {
            return "";
        }

        @Override
        protected Collection<ActionLink.ActionType> getBulkActions() {
            return Collections.emptyList();
        }

        @Override
        protected List<IColumn<JobTO, String>> getColumns() {
            ArrayList<IColumn<JobTO, String>> columns = new ArrayList<IColumn<JobTO, String>>();
            columns.add((IColumn<JobTO, String>)new PropertyColumn((IModel)new ResourceModel("refDesc"), (Object)"refDesc", "refDesc"));
            columns.add((IColumn<JobTO, String>)new BooleanPropertyColumn((IModel<String>)new ResourceModel("scheduled"), "scheduled", "scheduled"));
            columns.add((IColumn<JobTO, String>)new DatePropertyColumn((IModel<String>)new ResourceModel("start"), "start", "start"));
            columns.add((IColumn<JobTO, String>)new AbstractColumn<JobTO, String>((IModel)new Model((Serializable)((Object)"")), "running"){
                private static final long serialVersionUID = -4008579357070833846L;

                public void populateItem(Item<ICellPopulator<JobTO>> cellItem, String componentId, IModel<JobTO> rowModel) {
                    JobTO jobTO = (JobTO)rowModel.getObject();
                    JobActionPanel panel = new JobActionPanel(componentId, jobTO, true, (Component)JobWidget.this, AvailableJobsPanel.this.pageRef);
                    MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)WebPage.ENABLE, (String)String.format("%s,%s,%s,%s", "TASK_EXECUTE", "REPORT_EXECUTE", "TASK_UPDATE", "REPORT_UPDATE"));
                    cellItem.add(new Component[]{panel});
                }

                public String getCssClass() {
                    return "col-xs-1";
                }
            });
            return columns;
        }

        @Override
        protected ActionsPanel<JobTO> getActions(IModel<JobTO> model) {
            ActionsPanel<JobTO> panel = super.getActions(model);
            final JobTO jobTO = (JobTO)model.getObject();
            panel.add(new ActionLink<JobTO>(){
                private static final long serialVersionUID = -7978723352517770644L;

                @Override
                public void onClick(AjaxRequestTarget target, JobTO ignore) {
                    switch (jobTO.getType()) {
                        case NOTIFICATION: {
                            break;
                        }
                        case REPORT: {
                            ReportTO reportTO = JobWidget.this.reportRestClient.read(jobTO.getRefKey());
                            ReportWizardBuilder rwb = new ReportWizardBuilder(reportTO, AvailableJobsPanel.this.pageRef);
                            rwb.setEventSink((IEventSink)AvailableJobsPanel.this);
                            target.add(new Component[]{AvailableJobsPanel.this.jobModal.setContent(rwb.build("content", AjaxWizard.Mode.EDIT))});
                            AvailableJobsPanel.this.jobModal.header((IModel)new StringResourceModel("any.edit", (Component)AvailableJobsPanel.this, (IModel)new Model((Serializable)reportTO)));
                            AvailableJobsPanel.this.jobModal.show(true);
                            break;
                        }
                        case TASK: {
                            ProvisioningTaskTO schedTaskTO;
                            try {
                                schedTaskTO = (ProvisioningTaskTO)JobWidget.this.taskRestClient.readTask(TaskType.PULL, jobTO.getRefKey());
                            }
                            catch (Exception e) {
                                LOG.debug("Failed to read {} as {}, attempting {}", new Object[]{jobTO.getRefKey(), TaskType.PULL, TaskType.PUSH, e});
                                schedTaskTO = (ProvisioningTaskTO)JobWidget.this.taskRestClient.readTask(TaskType.PUSH, jobTO.getRefKey());
                            }
                            SchedTaskWizardBuilder<ProvisioningTaskTO> swb = new SchedTaskWizardBuilder<ProvisioningTaskTO>(schedTaskTO instanceof PullTaskTO ? TaskType.PULL : TaskType.PUSH, schedTaskTO, AvailableJobsPanel.this.pageRef);
                            swb.setEventSink((IEventSink)AvailableJobsPanel.this);
                            target.add(new Component[]{AvailableJobsPanel.this.jobModal.setContent(swb.build("content", AjaxWizard.Mode.EDIT))});
                            AvailableJobsPanel.this.jobModal.header((IModel)new StringResourceModel("any.edit", (Component)AvailableJobsPanel.this, (IModel)new Model((Serializable)schedTaskTO)));
                            AvailableJobsPanel.this.jobModal.show(true);
                            break;
                        }
                    }
                }

                @Override
                protected boolean statusCondition(JobTO modelObject) {
                    return null == jobTO.getType() || !JobType.NOTIFICATION.equals((Object)jobTO.getType());
                }
            }, ActionLink.ActionType.EDIT, "TASK_UPDATE");
            panel.add(new ActionLink<JobTO>(){
                private static final long serialVersionUID = -7978723352517770644L;

                @Override
                public void onClick(AjaxRequestTarget target, JobTO ignore) {
                    if (null != jobTO.getType()) {
                        switch (jobTO.getType()) {
                            case NOTIFICATION: {
                                break;
                            }
                            case REPORT: {
                                ReportTO reportTO = JobWidget.this.reportRestClient.read(jobTO.getRefKey());
                                target.add(new Component[]{AvailableJobsPanel.this.reportModal.setContent(new ReportletDirectoryPanel(AvailableJobsPanel.this.reportModal, jobTO.getRefKey(), AvailableJobsPanel.this.pageRef))});
                                MetaDataRoleAuthorizationStrategy.authorize(AvailableJobsPanel.this.reportModal.getForm(), (Action)Component.ENABLE, (String)"REPORT_UPDATE");
                                AvailableJobsPanel.this.reportModal.header((IModel)new StringResourceModel("reportlet.conf", (Component)AvailableJobsPanel.this, (IModel)new Model((Serializable)reportTO)));
                                AvailableJobsPanel.this.reportModal.show(true);
                                break;
                            }
                            case TASK: {
                                break;
                            }
                        }
                    }
                }

                @Override
                protected boolean statusCondition(JobTO modelObject) {
                    return null == jobTO.getType() || !JobType.TASK.equals((Object)jobTO.getType()) && !JobType.NOTIFICATION.equals((Object)jobTO.getType());
                }
            }, ActionLink.ActionType.COMPOSE, "TASK_UPDATE");
            panel.add(new ActionLink<JobTO>(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target, JobTO ignore) {
                    try {
                        if (null != jobTO.getType()) {
                            switch (jobTO.getType()) {
                                case NOTIFICATION: {
                                    break;
                                }
                                case REPORT: {
                                    JobWidget.this.reportRestClient.actionJob(jobTO.getRefKey(), JobAction.DELETE);
                                    break;
                                }
                                case TASK: {
                                    JobWidget.this.taskRestClient.actionJob(jobTO.getRefKey(), JobAction.DELETE);
                                    break;
                                }
                            }
                            SyncopeConsoleSession.get().info((Serializable)((Object)AvailableJobsPanel.this.getString("operation_succeeded")));
                            target.add(new Component[]{AvailableJobsPanel.this.container});
                        }
                    }
                    catch (SyncopeClientException e) {
                        LOG.error("While deleting object {}", (Object)jobTO.getRefKey(), (Object)e);
                        SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                    }
                    ((BasePage)AvailableJobsPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }

                @Override
                protected boolean statusCondition(JobTO modelObject) {
                    return null != jobTO.getType() && !JobType.NOTIFICATION.equals((Object)jobTO.getType()) && jobTO.isScheduled() && !jobTO.isRunning();
                }
            }, ActionLink.ActionType.DELETE, "TASK_DELETE", true);
            return panel;
        }

        @Override
        public void onEvent(IEvent<?> event) {
            if (event.getPayload() instanceof AjaxWizard.NewItemEvent) {
                AjaxRequestTarget target = ((AjaxWizard.NewItemEvent)AjaxWizard.NewItemEvent.class.cast(event.getPayload())).getTarget();
                if (event.getPayload() instanceof AjaxWizard.NewItemCancelEvent || event.getPayload() instanceof AjaxWizard.NewItemFinishEvent) {
                    this.jobModal.close((IPartialPageRequestHandler)target);
                }
            }
            super.onEvent(event);
        }
    }
}

