/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesomeIconTypeBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.Approvals;
import org.apache.syncope.client.console.rest.UserWorkflowRestClient;
import org.apache.syncope.client.console.wicket.ajax.IndicatorAjaxTimerBehavior;
import org.apache.syncope.client.console.widgets.AlertWidget;
import org.apache.syncope.common.lib.to.WorkflowFormTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.util.time.Duration;

public class ApprovalsWidget
extends AlertWidget<WorkflowFormTO> {
    private static final long serialVersionUID = 7667120094526529934L;
    private final UserWorkflowRestClient restClient = new UserWorkflowRestClient();
    private final List<WorkflowFormTO> lastApprovals = new ArrayList<WorkflowFormTO>();

    public ApprovalsWidget(String id, PageReference pageRef) {
        super(id);
        this.setOutputMarkupId(true);
        this.latestAlertsList.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.seconds((int)30)){
            private static final long serialVersionUID = 7298597675929755960L;

            protected void onTimer(AjaxRequestTarget target) {
                if (!((List)ApprovalsWidget.this.latestAlerts.getObject()).equals(ApprovalsWidget.this.lastApprovals)) {
                    ApprovalsWidget.this.refreshLatestAlerts(target);
                }
            }
        }});
    }

    public final void refreshLatestAlerts(AjaxRequestTarget target) {
        ((List)this.latestAlerts.getObject()).clear();
        ((List)this.latestAlerts.getObject()).addAll(this.lastApprovals);
        this.linkAlertsNumber.setDefaultModelObject((Object)((List)this.latestAlerts.getObject()).size());
        target.add(new Component[]{this.linkAlertsNumber});
        this.headerAlertsNumber.setDefaultModelObject((Object)((List)this.latestAlerts.getObject()).size());
        target.add(new Component[]{this.headerAlertsNumber});
        this.latestFive.removeAll();
        target.add(new Component[]{this.latestAlertsList});
        this.lastApprovals.clear();
        this.lastApprovals.addAll((Collection)this.latestAlerts.getObject());
    }

    @Override
    protected IModel<List<WorkflowFormTO>> getLatestAlerts() {
        return new ListModel<WorkflowFormTO>(){
            private static final long serialVersionUID = -2583290457773357445L;

            public List<WorkflowFormTO> getObject() {
                List<WorkflowFormTO> updatedApprovals;
                if (SyncopeConsoleSession.get().owns("WORKFLOW_FORM_LIST") && SyncopeConsoleSession.get().owns("WORKFLOW_FORM_READ")) {
                    updatedApprovals = ApprovalsWidget.this.restClient.getForms();
                    Collections.sort(updatedApprovals, new WorkflowFormComparator());
                } else {
                    updatedApprovals = Collections.emptyList();
                }
                return updatedApprovals;
            }
        };
    }

    @Override
    protected Panel getAlertLink(String panelid, WorkflowFormTO event) {
        return new InnerPanel(panelid, event);
    }

    @Override
    protected AbstractLink getEventsLink(String linkid) {
        BookmarkablePageLink approvals = BookmarkablePageLinkBuilder.build(linkid, Approvals.class);
        MetaDataRoleAuthorizationStrategy.authorize(approvals, (Action)WebPage.ENABLE, (String)"WORKFLOW_FORM_LIST");
        return approvals;
    }

    @Override
    protected Icon getIcon(String iconid) {
        return new Icon(iconid, (IconType)FontAwesomeIconTypeBuilder.on((FontAwesomeIconTypeBuilder.FontAwesomeGraphic)FontAwesomeIconTypeBuilder.FontAwesomeGraphic.handshake_o).build());
    }

    private static class WorkflowFormComparator
    implements Comparator<WorkflowFormTO>,
    Serializable {
        private static final long serialVersionUID = 4650217602780789075L;

        private WorkflowFormComparator() {
        }

        @Override
        public int compare(WorkflowFormTO o1, WorkflowFormTO o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o2.getCreateTime().compareTo(o1.getCreateTime());
        }
    }

    public static final class InnerPanel
    extends Panel {
        private static final long serialVersionUID = 3829642687027801451L;

        public InnerPanel(String id, final WorkflowFormTO alert) {
            super(id);
            AjaxLink<String> approval = new AjaxLink<String>("approval"){
                private static final long serialVersionUID = 7021195294339489084L;

                public void onClick(AjaxRequestTarget target) {
                }

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    if (StringUtils.isNotBlank((CharSequence)alert.getUsername())) {
                        tag.put("title", (CharSequence)alert.getUsername().trim());
                    }
                }
            };
            this.add(new Component[]{approval});
            approval.add(new Component[]{new Label("key", (IModel)new ResourceModel(alert.getKey(), alert.getKey())).setRenderBodyOnly(true)});
            approval.add(new Component[]{new Label("owner", (Serializable)((Object)alert.getOwner()))});
            approval.add(new Component[]{new Label("createTime", (Serializable)((Object)SyncopeConsoleSession.get().getDateFormat().format(alert.getCreateTime()))).setRenderBodyOnly(true)});
            WebMarkupContainer dueDateContainer = new WebMarkupContainer("dueDateContainer");
            dueDateContainer.setOutputMarkupId(true);
            approval.add(new Component[]{dueDateContainer});
            if (alert.getDueDate() == null) {
                dueDateContainer.add(new Component[]{new Label("dueDate")});
                dueDateContainer.setVisible(false);
            } else {
                dueDateContainer.add(new Component[]{new Label("dueDate", (Serializable)((Object)SyncopeConsoleSession.get().getDateFormat().format(alert.getDueDate()))).setRenderBodyOnly(true)});
            }
        }
    }
}

