/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.tasks.CrontabPanel;
import org.apache.syncope.client.console.tasks.PushTaskFilters;
import org.apache.syncope.client.console.tasks.PushTaskWrapper;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;

public class SchedTaskWizardBuilder<T extends SchedTaskTO>
extends AjaxWizardBuilder<T> {
    private static final long serialVersionUID = 5945391813567245081L;
    private final TaskRestClient taskRestClient = new TaskRestClient();
    private final TaskType type;
    private PushTaskWrapper wrapper;
    private CrontabPanel crontabPanel;
    private final LoadableDetachableModel<List<String>> realms = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            List result = (List)CollectionUtils.collect(new RealmRestClient().list(), (Transformer)new Transformer<RealmTO, String>(){

                public String transform(RealmTO realm) {
                    return realm.getFullPath();
                }
            }, new ArrayList());
            Collections.sort(result);
            return result;
        }
    };

    public SchedTaskWizardBuilder(TaskType type, T taskTO, PageReference pageRef) {
        super(taskTO, pageRef);
        this.type = type;
    }

    @Override
    protected Serializable onApplyInternal(SchedTaskTO modelObject) {
        if (modelObject instanceof PushTaskTO && this.wrapper != null) {
            this.wrapper.fillFilterConditions();
        }
        modelObject.setCronExpression(this.crontabPanel.getCronExpression());
        if (modelObject.getKey() == null) {
            this.taskRestClient.create(this.type, modelObject);
        } else {
            this.taskRestClient.update(this.type, modelObject);
        }
        return modelObject;
    }

    @Override
    protected WizardModel buildModelSteps(SchedTaskTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Profile(modelObject));
        if (modelObject instanceof PushTaskTO) {
            this.wrapper = new PushTaskWrapper((PushTaskTO)PushTaskTO.class.cast(modelObject));
            wizardModel.add((IWizardStep)new PushTaskFilters(this.wrapper));
        }
        wizardModel.add((IWizardStep)new Schedule(modelObject));
        return wizardModel;
    }

    public class Schedule
    extends WizardStep {
        private static final long serialVersionUID = -785981096328637758L;

        public Schedule(SchedTaskTO taskTO) {
            SchedTaskWizardBuilder.this.crontabPanel = new CrontabPanel("schedule", (PropertyModel<String>)new PropertyModel((Object)taskTO, "cronExpression"), taskTO.getCronExpression());
            this.add(new Component[]{SchedTaskWizardBuilder.this.crontabPanel});
        }
    }

    public class Profile
    extends WizardStep {
        private static final long serialVersionUID = -3043839139187792810L;
        private final IModel<List<String>> taskJobClasses = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return new ArrayList<String>(SyncopeConsoleSession.get().getPlatformInfo().getTaskJobs());
            }
        };
        private final IModel<List<String>> reconciliationFilterBuilderClasses = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return new ArrayList<String>(SyncopeConsoleSession.get().getPlatformInfo().getReconciliationFilterBuilders());
            }
        };
        private final IModel<List<String>> pullActionsClasses = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return new ArrayList<String>(SyncopeConsoleSession.get().getPlatformInfo().getPullActions());
            }
        };
        private final IModel<List<String>> pushActionsClasses = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return new ArrayList<String>(SyncopeConsoleSession.get().getPlatformInfo().getPushActions());
            }
        };

        public Profile(SchedTaskTO taskTO) {
            AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "name", (IModel<String>)new PropertyModel((Object)taskTO, "name"), false);
            name.addRequiredLabel();
            name.setEnabled(true);
            this.add(new Component[]{name});
            AjaxTextFieldPanel description = new AjaxTextFieldPanel("description", "description", (IModel<String>)new PropertyModel((Object)taskTO, "description"), false);
            description.setEnabled(true);
            this.add(new Component[]{description});
            AjaxCheckBoxPanel active = new AjaxCheckBoxPanel("active", "active", (IModel<Boolean>)new PropertyModel((Object)taskTO, "active"), false);
            this.add(new Component[]{active});
            AjaxDropDownChoicePanel jobDelegateClassName = new AjaxDropDownChoicePanel("jobDelegateClassName", "jobDelegateClassName", new PropertyModel((Object)taskTO, "jobDelegateClassName"), false);
            jobDelegateClassName.setChoices((List)this.taskJobClasses.getObject());
            jobDelegateClassName.addRequiredLabel();
            jobDelegateClassName.setEnabled(taskTO.getKey() == null);
            jobDelegateClassName.setStyleSheet("ui-widget-content ui-corner-all long_dynamicsize");
            this.add(new Component[]{jobDelegateClassName});
            WebMarkupContainer pullTaskSpecifics = new WebMarkupContainer("pullTaskSpecifics");
            this.add(new Component[]{pullTaskSpecifics.setRenderBodyOnly(true)});
            boolean isFiltered = false;
            if (taskTO instanceof PullTaskTO) {
                isFiltered = ((PullTaskTO)PullTaskTO.class.cast(taskTO)).getPullMode() == PullMode.FILTERED_RECONCILIATION;
            } else {
                pullTaskSpecifics.setEnabled(false).setVisible(false);
            }
            final AjaxDropDownChoicePanel<PullMode> pullMode = new AjaxDropDownChoicePanel<PullMode>("pullMode", "pullMode", (IModel<PullMode>)new PropertyModel((Object)taskTO, "pullMode"), false);
            pullMode.setChoices(Arrays.asList(PullMode.values()));
            if (taskTO instanceof PullTaskTO) {
                pullMode.addRequiredLabel();
            }
            pullMode.setNullValid(!(taskTO instanceof PullTaskTO));
            pullTaskSpecifics.add(new Component[]{pullMode});
            final AjaxDropDownChoicePanel reconciliationFilterBuilderClassName = new AjaxDropDownChoicePanel("reconciliationFilterBuilderClassName", "reconciliationFilterBuilderClassName", new PropertyModel((Object)taskTO, "reconciliationFilterBuilderClassName"), false);
            reconciliationFilterBuilderClassName.setChoices((List)this.reconciliationFilterBuilderClasses.getObject());
            reconciliationFilterBuilderClassName.setStyleSheet("ui-widget-content ui-corner-all long_dynamicsize");
            reconciliationFilterBuilderClassName.setEnabled(isFiltered);
            reconciliationFilterBuilderClassName.setRequired(isFiltered);
            pullTaskSpecifics.add(new Component[]{reconciliationFilterBuilderClassName});
            pullMode.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    reconciliationFilterBuilderClassName.setEnabled(pullMode.getModelObject() == PullMode.FILTERED_RECONCILIATION);
                    reconciliationFilterBuilderClassName.setRequired(pullMode.getModelObject() == PullMode.FILTERED_RECONCILIATION);
                    target.add(new Component[]{reconciliationFilterBuilderClassName});
                }
            }});
            AjaxDropDownChoicePanel destinationRealm = new AjaxDropDownChoicePanel("destinationRealm", "destinationRealm", new PropertyModel((Object)taskTO, "destinationRealm"), false).setChoices(SchedTaskWizardBuilder.this.realms);
            if (taskTO instanceof PullTaskTO) {
                destinationRealm.addRequiredLabel();
            }
            destinationRealm.setNullValid(!(taskTO instanceof PullTaskTO));
            pullTaskSpecifics.add(new Component[]{destinationRealm});
            WebMarkupContainer pushTaskSpecifics = new WebMarkupContainer("pushTaskSpecifics");
            this.add(new Component[]{pushTaskSpecifics.setRenderBodyOnly(true)});
            if (!(taskTO instanceof PushTaskTO)) {
                pushTaskSpecifics.setEnabled(false).setVisible(false);
            }
            AjaxDropDownChoicePanel sourceRealm = new AjaxDropDownChoicePanel("sourceRealm", "sourceRealm", new PropertyModel((Object)taskTO, "sourceRealm"), false).setChoices(SchedTaskWizardBuilder.this.realms);
            if (taskTO instanceof PushTaskTO) {
                sourceRealm.addRequiredLabel();
            }
            sourceRealm.setNullValid(!(taskTO instanceof PushTaskTO));
            pushTaskSpecifics.add(new Component[]{sourceRealm});
            WebMarkupContainer provisioningTaskSpecifics = new WebMarkupContainer("provisioningTaskSpecifics");
            this.add(new Component[]{provisioningTaskSpecifics.setRenderBodyOnly(true)});
            if (taskTO instanceof ProvisioningTaskTO) {
                jobDelegateClassName.setEnabled(false).setVisible(false);
            } else {
                provisioningTaskSpecifics.setEnabled(false).setVisible(false);
            }
            AjaxPalettePanel actionsClassNames = new AjaxPalettePanel.Builder().setAllowMoveAll(true).setAllowOrder(true).build("actionsClassNames", new PropertyModel((Object)taskTO, "actionsClassNames"), new ListModel(taskTO instanceof PushTaskTO ? (List)this.pushActionsClasses.getObject() : (List)this.pullActionsClasses.getObject()));
            actionsClassNames.setOutputMarkupId(true);
            provisioningTaskSpecifics.add(new Component[]{actionsClassNames});
            AjaxDropDownChoicePanel<MatchingRule> matchingRule = new AjaxDropDownChoicePanel<MatchingRule>("matchingRule", "matchingRule", (IModel<MatchingRule>)new PropertyModel((Object)taskTO, "matchingRule"), false);
            matchingRule.setChoices(Arrays.asList(MatchingRule.values()));
            provisioningTaskSpecifics.add(new Component[]{matchingRule});
            AjaxDropDownChoicePanel<UnmatchingRule> unmatchingRule = new AjaxDropDownChoicePanel<UnmatchingRule>("unmatchingRule", "unmatchingRule", (IModel<UnmatchingRule>)new PropertyModel((Object)taskTO, "unmatchingRule"), false);
            unmatchingRule.setChoices(Arrays.asList(UnmatchingRule.values()));
            provisioningTaskSpecifics.add(new Component[]{unmatchingRule});
            AjaxCheckBoxPanel performCreate = new AjaxCheckBoxPanel("performCreate", "performCreate", (IModel<Boolean>)new PropertyModel((Object)taskTO, "performCreate"), false);
            provisioningTaskSpecifics.add(new Component[]{performCreate});
            AjaxCheckBoxPanel performUpdate = new AjaxCheckBoxPanel("performUpdate", "performUpdate", (IModel<Boolean>)new PropertyModel((Object)taskTO, "performUpdate"), false);
            provisioningTaskSpecifics.add(new Component[]{performUpdate});
            AjaxCheckBoxPanel performDelete = new AjaxCheckBoxPanel("performDelete", "performDelete", (IModel<Boolean>)new PropertyModel((Object)taskTO, "performDelete"), false);
            provisioningTaskSpecifics.add(new Component[]{performDelete});
            AjaxCheckBoxPanel syncStatus = new AjaxCheckBoxPanel("syncStatus", "syncStatus", (IModel<Boolean>)new PropertyModel((Object)taskTO, "syncStatus"), false);
            provisioningTaskSpecifics.add(new Component[]{syncStatus});
        }
    }
}

