/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.status;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.ReconciliationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconTaskPanel
extends MultilevelPanel.SecondLevel {
    private static final long serialVersionUID = 5870444905957760434L;
    protected static final Logger LOG = LoggerFactory.getLogger(ReconTaskPanel.class);
    private final ReconciliationRestClient restClient = new ReconciliationRestClient();
    private final IModel<List<String>> pullActionsClasses = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return new ArrayList<String>(SyncopeConsoleSession.get().getPlatformInfo().getPullActions());
        }
    };
    private final IModel<List<String>> pushActionsClasses = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return new ArrayList<String>(SyncopeConsoleSession.get().getPlatformInfo().getPushActions());
        }
    };

    public ReconTaskPanel(final String resource, final ProvisioningTaskTO taskTO, final AnyTypeKind anyTypeKind, final String anyKey, final MultilevelPanel multiLevelPanelRef, final PageReference pageRef) {
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)taskTO));
        this.add(new Component[]{form});
        AjaxPalettePanel actionsClassNames = new AjaxPalettePanel.Builder().setAllowMoveAll(true).setAllowOrder(true).build("actionsClassNames", new PropertyModel((Object)taskTO, "actionsClassNames"), new ListModel(taskTO instanceof PushTaskTO ? (List)this.pushActionsClasses.getObject() : (List)this.pullActionsClasses.getObject()));
        actionsClassNames.setOutputMarkupId(true);
        form.add(new Component[]{actionsClassNames});
        AjaxDropDownChoicePanel<MatchingRule> matchingRule = new AjaxDropDownChoicePanel<MatchingRule>("matchingRule", "matchingRule", (IModel<MatchingRule>)new PropertyModel((Object)taskTO, "matchingRule"), false);
        matchingRule.setChoices(Arrays.asList(MatchingRule.values()));
        form.add(new Component[]{matchingRule});
        AjaxDropDownChoicePanel<UnmatchingRule> unmatchingRule = new AjaxDropDownChoicePanel<UnmatchingRule>("unmatchingRule", "unmatchingRule", (IModel<UnmatchingRule>)new PropertyModel((Object)taskTO, "unmatchingRule"), false);
        unmatchingRule.setChoices(Arrays.asList(UnmatchingRule.values()));
        form.add(new Component[]{unmatchingRule});
        taskTO.setPerformCreate(true);
        AjaxCheckBoxPanel performCreate = new AjaxCheckBoxPanel("performCreate", "performCreate", (IModel<Boolean>)new PropertyModel((Object)taskTO, "performCreate"), false);
        form.add(new Component[]{performCreate});
        taskTO.setPerformUpdate(true);
        AjaxCheckBoxPanel performUpdate = new AjaxCheckBoxPanel("performUpdate", "performUpdate", (IModel<Boolean>)new PropertyModel((Object)taskTO, "performUpdate"), false);
        form.add(new Component[]{performUpdate});
        taskTO.setPerformDelete(true);
        AjaxCheckBoxPanel performDelete = new AjaxCheckBoxPanel("performDelete", "performDelete", (IModel<Boolean>)new PropertyModel((Object)taskTO, "performDelete"), false);
        form.add(new Component[]{performDelete});
        taskTO.setSyncStatus(true);
        AjaxCheckBoxPanel syncStatus = new AjaxCheckBoxPanel("syncStatus", "syncStatus", (IModel<Boolean>)new PropertyModel((Object)taskTO, "syncStatus"), false);
        form.add(new Component[]{syncStatus});
        form.add(new Component[]{new AjaxSubmitLink("reconcile"){
            private static final long serialVersionUID = -817438685948164787L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    if (taskTO instanceof PushTaskTO) {
                        ReconTaskPanel.this.restClient.push(anyTypeKind, anyKey, resource, (PushTaskTO)form.getModelObject());
                    } else {
                        ReconTaskPanel.this.restClient.pull(anyTypeKind, anyKey, resource, (PullTaskTO)form.getModelObject());
                    }
                    SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
                }
                catch (Exception e) {
                    LOG.error("While attempting reconciliation on {} {} {} {}", new Object[]{anyTypeKind, anyKey, resource, form.getModelObject(), e});
                    SyncopeConsoleSession.get().error((Serializable)((Object)(resource + ": " + (StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage()))));
                }
                multiLevelPanelRef.prev(target);
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }});
    }
}

