/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.status;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.status.AbstractStatusBeanProvider;
import org.apache.syncope.client.console.commons.status.Status;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.commons.status.StatusUtils;
import org.apache.syncope.client.console.panels.AjaxDataTablePanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.AnyObjectRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.status.ReconStatusPanel;
import org.apache.syncope.client.console.status.ReconTaskPanel;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.ReconStatus;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public class AnyStatusDirectoryPanel
extends DirectoryPanel<StatusBean, StatusBean, DirectoryDataProvider<StatusBean>, AbstractAnyRestClient<?>>
implements ModalPanel {
    private static final long serialVersionUID = -9148734710505211261L;
    private final BaseModal<?> baseModal;
    private final MultilevelPanel multiLevelPanelRef;
    private final AnyTO anyTO;
    private final AnyTypeKind anyTypeKind;
    private final boolean statusOnly;
    private final List<String> resources;

    public AnyStatusDirectoryPanel(BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, PageReference pageRef, final AnyTO anyTO, String itemKeyFieldName, boolean statusOnly) {
        super("first", pageRef);
        this.baseModal = baseModal;
        this.multiLevelPanelRef = multiLevelPanelRef;
        this.statusOnly = statusOnly;
        this.anyTO = anyTO;
        this.itemKeyFieldName = itemKeyFieldName;
        if (anyTO instanceof UserTO) {
            this.restClient = new UserRestClient();
            this.anyTypeKind = AnyTypeKind.USER;
        } else if (anyTO instanceof GroupTO) {
            this.restClient = new GroupRestClient();
            this.anyTypeKind = AnyTypeKind.GROUP;
        } else {
            this.restClient = new AnyObjectRestClient();
            this.anyTypeKind = AnyTypeKind.ANY_OBJECT;
        }
        this.resources = (List)CollectionUtils.collect(new ResourceRestClient().list(), (Transformer)new Transformer<ResourceTO, String>(){

            public String transform(ResourceTO resource) {
                return resource.getProvision(anyTO.getType()) == null ? null : resource.getKey();
            }
        }, new ArrayList());
        CollectionUtils.filter(this.resources, (Predicate)PredicateUtils.notNullPredicate());
        this.initResultTable();
    }

    @Override
    protected void resultTableCustomChanges(AjaxDataTablePanel.Builder<StatusBean, String> resultTableBuilder) {
        resultTableBuilder.setMultiLevelPanel(this.baseModal, this.multiLevelPanelRef);
    }

    @Override
    protected List<IColumn<StatusBean, String>> getColumns() {
        ArrayList<IColumn<StatusBean, String>> columns = new ArrayList<IColumn<StatusBean, String>>();
        columns.add((IColumn<StatusBean, String>)new AbstractColumn<StatusBean, String>((IModel)new StringResourceModel("resource", (Component)this), "resource"){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<StatusBean>> cellItem, String componentId, final IModel<StatusBean> model) {
                cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)((StatusBean)model.getObject()).getResource())){
                    private static final long serialVersionUID = 8432079838783825801L;

                    protected void onComponentTag(ComponentTag tag) {
                        if (AnyStatusDirectoryPanel.this.anyTO.getResources().contains(((StatusBean)model.getObject()).getResource()) || "syncope".equalsIgnoreCase(((StatusBean)model.getObject()).getResource())) {
                            super.onComponentTag(tag);
                        } else {
                            tag.put("style", (CharSequence)"font-style: italic");
                        }
                    }
                }});
            }
        });
        if (this.statusOnly) {
            columns.add((IColumn<StatusBean, String>)new PropertyColumn((IModel)new StringResourceModel("connObjectLink", (Component)this), (Object)"connObjectLink", "connObjectLink"));
            columns.add((IColumn<StatusBean, String>)new AbstractColumn<StatusBean, String>((IModel)new StringResourceModel("status", (Component)this)){
                private static final long serialVersionUID = -3503023501954863131L;

                public void populateItem(Item<ICellPopulator<StatusBean>> cellItem, String componentId, IModel<StatusBean> model) {
                    if (((StatusBean)model.getObject()).isLinked()) {
                        cellItem.add(new Component[]{StatusUtils.getStatusImage(componentId, ((StatusBean)model.getObject()).getStatus())});
                    } else {
                        cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)""))});
                    }
                }
            });
        }
        return columns;
    }

    @Override
    public ActionsPanel<StatusBean> getActions(IModel<StatusBean> model) {
        ActionsPanel<StatusBean> panel = super.getActions(model);
        if (!"syncope".equalsIgnoreCase(((StatusBean)model.getObject()).getResource())) {
            panel.add(new ActionLink<StatusBean>(){
                private static final long serialVersionUID = -7978723352517770645L;

                @Override
                public void onClick(AjaxRequestTarget target, StatusBean bean) {
                    AnyStatusDirectoryPanel.this.multiLevelPanelRef.next(bean.getResource(), new ReconStatusPanel(bean.getResource(), AnyStatusDirectoryPanel.this.anyTypeKind, AnyStatusDirectoryPanel.this.anyTO.getKey()), target);
                    target.add(new Component[]{AnyStatusDirectoryPanel.this.multiLevelPanelRef});
                    AnyStatusDirectoryPanel.this.getTogglePanel().close(target);
                }
            }, ActionLink.ActionType.VIEW, "RESOURCE_GET_CONNOBJECT");
        }
        if (!this.statusOnly) {
            panel.add(new ActionLink<StatusBean>(){
                private static final long serialVersionUID = -7978723352517770645L;

                @Override
                public void onClick(AjaxRequestTarget target, StatusBean bean) {
                    AnyStatusDirectoryPanel.this.multiLevelPanelRef.next("PUSH " + bean.getResource(), new ReconTaskPanel(bean.getResource(), (ProvisioningTaskTO)new PushTaskTO(), AnyStatusDirectoryPanel.this.anyTypeKind, AnyStatusDirectoryPanel.this.anyTO.getKey(), AnyStatusDirectoryPanel.this.multiLevelPanelRef, AnyStatusDirectoryPanel.this.pageRef), target);
                    target.add(new Component[]{AnyStatusDirectoryPanel.this.multiLevelPanelRef});
                    AnyStatusDirectoryPanel.this.getTogglePanel().close(target);
                }
            }, ActionLink.ActionType.RECONCILIATION_PUSH, "TASK_EXECUTE");
            panel.add(new ActionLink<StatusBean>(){
                private static final long serialVersionUID = -7978723352517770645L;

                @Override
                public void onClick(AjaxRequestTarget target, StatusBean bean) {
                    AnyStatusDirectoryPanel.this.multiLevelPanelRef.next("PULL " + bean.getResource(), new ReconTaskPanel(bean.getResource(), (ProvisioningTaskTO)new PullTaskTO(), AnyStatusDirectoryPanel.this.anyTypeKind, AnyStatusDirectoryPanel.this.anyTO.getKey(), AnyStatusDirectoryPanel.this.multiLevelPanelRef, AnyStatusDirectoryPanel.this.pageRef), target);
                    target.add(new Component[]{AnyStatusDirectoryPanel.this.multiLevelPanelRef});
                    AnyStatusDirectoryPanel.this.getTogglePanel().close(target);
                }
            }, ActionLink.ActionType.RECONCILIATION_PULL, "TASK_EXECUTE");
        }
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBulkActions() {
        ArrayList<ActionLink.ActionType> bulkActions = new ArrayList<ActionLink.ActionType>();
        if (this.statusOnly) {
            bulkActions.add(ActionLink.ActionType.SUSPEND);
            bulkActions.add(ActionLink.ActionType.REACTIVATE);
        } else {
            bulkActions.add(ActionLink.ActionType.UNLINK);
            bulkActions.add(ActionLink.ActionType.LINK);
            bulkActions.add(ActionLink.ActionType.DEPROVISION);
            bulkActions.add(ActionLink.ActionType.PROVISION);
            bulkActions.add(ActionLink.ActionType.ASSIGN);
            bulkActions.add(ActionLink.ActionType.UNASSIGN);
        }
        return bulkActions;
    }

    @Override
    protected AnyStatusProvider dataProvider() {
        return new AnyStatusProvider();
    }

    @Override
    protected String paginatorRowsKey() {
        return "";
    }

    protected class AnyStatusProvider
    extends AbstractStatusBeanProvider {
        private static final long serialVersionUID = 4586969457669796621L;

        AnyStatusProvider() {
            super("resource");
        }

        @Override
        protected List<StatusBean> getStatusBeans(long first, long count) {
            final Object actual = ((AbstractAnyRestClient)AnyStatusDirectoryPanel.this.restClient).read(AnyStatusDirectoryPanel.this.anyTO.getKey());
            List<StatusBean> statusBeans = (List<StatusBean>)CollectionUtils.collect((Iterable)actual.getResources(), (Transformer)new Transformer<String, StatusBean>(){

                public StatusBean transform(String resource) {
                    List<Object> statuses = Collections.emptyList();
                    if (AnyStatusDirectoryPanel.this.statusOnly) {
                        statuses = StatusUtils.getReconStatuses(AnyStatusDirectoryPanel.this.anyTypeKind, AnyStatusDirectoryPanel.this.anyTO.getKey(), Arrays.asList(resource));
                    }
                    return StatusUtils.getStatusBean(actual, resource, statuses.isEmpty() ? null : ((ReconStatus)((Pair)statuses.get(0)).getRight()).getOnResource(), actual instanceof GroupTO);
                }
            }, new ArrayList());
            if (AnyStatusDirectoryPanel.this.statusOnly) {
                StatusBean syncope = new StatusBean((AnyTO)actual, "syncope");
                switch (AnyStatusDirectoryPanel.this.anyTypeKind) {
                    case USER: {
                        syncope.setConnObjectLink(((UserTO)actual).getUsername());
                        break;
                    }
                    case GROUP: {
                        syncope.setConnObjectLink(((GroupTO)actual).getName());
                        break;
                    }
                    case ANY_OBJECT: {
                        syncope.setConnObjectLink(((AnyObjectTO)actual).getName());
                        break;
                    }
                }
                Status syncopeStatus = Status.UNDEFINED;
                if (actual.getStatus() != null) {
                    try {
                        syncopeStatus = Status.valueOf(actual.getStatus().toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Unexpected status found: {}", (Object)actual.getStatus(), (Object)e);
                    }
                }
                syncope.setStatus(syncopeStatus);
                Collections.sort(statusBeans, this.comparator);
                statusBeans.add(0, syncope);
            } else {
                statusBeans.addAll(CollectionUtils.collect((Iterable)CollectionUtils.subtract((Iterable)AnyStatusDirectoryPanel.this.resources, (Iterable)AnyStatusDirectoryPanel.this.anyTO.getResources()), (Transformer)new Transformer<String, StatusBean>(){

                    public StatusBean transform(String resource) {
                        StatusBean statusBean = StatusUtils.getStatusBean(actual, resource, null, actual instanceof GroupTO);
                        statusBean.setLinked(false);
                        return statusBean;
                    }
                }, new ArrayList()));
                Collections.sort(statusBeans, this.comparator);
            }
            return first == -1L && count == -1L ? statusBeans : statusBeans.subList((int)first, (int)first + (int)count);
        }
    }
}

