/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.policies;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.BeanPanel;
import org.apache.syncope.client.console.policies.PolicyRuleDirectoryPanel;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.common.lib.policy.ComposablePolicy;
import org.apache.syncope.common.lib.policy.RuleConf;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class PolicyRuleWizardBuilder
extends AjaxWizardBuilder<PolicyRuleDirectoryPanel.PolicyRuleWrapper> {
    private static final long serialVersionUID = 5945391813567245081L;
    private final PolicyRestClient restClient = new PolicyRestClient();
    private final String policy;
    private final PolicyType type;

    public PolicyRuleWizardBuilder(String policy, PolicyType type, PolicyRuleDirectoryPanel.PolicyRuleWrapper reportlet, PageReference pageRef) {
        super(reportlet, pageRef);
        this.policy = policy;
        this.type = type;
    }

    @Override
    protected Serializable onApplyInternal(final PolicyRuleDirectoryPanel.PolicyRuleWrapper modelObject) {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)modelObject.getConf());
        wrapper.setPropertyValue("name", (Object)modelObject.getName());
        Object policyTO = this.restClient.getPolicy(this.type, this.policy);
        if (!(policyTO instanceof ComposablePolicy)) {
            throw new IllegalStateException("Non composable policy");
        }
        ComposablePolicy composable = (ComposablePolicy)policyTO;
        if (modelObject.isNew()) {
            composable.getRuleConfs().add(modelObject.getConf());
        } else {
            CollectionUtils.filter((Iterable)composable.getRuleConfs(), (Predicate)new Predicate<RuleConf>(){

                public boolean evaluate(RuleConf object) {
                    return !object.getName().equals(modelObject.getOldName());
                }
            });
            composable.getRuleConfs().add(modelObject.getConf());
        }
        this.restClient.updatePolicy(this.type, policyTO);
        return modelObject;
    }

    @Override
    protected WizardModel buildModelSteps(PolicyRuleDirectoryPanel.PolicyRuleWrapper modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Profile(modelObject));
        wizardModel.add((IWizardStep)new Configuration(modelObject));
        return wizardModel;
    }

    public class Configuration
    extends WizardStep {
        private static final long serialVersionUID = -785981096328637758L;
        private final LoadableDetachableModel<Serializable> bean;

        public Configuration(final PolicyRuleDirectoryPanel.PolicyRuleWrapper rule) {
            this.bean = new LoadableDetachableModel<Serializable>(){
                private static final long serialVersionUID = 2092144708018739371L;

                protected Serializable load() {
                    return rule.getConf();
                }
            };
            this.add(new Component[]{new BeanPanel<Serializable>("bean", (IModel<Serializable>)this.bean, new String[0]).setRenderBodyOnly(true)});
        }
    }

    public class Profile
    extends WizardStep {
        private static final long serialVersionUID = -3043839139187792810L;

        public Profile(final PolicyRuleDirectoryPanel.PolicyRuleWrapper rule) {
            ArrayList choices;
            AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "rule", (IModel<String>)new PropertyModel((Object)rule, "name"), false);
            name.addRequiredLabel();
            this.add(new Component[]{name});
            AjaxDropDownChoicePanel conf = new AjaxDropDownChoicePanel("configuration", "configuration", new PropertyModel<String>((Object)rule, "conf"){
                private static final long serialVersionUID = -6427731218492117883L;

                public String getObject() {
                    return rule.getConf() == null ? null : rule.getConf().getClass().getName();
                }

                public void setObject(String object) {
                    RuleConf conf = null;
                    try {
                        conf = (RuleConf)RuleConf.class.cast(Class.forName(object).newInstance());
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        LOG.warn("Error retrieving reportlet configuration instance", (Throwable)e);
                    }
                    rule.setConf(conf);
                }
            });
            switch (PolicyRuleWizardBuilder.this.type) {
                case ACCOUNT: {
                    choices = new ArrayList(SyncopeConsoleSession.get().getPlatformInfo().getAccountRules());
                    break;
                }
                case PASSWORD: {
                    choices = new ArrayList(SyncopeConsoleSession.get().getPlatformInfo().getPasswordRules());
                    break;
                }
                default: {
                    choices = new ArrayList();
                }
            }
            Collections.sort(choices);
            conf.setChoices(choices);
            conf.addRequiredLabel();
            this.add(new Component[]{conf});
        }
    }
}

