/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.panels.search.AnyObjectSearchPanel;
import org.apache.syncope.client.console.panels.search.GroupSearchPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.report.Schema;
import org.apache.syncope.common.lib.report.SearchCondition;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.UserFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class BeanPanel<T extends Serializable>
extends Panel {
    private static final long serialVersionUID = 3905038169553185171L;
    protected static final Logger LOG = LoggerFactory.getLogger(BeanPanel.class);
    private final List<String> excluded;
    private final Map<String, Pair<AbstractFiqlSearchConditionBuilder, List<SearchClause>>> sCondWrapper;

    public BeanPanel(String id, IModel<T> bean, String ... excluded) {
        this(id, bean, (Map<String, Pair<AbstractFiqlSearchConditionBuilder, List<SearchClause>>>)null, excluded);
    }

    public BeanPanel(String id, final IModel<T> bean, Map<String, Pair<AbstractFiqlSearchConditionBuilder, List<SearchClause>>> sCondWrapper, String ... excluded) {
        super(id, bean);
        this.setOutputMarkupId(true);
        this.sCondWrapper = sCondWrapper;
        this.excluded = new ArrayList<String>(Arrays.asList(excluded));
        this.excluded.add("serialVersionUID");
        this.excluded.add("class");
        LoadableDetachableModel<List<String>> model = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                final ArrayList<String> result = new ArrayList<String>();
                if (BeanPanel.this.getDefaultModelObject() != null) {
                    ReflectionUtils.doWithFields(BeanPanel.this.getDefaultModelObject().getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                        public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                            result.add(field.getName());
                        }
                    }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

                        public boolean matches(Field field) {
                            return !BeanPanel.this.excluded.contains(field.getName());
                        }
                    });
                }
                return result;
            }
        };
        this.add(new Component[]{new ListView<String>("propView", (IModel)model){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<String> item) {
                AbstractFieldPanel panel;
                String fieldName = (String)item.getModelObject();
                item.add(new Component[]{new Label("fieldName", (IModel)new ResourceModel(fieldName, fieldName))});
                Field field = ReflectionUtils.findField(((Serializable)bean.getObject()).getClass(), (String)fieldName);
                if (field == null) {
                    return;
                }
                SearchCondition scondAnnot = field.getAnnotation(SearchCondition.class);
                Schema schemaAnnot = field.getAnnotation(Schema.class);
                BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean.getObject());
                if (scondAnnot != null) {
                    UserFiqlSearchConditionBuilder builder;
                    String fiql = (String)wrapper.getPropertyValue(fieldName);
                    List<SearchClause> clauses = StringUtils.isEmpty((CharSequence)fiql) ? new ArrayList<SearchClause>() : SearchUtils.getSearchClauses(fiql);
                    switch (scondAnnot.type()) {
                        case "USER": {
                            panel = new UserSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(clauses)).required(false).build("value");
                            builder = SyncopeClient.getUserSearchConditionBuilder();
                            break;
                        }
                        case "GROUP": {
                            panel = new GroupSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(clauses)).required(false).build("value");
                            builder = SyncopeClient.getGroupSearchConditionBuilder();
                            break;
                        }
                        default: {
                            panel = new AnyObjectSearchPanel.Builder(scondAnnot.type(), (IModel<List<SearchClause>>)new ListModel(clauses)).required(false).build("value");
                            builder = SyncopeClient.getAnyObjectSearchConditionBuilder(null);
                        }
                    }
                    if (BeanPanel.this.sCondWrapper != null) {
                        BeanPanel.this.sCondWrapper.put(fieldName, Pair.of((Object)builder, clauses));
                    }
                } else if (List.class.equals(field.getType())) {
                    Class listItemType = String.class;
                    if (field.getGenericType() instanceof ParameterizedType) {
                        listItemType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    }
                    if (listItemType.equals(String.class) && schemaAnnot != null) {
                        SchemaRestClient schemaRestClient = new SchemaRestClient();
                        ArrayList choices = new ArrayList();
                        block13: for (SchemaType type : schemaAnnot.type()) {
                            switch (type) {
                                case PLAIN: {
                                    choices.addAll(schemaRestClient.getSchemas(SchemaType.PLAIN, schemaAnnot.anyTypeKind()));
                                    continue block13;
                                }
                                case DERIVED: {
                                    choices.addAll(schemaRestClient.getSchemas(SchemaType.DERIVED, schemaAnnot.anyTypeKind()));
                                    continue block13;
                                }
                                case VIRTUAL: {
                                    choices.addAll(schemaRestClient.getSchemas(SchemaType.VIRTUAL, schemaAnnot.anyTypeKind()));
                                    continue block13;
                                }
                            }
                        }
                        panel = new AjaxPalettePanel.Builder().setName(fieldName).build("value", new PropertyModel(bean.getObject(), fieldName), new ListModel((List)CollectionUtils.collect(choices, (Transformer)new Transformer<SchemaTO, String>(){

                            public String transform(SchemaTO input) {
                                return input.getKey();
                            }
                        }, new ArrayList()))).hideLabel();
                    } else {
                        panel = listItemType.isEnum() ? new AjaxPalettePanel.Builder().setName(fieldName).build("value", new PropertyModel(bean.getObject(), fieldName), new ListModel(Arrays.asList(listItemType.getEnumConstants()))).hideLabel() : new MultiFieldPanel.Builder(new PropertyModel(bean.getObject(), fieldName)).build("value", fieldName, BeanPanel.this.buildSinglePanel((Serializable)bean.getObject(), field.getType(), fieldName, "panel")).hideLabel();
                    }
                } else {
                    panel = BeanPanel.this.buildSinglePanel((Serializable)bean.getObject(), field.getType(), fieldName, "value").hideLabel();
                }
                item.add(new Component[]{panel.setRenderBodyOnly(true)});
            }
        }.setReuseItems(true).setOutputMarkupId(true)});
    }

    private FieldPanel buildSinglePanel(Serializable bean, Class<?> type, String fieldName, String id) {
        FieldPanel result = null;
        PropertyModel model = new PropertyModel((Object)bean, fieldName);
        if (ClassUtils.isAssignable(Boolean.class, type)) {
            result = new AjaxCheckBoxPanel(id, fieldName, (IModel<Boolean>)model);
        } else if (ClassUtils.isAssignable(Number.class, type)) {
            result = new AjaxSpinnerFieldPanel.Builder().build(id, fieldName, ClassUtils.resolvePrimitiveIfNecessary(type), model);
        } else if (Date.class.equals(type)) {
            result = new AjaxDateTimeFieldPanel(id, fieldName, (IModel<Date>)model, "yyyy-MM-dd'T'HH:mm:ssZ");
        } else if (type.isEnum()) {
            result = new AjaxDropDownChoicePanel(id, fieldName, (IModel<?>)model).setChoices(Arrays.asList(type.getEnumConstants()));
        }
        if (result == null) {
            result = new AjaxTextFieldPanel(id, fieldName, (IModel<String>)model);
        }
        result.hideLabel();
        return result;
    }
}

