/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.approvals;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.approvals.ApprovalModal;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.layout.FormLayoutInfoUtils;
import org.apache.syncope.client.console.layout.UserFormLayoutInfo;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.UserWorkflowRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.UserWizardBuilder;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.to.WorkflowFormTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public class ApprovalDirectoryPanel
extends DirectoryPanel<WorkflowFormTO, WorkflowFormTO, ApprovalProvider, UserWorkflowRestClient> {
    private static final long serialVersionUID = -7122136682275797903L;
    protected final BaseModal<WorkflowFormTO> manageApprovalModal = new BaseModal<WorkflowFormTO>("outer"){
        private static final long serialVersionUID = 389935548143327858L;

        protected void onConfigure() {
            super.onConfigure();
            this.addSubmitButton();
            this.size(Modal.Size.Large);
        }
    };

    public ApprovalDirectoryPanel(String id, final PageReference pageReference) {
        super(id, pageReference, true);
        this.disableCheckBoxes();
        this.setFooterVisibility(false);
        this.modal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.manageApprovalModal});
        this.manageApprovalModal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                ApprovalDirectoryPanel.this.updateResultTable(target);
                ((BasePage)pageReference.getPage()).getApprovalsWidget().refreshLatestAlerts(target);
                ApprovalDirectoryPanel.this.manageApprovalModal.show(false);
            }
        });
        this.restClient = new UserWorkflowRestClient();
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"WORKFLOW_FORM_SUBMIT");
    }

    @Override
    protected List<IColumn<WorkflowFormTO, String>> getColumns() {
        ArrayList<IColumn<WorkflowFormTO, String>> columns = new ArrayList<IColumn<WorkflowFormTO, String>>();
        columns.add((IColumn<WorkflowFormTO, String>)new PropertyColumn((IModel)new ResourceModel("taskId"), (Object)"taskId", "taskId"));
        columns.add((IColumn<WorkflowFormTO, String>)new PropertyColumn((IModel)new ResourceModel("key"), (Object)"key", "key"));
        columns.add((IColumn<WorkflowFormTO, String>)new PropertyColumn((IModel)new ResourceModel("username"), (Object)"username", "username"));
        columns.add((IColumn<WorkflowFormTO, String>)new DatePropertyColumn((IModel<String>)new ResourceModel("createTime"), "createTime", "createTime"));
        columns.add((IColumn<WorkflowFormTO, String>)new DatePropertyColumn((IModel<String>)new ResourceModel("dueDate"), "dueDate", "dueDate"));
        columns.add((IColumn<WorkflowFormTO, String>)new PropertyColumn((IModel)new ResourceModel("owner"), (Object)"owner", "owner"));
        return columns;
    }

    @Override
    public ActionsPanel<WorkflowFormTO> getActions(final IModel<WorkflowFormTO> model) {
        ActionsPanel<WorkflowFormTO> panel = super.getActions(model);
        panel.add(new ActionLink<WorkflowFormTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, WorkflowFormTO ignore) {
                ApprovalDirectoryPanel.this.claimForm(((WorkflowFormTO)model.getObject()).getTaskId());
                SyncopeConsoleSession.get().info((Serializable)((Object)ApprovalDirectoryPanel.this.getString("operation_succeeded")));
                ((BasePage)ApprovalDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                target.add(new Component[]{ApprovalDirectoryPanel.this.container});
            }
        }, ActionLink.ActionType.CLAIM, "WORKFLOW_FORM_CLAIM");
        panel.add(new ActionLink<WorkflowFormTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, WorkflowFormTO ignore) {
                ApprovalDirectoryPanel.this.manageApprovalModal.setFormModel((IModel<WorkflowFormTO>)new CompoundPropertyModel(model.getObject()));
                target.add(new Component[]{ApprovalDirectoryPanel.this.manageApprovalModal.setContent(new ApprovalModal(ApprovalDirectoryPanel.this.manageApprovalModal, ApprovalDirectoryPanel.this.pageRef, (WorkflowFormTO)model.getObject()){
                    private static final long serialVersionUID = 5546519445061007248L;

                    @Override
                    public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                        try {
                            super.onSubmit(target, form);
                            ApprovalDirectoryPanel.this.getTogglePanel().close(target);
                        }
                        catch (SyncopeClientException e) {
                            SyncopeConsoleSession.get().error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                        }
                        ((BasePage)ApprovalDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                ApprovalDirectoryPanel.this.manageApprovalModal.header((IModel)new Model((Serializable)((Object)ApprovalDirectoryPanel.this.getString("approval.manage", (IModel)new Model((Serializable)model.getObject())))));
                ApprovalDirectoryPanel.this.manageApprovalModal.show(true);
            }

            @Override
            protected boolean statusCondition(WorkflowFormTO modelObject) {
                return SyncopeConsoleSession.get().getSelfTO().getUsername().equals(((WorkflowFormTO)model.getObject()).getOwner());
            }
        }, ActionLink.ActionType.MANAGE_APPROVAL, "WORKFLOW_FORM_READ");
        panel.add(new ActionLink<WorkflowFormTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, WorkflowFormTO ignore) {
                UserTO previousUserTO;
                UserTO newUserTO;
                CompoundPropertyModel formModel = new CompoundPropertyModel(model.getObject());
                ApprovalDirectoryPanel.this.modal.setFormModel(formModel);
                WorkflowFormTO formTO = (WorkflowFormTO)formModel.getObject();
                if (formTO.getUserPatch() == null) {
                    newUserTO = formTO.getUserTO();
                    previousUserTO = null;
                } else if (formTO.getUserTO() == null) {
                    previousUserTO = new UserTO();
                    previousUserTO.setKey(formTO.getUserPatch().getKey());
                    newUserTO = AnyOperations.patch((UserTO)previousUserTO, (UserPatch)formTO.getUserPatch());
                } else {
                    previousUserTO = formTO.getUserTO();
                    formTO.getUserTO().setKey(formTO.getUserPatch().getKey());
                    formTO.getUserTO().setPassword(null);
                    newUserTO = AnyOperations.patch((UserTO)formTO.getUserTO(), (UserPatch)formTO.getUserPatch());
                }
                AjaxWizard.EditItemActionEvent<UserTO> editItemActionEvent = new AjaxWizard.EditItemActionEvent<UserTO>(newUserTO, target);
                editItemActionEvent.forceModalPanel(new ApprovalUserWizardBuilder((WorkflowFormTO)formModel.getObject(), previousUserTO, newUserTO, new AnyTypeRestClient().read(AnyTypeKind.USER.name()).getClasses(), (UserFormLayoutInfo)FormLayoutInfoUtils.fetch(Collections.singletonList(AnyTypeKind.USER.name())).getLeft(), ApprovalDirectoryPanel.this.pageRef).build("content", AjaxWizard.Mode.EDIT));
                ApprovalDirectoryPanel.this.send((IEventSink)ApprovalDirectoryPanel.this, Broadcast.EXACT, editItemActionEvent);
            }

            @Override
            protected boolean statusCondition(WorkflowFormTO modelObject) {
                return SyncopeConsoleSession.get().getSelfTO().getUsername().equals(((WorkflowFormTO)model.getObject()).getOwner());
            }
        }, ActionLink.ActionType.EDIT_APPROVAL, "WORKFLOW_FORM_SUBMIT");
        return panel;
    }

    @Override
    protected ApprovalProvider dataProvider() {
        return new ApprovalProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "role.paginator.workflow.form";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBulkActions() {
        return Collections.emptyList();
    }

    private void claimForm(String taskId) {
        try {
            ((UserWorkflowRestClient)this.restClient).claimForm(taskId);
        }
        catch (SyncopeClientException scee) {
            SyncopeConsoleSession.get().error((Serializable)((Object)(this.getString("error") + ": " + scee.getMessage())));
        }
    }

    private class ApprovalUserWizardBuilder
    extends UserWizardBuilder {
        private static final long serialVersionUID = 1854981134836384069L;
        private final WorkflowFormTO formTO;

        ApprovalUserWizardBuilder(WorkflowFormTO formTO, UserTO previousUserTO, UserTO userTO, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, PageReference pageRef) {
            super(previousUserTO, userTO, anyTypeClasses, formLayoutInfo, pageRef);
            this.formTO = formTO;
        }

        @Override
        protected Serializable onApplyInternal(AnyWrapper<UserTO> modelObject) {
            ProvisioningResult<UserTO> result;
            UserTO inner = modelObject.getInnerObject();
            if (this.formTO.getUserPatch() == null) {
                result = new ProvisioningResult<UserTO>();
                UserTO user = new UserWorkflowRestClient().executeTask("default", inner);
                result.setEntity((EntityTO)user);
                ApprovalDirectoryPanel.this.claimForm(((UserWorkflowRestClient)ApprovalDirectoryPanel.this.restClient).getFormForUser(((UserTO)result.getEntity()).getKey()).getTaskId());
            } else {
                UserPatch patch = AnyOperations.diff((UserTO)inner, (UserTO)this.formTO.getUserTO(), (boolean)false);
                if (StringUtils.isNotBlank((CharSequence)inner.getPassword())) {
                    PasswordPatch passwordPatch = (PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value((Object)inner.getPassword())).onSyncope(true).resources((Collection)inner.getResources()).build();
                    patch.setPassword(passwordPatch);
                }
                if (patch.isEmpty()) {
                    result = new ProvisioningResult();
                    result.setEntity((EntityTO)inner);
                } else {
                    result = this.userRestClient.update(((UserTO)((AnyWrapper)this.getOriginalItem()).getInnerObject()).getETagValue(), patch);
                    WorkflowFormTO workFlowTO = ((UserWorkflowRestClient)ApprovalDirectoryPanel.this.restClient).getFormForUser(((UserTO)result.getEntity()).getKey());
                    if (workFlowTO != null) {
                        ApprovalDirectoryPanel.this.claimForm(workFlowTO.getTaskId());
                    }
                }
            }
            return result;
        }
    }

    public static class ApprovalProvider
    extends DirectoryDataProvider<WorkflowFormTO> {
        private static final long serialVersionUID = -2311716167583335852L;
        private final SortableDataProviderComparator<WorkflowFormTO> comparator;
        private final UserWorkflowRestClient restClient = new UserWorkflowRestClient();

        public ApprovalProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("createTime", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<WorkflowFormTO>(this);
        }

        public Iterator<WorkflowFormTO> iterator(long first, long count) {
            List<WorkflowFormTO> list = this.restClient.getForms();
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return this.restClient.getForms().size();
        }

        public IModel<WorkflowFormTO> model(final WorkflowFormTO form) {
            return new AbstractReadOnlyModel<WorkflowFormTO>(){
                private static final long serialVersionUID = -2566070996511906708L;

                public WorkflowFormTO getObject() {
                    return form;
                }
            };
        }
    }
}

