/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.ResponseHeader;
import java.io.InputStream;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.ReportTemplateTO;
import org.apache.syncope.common.lib.types.ReportTemplateFormat;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Api(tags={"ReportTemplates"}, authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
@Path(value="reportTemplates")
public interface ReportTemplateService
extends JAXRSService {
    @GET
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<ReportTemplateTO> list();

    @ApiResponses(value={@ApiResponse(code=201, message="ReportTemplate successfully created", responseHeaders={@ResponseHeader(name="X-Syncope-Key", response=String.class, description="Key value for the entity created"), @ResponseHeader(name="Location", response=String.class, description="URL of the entity created")})})
    @POST
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response create(@NotNull ReportTemplateTO var1);

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public ReportTemplateTO read(@NotNull @PathParam(value="key") String var1);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@NotNull @PathParam(value="key") String var1);

    @GET
    @Path(value="{key}/{format}")
    public Response getFormat(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="format") ReportTemplateFormat var2);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @PUT
    @Path(value="{key}/{format}")
    public void setFormat(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="format") ReportTemplateFormat var2, InputStream var3);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @DELETE
    @Path(value="{key}/{format}")
    public void removeFormat(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="format") ReportTemplateFormat var2);
}

