/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.camel.producer;

import java.util.Collection;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.StatusPatchType;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.camel.producer.AbstractProducer;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;

public class StatusProducer
extends AbstractProducer {
    private final UserDAO userDAO;
    private final UserWorkflowAdapter uwfAdapter;

    public StatusProducer(Endpoint endpoint, AnyTypeKind anyTypeKind, UserDAO userDAO, UserWorkflowAdapter uwfAdapter) {
        super(endpoint, anyTypeKind);
        this.userDAO = userDAO;
        this.uwfAdapter = uwfAdapter;
    }

    public void process(Exchange exchange) throws Exception {
        if (this.getAnyTypeKind() == AnyTypeKind.USER && this.isPull()) {
            WorkflowResult updated = (WorkflowResult)exchange.getIn().getBody();
            Boolean enabled = (Boolean)exchange.getProperty("enabled", Boolean.class);
            String key = (String)exchange.getProperty("key", String.class);
            if (enabled != null) {
                User user = (User)this.userDAO.find(key);
                WorkflowResult enableUpdate = null;
                if (user.isSuspended() == null) {
                    enableUpdate = this.uwfAdapter.activate(key, null);
                } else if (enabled.booleanValue() && user.isSuspended().booleanValue()) {
                    enableUpdate = this.uwfAdapter.reactivate(key);
                } else if (!enabled.booleanValue() && !user.isSuspended().booleanValue()) {
                    enableUpdate = this.uwfAdapter.suspend(key);
                }
                if (enableUpdate != null) {
                    if (enableUpdate.getPropByRes() != null) {
                        updated.getPropByRes().merge(enableUpdate.getPropByRes());
                        updated.getPropByRes().purge();
                    }
                    updated.getPerformedTasks().addAll(enableUpdate.getPerformedTasks());
                }
            }
        } else if (this.getAnyTypeKind() == AnyTypeKind.USER) {
            WorkflowResult updated = (WorkflowResult)exchange.getIn().getBody();
            StatusPatch statusPatch = (StatusPatch)exchange.getProperty("statusPatch", StatusPatch.class);
            Boolean nullPriorityAsync = (Boolean)exchange.getProperty("nullPriorityAsync", Boolean.class);
            PropagationByResource propByRes = new PropagationByResource();
            propByRes.addAll(ResourceOperation.UPDATE, (Collection)statusPatch.getResources());
            List tasks = this.getPropagationManager().getUpdateTasks(AnyTypeKind.USER, statusPatch.getKey(), false, Boolean.valueOf(statusPatch.getType() != StatusPatchType.SUSPEND), propByRes, null, null);
            PropagationReporter propagationReporter = this.getPropagationTaskExecutor().execute((Collection)tasks, nullPriorityAsync.booleanValue());
            exchange.getOut().setBody((Object)Pair.of((Object)updated.getResult(), (Object)propagationReporter.getStatuses()));
        }
    }
}

