/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.layout.UserFormLayoutInfo;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.WizardModalPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.OIDCProviderRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.ModalPanelBuilder;
import org.apache.syncope.client.console.wizards.OIDCProviderWizardBuilder;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.UserTemplateWizardBuilder;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.OIDCProviderTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class OIDCProvidersDirectoryPanel
extends DirectoryPanel<OIDCProviderTO, OIDCProviderTO, OIDCProvidersProvider, OIDCProviderRestClient> {
    private static final long serialVersionUID = -1356497878858616714L;
    private static final String PREF_OIDC_PROVIDERS_PAGINATOR_ROWS = "oidc.providers.paginator.rows";
    private final BaseModal<Serializable> templateModal;

    public OIDCProvidersDirectoryPanel(String id, PageReference pageRef) {
        super(id, new DirectoryPanel.Builder<OIDCProviderTO, OIDCProviderTO, OIDCProviderRestClient>(new OIDCProviderRestClient(), pageRef){
            private static final long serialVersionUID = -5542535388772406165L;

            protected WizardMgtPanel<OIDCProviderTO> newInstance(String id, boolean wizardInModal) {
                throw new UnsupportedOperationException();
            }
        }.disableCheckBoxes());
        this.addNewItemPanelBuilder((ModalPanelBuilder)new OIDCProviderWizardBuilder(this, new OIDCProviderTO(), pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"OP_CREATE");
        this.modal.size(Modal.Size.Large);
        this.actionTogglePanel = new ActionLinksTogglePanel<OIDCProviderTO>("outer", pageRef){
            private static final long serialVersionUID = -7688359318035249200L;

            public void toggleWithContent(AjaxRequestTarget target, ActionsPanel<OIDCProviderTO> actionsPanel, OIDCProviderTO modelObject) {
                super.toggleWithContent(target, actionsPanel, (Serializable)modelObject);
                this.setHeader(target, StringUtils.abbreviate((String)modelObject.getName(), (int)25));
                this.toggle(target, true);
            }
        };
        this.addOuterObject(new Component[]{this.actionTogglePanel});
        this.templateModal = new BaseModal<Serializable>("outer"){
            private static final long serialVersionUID = 5787433530654262016L;

            protected void onConfigure() {
                super.onConfigure();
                this.setFooterVisible(false);
            }
        };
        this.templateModal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                OIDCProvidersDirectoryPanel.this.templateModal.show(false);
            }
        });
        this.templateModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.templateModal});
        this.initResultTable();
    }

    protected OIDCProvidersProvider dataProvider() {
        return new OIDCProvidersProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return PREF_OIDC_PROVIDERS_PAGINATOR_ROWS;
    }

    protected List<IColumn<OIDCProviderTO, String>> getColumns() {
        ArrayList<IColumn<OIDCProviderTO, String>> columns = new ArrayList<IColumn<OIDCProviderTO, String>>();
        columns.add((IColumn<OIDCProviderTO, String>)new KeyPropertyColumn((IModel)new ResourceModel("key"), "key", "key"));
        columns.add((IColumn<OIDCProviderTO, String>)new PropertyColumn((IModel)new ResourceModel("name"), (Object)"name", "name"));
        columns.add((IColumn<OIDCProviderTO, String>)new PropertyColumn((IModel)new ResourceModel("issuer"), (Object)"issuer", "issuer"));
        columns.add((IColumn<OIDCProviderTO, String>)new PropertyColumn((IModel)new ResourceModel("clientID"), (Object)"clientID", "clientID"));
        return columns;
    }

    protected Collection<ActionLink.ActionType> getBulkActions() {
        return Collections.emptyList();
    }

    public ActionsPanel<OIDCProviderTO> getActions(final IModel<OIDCProviderTO> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<OIDCProviderTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, OIDCProviderTO ignore) {
                OIDCProviderTO object = ((OIDCProviderRestClient)OIDCProvidersDirectoryPanel.this.restClient).read(((OIDCProviderTO)model.getObject()).getKey());
                OIDCProvidersDirectoryPanel.this.send((IEventSink)OIDCProvidersDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)object, target));
                OIDCProvidersDirectoryPanel.this.modal.header((IModel)Model.of((Serializable)((Object)StringUtils.capitalize((String)("Edit " + object.getName())))));
            }
        }, ActionLink.ActionType.EDIT, "OP_UPDATE");
        panel.add((ActionLink)new ActionLink<OIDCProviderTO>(){
            private static final long serialVersionUID = 8557679125857348178L;

            public void onClick(AjaxRequestTarget target, OIDCProviderTO ignore) {
                final OIDCProviderTO object = ((OIDCProviderRestClient)OIDCProvidersDirectoryPanel.this.restClient).read(((OIDCProviderTO)model.getObject()).getKey());
                UserTemplateWizardBuilder builder = new UserTemplateWizardBuilder(object.getUserTemplate(), new AnyTypeRestClient().read(AnyTypeKind.USER.name()).getClasses(), new UserFormLayoutInfo(), OIDCProvidersDirectoryPanel.this.pageRef){
                    private static final long serialVersionUID = -7978723352517770634L;

                    protected Serializable onApplyInternal(AnyWrapper<UserTO> modelObject) {
                        object.setUserTemplate((UserTO)modelObject.getInnerObject());
                        ((OIDCProviderRestClient)OIDCProvidersDirectoryPanel.this.restClient).update(object);
                        return modelObject;
                    }
                };
                OIDCProvidersDirectoryPanel.this.templateModal.header((IModel)Model.of((Serializable)((Object)StringUtils.capitalize((String)new StringResourceModel("template.title", (Component)OIDCProvidersDirectoryPanel.this).getString()))));
                OIDCProvidersDirectoryPanel.this.templateModal.setContent((ModalPanel)builder.build("content"));
                OIDCProvidersDirectoryPanel.this.templateModal.show(true);
                target.add(new Component[]{OIDCProvidersDirectoryPanel.this.templateModal});
            }
        }, ActionLink.ActionType.TEMPLATE, "OP_UPDATE");
        panel.add((ActionLink)new ActionLink<OIDCProviderTO>(){
            private static final long serialVersionUID = -5467832321897812767L;

            public void onClick(AjaxRequestTarget target, OIDCProviderTO ignore) {
                try {
                    ((OIDCProviderRestClient)OIDCProvidersDirectoryPanel.this.restClient).delete(((OIDCProviderTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().info((Serializable)((Object)OIDCProvidersDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{OIDCProvidersDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting object {}", (Object)((OIDCProviderTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                }
                ((BasePage)OIDCProvidersDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "OP_DELETE", true);
        return panel;
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof AjaxWizard.NewItemEvent) {
            AjaxWizard.NewItemEvent newItemEvent = (AjaxWizard.NewItemEvent)AjaxWizard.NewItemEvent.class.cast(event.getPayload());
            WizardModalPanel modalPanel = newItemEvent.getModalPanel();
            if (event.getPayload() instanceof AjaxWizard.NewItemActionEvent && modalPanel != null) {
                CompoundPropertyModel model = new CompoundPropertyModel((Object)modalPanel.getItem());
                this.templateModal.setFormModel((IModel)model);
                this.templateModal.header(newItemEvent.getResourceModel());
                newItemEvent.getTarget().add(new Component[]{this.templateModal.setContent((ModalPanel)modalPanel)});
                this.templateModal.show(true);
            } else if (event.getPayload() instanceof AjaxWizard.NewItemCancelEvent) {
                this.templateModal.close((IPartialPageRequestHandler)newItemEvent.getTarget());
            } else if (event.getPayload() instanceof AjaxWizard.NewItemFinishEvent) {
                this.templateModal.close((IPartialPageRequestHandler)newItemEvent.getTarget());
            }
        }
    }

    protected final class OIDCProvidersProvider
    extends DirectoryDataProvider<OIDCProviderTO> {
        private static final long serialVersionUID = -2865055116864423761L;
        private final SortableDataProviderComparator<OIDCProviderTO> comparator;

        public OIDCProvidersProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("name", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator((SortableDataProvider)this);
        }

        public Iterator<OIDCProviderTO> iterator(long first, long count) {
            List<OIDCProviderTO> list = ((OIDCProviderRestClient)OIDCProvidersDirectoryPanel.this.restClient).list();
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((OIDCProviderRestClient)OIDCProvidersDirectoryPanel.this.restClient).list().size();
        }

        public IModel<OIDCProviderTO> model(OIDCProviderTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

