/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.Login;
import org.apache.syncope.client.console.pages.OIDCClientBeforeLogout;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCClientLogin
extends WebPage {
    private static final long serialVersionUID = 8581614051773949262L;
    private static final Logger LOG = LoggerFactory.getLogger(OIDCClientLogin.class);
    private static final String OIDC_ACCESS_ERROR = "OIDC access error";

    public OIDCClientLogin(PageParameters parameters) {
        super(parameters);
        String token = (String)((ServletWebRequest)this.getRequest()).getContainerRequest().getSession().getAttribute("oidcclient.jwt");
        if (StringUtils.isBlank((CharSequence)token)) {
            LOG.error("No JWT found, redirecting to default greeter");
            PageParameters params = new PageParameters();
            params.add("errorMessage", (Object)OIDC_ACCESS_ERROR);
            this.setResponsePage(Login.class, params);
        }
        IAuthenticationStrategy strategy = this.getApplication().getSecuritySettings().getAuthenticationStrategy();
        if (SyncopeConsoleSession.get().authenticate(token)) {
            if (parameters.get("logoutSupported").toBoolean(false)) {
                SyncopeConsoleSession.get().setAttribute("beforeLogoutPage", OIDCClientBeforeLogout.class);
            }
            this.continueToOriginalDestination();
            this.setResponsePage(this.getApplication().getHomePage());
        } else {
            PageParameters params = new PageParameters();
            params.add("errorMessage", (Object)OIDC_ACCESS_ERROR);
            this.setResponsePage(Login.class, params);
        }
        strategy.remove();
    }
}

