/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.AjaxBootstrapTabbedPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.annotations.ExtPage;
import org.apache.syncope.client.console.pages.BaseExtPage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.panels.CamelRoutesDirectoryPanel;
import org.apache.syncope.client.console.rest.CamelRoutesRestClient;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;

@ExtPage(label="Camel Routes", icon="fa-road", listEntitlement="ROUTE_LIST", priority=100)
public class CamelRoutes
extends BaseExtPage {
    private static final long serialVersionUID = 1965360932245590233L;
    public static final String PREF_CAMEL_ROUTES_PAGINATOR_ROWS = "camel.routes.paginator.rows";
    private final CamelRoutesRestClient restClient = new CamelRoutesRestClient();

    public CamelRoutes(PageParameters parameters) {
        super(parameters);
        this.body.add(new Component[]{BookmarkablePageLinkBuilder.build((String)"dashboard", (String)"dashboardBr", Dashboard.class)});
        WebMarkupContainer content = new WebMarkupContainer("content");
        content.setOutputMarkupId(true);
        AjaxBootstrapTabbedPanel tabbedPanel = new AjaxBootstrapTabbedPanel("tabbedPanel", this.buildTabList());
        content.add(new Component[]{tabbedPanel});
        MetaDataRoleAuthorizationStrategy.authorize((Component)content, (Action)ENABLE, (String)"ROUTE_LIST");
        this.body.add(new Component[]{content});
    }

    private List<ITab> buildTabList() {
        ArrayList<ITab> tabs = new ArrayList<ITab>(3);
        tabs.add((ITab)new AbstractTab((IModel)new Model((Serializable)((Object)AnyTypeKind.USER.name()))){
            private static final long serialVersionUID = -6815067322125799251L;

            public Panel getPanel(String panelId) {
                CamelRoutesDirectoryPanel panel = new CamelRoutesDirectoryPanel(panelId, CamelRoutes.this.getPageReference(), AnyTypeKind.USER);
                panel.setEnabled(CamelRoutes.this.restClient.isCamelEnabledFor(AnyTypeKind.USER));
                return panel;
            }
        });
        tabs.add((ITab)new AbstractTab((IModel)new Model((Serializable)((Object)AnyTypeKind.GROUP.name()))){
            private static final long serialVersionUID = -6815067322125799251L;

            public Panel getPanel(String panelId) {
                CamelRoutesDirectoryPanel panel = new CamelRoutesDirectoryPanel(panelId, CamelRoutes.this.getPageReference(), AnyTypeKind.GROUP);
                panel.setEnabled(CamelRoutes.this.restClient.isCamelEnabledFor(AnyTypeKind.GROUP));
                return panel;
            }
        });
        tabs.add((ITab)new AbstractTab((IModel)new Model((Serializable)((Object)AnyTypeKind.ANY_OBJECT.name()))){
            private static final long serialVersionUID = -6815067322125799251L;

            public Panel getPanel(String panelId) {
                CamelRoutesDirectoryPanel panel = new CamelRoutesDirectoryPanel(panelId, CamelRoutes.this.getPageReference(), AnyTypeKind.ANY_OBJECT);
                panel.setEnabled(CamelRoutes.this.restClient.isCamelEnabledFor(AnyTypeKind.ANY_OBJECT));
                return panel;
            }
        });
        return tabs;
    }
}

