/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePushExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.UserPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.quartz.JobExecutionException;
import org.springframework.stereotype.Component;

@Component
public class SinglePushJobDelegate
extends PushJobDelegate
implements SyncopeSinglePushExecutor {
    public List<ProvisioningReport> push(Provision provision, Connector connector, Any<?> any, PushTaskTO pushTaskTO) throws JobExecutionException {
        LOG.debug("Executing push on {}", (Object)provision.getResource());
        ArrayList<PushActions> actions = new ArrayList<PushActions>();
        for (Object className : pushTaskTO.getActionsClassNames()) {
            try {
                Class<?> actionsClass = Class.forName((String)className);
                PushActions pushActions = (PushActions)ApplicationContextProvider.getBeanFactory().createBean(actionsClass, 2, true);
                actions.add(pushActions);
            }
            catch (Exception e) {
                LOG.info("Class '{}' not found", className, (Object)e);
            }
        }
        try {
            UserPushResultHandler handler;
            PushTask pushTask = (PushTask)this.entityFactory.newEntity(PushTask.class);
            pushTask.setResource(provision.getResource());
            pushTask.setMatchingRule(pushTaskTO.getMatchingRule() == null ? MatchingRule.LINK : pushTaskTO.getMatchingRule());
            pushTask.setUnmatchingRule(pushTaskTO.getUnmatchingRule() == null ? UnmatchingRule.ASSIGN : pushTaskTO.getUnmatchingRule());
            pushTask.setPerformCreate(pushTaskTO.isPerformCreate());
            pushTask.setPerformUpdate(pushTaskTO.isPerformUpdate());
            pushTask.setPerformDelete(pushTaskTO.isPerformDelete());
            pushTask.setSyncStatus(pushTaskTO.isSyncStatus());
            this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pushTask);
            this.profile.getActions().addAll(actions);
            this.profile.setResAct(null);
            for (PushActions action : actions) {
                action.beforeAll(this.profile);
            }
            switch (provision.getAnyType().getKind()) {
                case USER: {
                    handler = this.buildUserHandler();
                    break;
                }
                case GROUP: {
                    handler = this.buildGroupHandler();
                    break;
                }
                default: {
                    handler = this.buildAnyObjectHandler();
                }
            }
            handler.setProfile(this.profile);
            this.doHandle(Arrays.asList(any), (SyncopePushResultHandler)handler, pushTask.getResource());
            for (PushActions action : actions) {
                action.afterAll(this.profile);
            }
            return this.profile.getResults();
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While pushing to connector", (Throwable)e);
        }
    }
}

