/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.AnyTemplatePullTask;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.ReconciliationFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePullExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultReconciliationFilterBuilder;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SinglePullJobDelegate
extends PullJobDelegate
implements SyncopeSinglePullExecutor {
    @Autowired
    private TemplateUtils templateUtils;

    public List<ProvisioningReport> pull(Provision provision, Connector connector, String connObjectKey, String connObjectValue, Realm realm, PullTaskTO pullTaskTO) throws JobExecutionException {
        LOG.debug("Executing pull on {}", (Object)provision.getResource());
        ArrayList<PullActions> actions = new ArrayList<PullActions>();
        for (Object className : pullTaskTO.getActionsClassNames()) {
            try {
                Class<?> actionsClass = Class.forName((String)className);
                PullActions pullActions = (PullActions)ApplicationContextProvider.getBeanFactory().createBean(actionsClass, 2, true);
                actions.add(pullActions);
            }
            catch (Exception e) {
                LOG.warn("Class '{}' not found", className, (Object)e);
            }
        }
        try {
            GroupPullResultHandler handler;
            HashSet<MappingItem> linkinMappingItems = new HashSet<MappingItem>();
            for (VirSchema virSchema : this.virSchemaDAO.findByProvision(provision)) {
                linkinMappingItems.add(virSchema.asLinkingMappingItem());
            }
            Iterator mapItems = IteratorUtils.chainedIterator(provision.getMapping().getItems().iterator(), linkinMappingItems.iterator());
            OperationOptions options = MappingUtils.buildOperationOptions(mapItems);
            PullTask pullTask = (PullTask)this.entityFactory.newEntity(PullTask.class);
            pullTask.setResource(provision.getResource());
            pullTask.setMatchingRule(pullTaskTO.getMatchingRule() == null ? MatchingRule.UPDATE : pullTaskTO.getMatchingRule());
            pullTask.setUnmatchingRule(pullTaskTO.getUnmatchingRule() == null ? UnmatchingRule.PROVISION : pullTaskTO.getUnmatchingRule());
            pullTask.setPullMode(PullMode.FILTERED_RECONCILIATION);
            pullTask.setPerformCreate(pullTaskTO.isPerformCreate());
            pullTask.setPerformUpdate(pullTaskTO.isPerformUpdate());
            pullTask.setPerformDelete(pullTaskTO.isPerformDelete());
            pullTask.setSyncStatus(pullTaskTO.isSyncStatus());
            pullTask.setDestinationRealm(realm);
            this.templateUtils.check(pullTaskTO.getTemplates(), ClientExceptionType.InvalidPullTask);
            for (Map.Entry entry : pullTaskTO.getTemplates().entrySet()) {
                AnyType type = this.anyTypeDAO.find((String)entry.getKey());
                if (type == null) {
                    LOG.debug("Invalid AnyType {} specified, ignoring...", entry.getKey());
                    continue;
                }
                AnyTemplatePullTask anyTemplate = pullTask.getTemplate(type);
                if (anyTemplate == null) {
                    anyTemplate = (AnyTemplatePullTask)this.entityFactory.newEntity(AnyTemplatePullTask.class);
                    anyTemplate.setAnyType(type);
                    anyTemplate.setPullTask(pullTask);
                    pullTask.add(anyTemplate);
                }
                anyTemplate.set((AnyTO)entry.getValue());
            }
            this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pullTask);
            this.profile.setDryRun(false);
            this.profile.setResAct(ConflictResolutionAction.FIRSTMATCH);
            this.profile.getActions().addAll(actions);
            for (PullActions action : actions) {
                action.beforeAll(this.profile);
            }
            GroupPullResultHandler ghandler = this.buildGroupHandler();
            switch (provision.getAnyType().getKind()) {
                case USER: {
                    handler = this.buildUserHandler();
                    break;
                }
                case GROUP: {
                    handler = ghandler;
                    break;
                }
                default: {
                    handler = this.buildAnyObjectHandler();
                }
            }
            handler.setProfile(this.profile);
            handler.setPullExecutor((SyncopePullExecutor)this);
            connector.filteredReconciliation(provision.getObjectClass(), (ReconciliationFilterBuilder)new AccountReconciliationFilterBuilder(connObjectKey, connObjectValue), (SyncResultsHandler)handler, options);
            try {
                this.setGroupOwners(ghandler);
            }
            catch (Exception e) {
                LOG.error("While setting group owners", (Throwable)e);
            }
            for (PullActions action : actions) {
                action.afterAll(this.profile);
            }
            return this.profile.getResults();
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While pulling from connector", (Throwable)e);
        }
    }

    class AccountReconciliationFilterBuilder
    extends DefaultReconciliationFilterBuilder {
        private final String key;
        private final String value;

        AccountReconciliationFilterBuilder(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Filter build() {
            return FilterBuilder.equalTo((Attribute)AttributeBuilder.build((String)this.key, (Object[])new Object[]{this.value}));
        }
    }
}

