/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.java.job.SetUMembershipsJob;
import org.apache.syncope.core.provisioning.java.pushpull.PullUtils;
import org.apache.syncope.core.provisioning.java.pushpull.SchedulingPullActions;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LDAPMembershipPullActions
extends SchedulingPullActions {
    protected static final Logger LOG = LoggerFactory.getLogger(LDAPMembershipPullActions.class);
    @Autowired
    protected AnyTypeDAO anyTypeDAO;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    private PullUtils pullUtils;
    protected final Map<String, Set<String>> memberships = new HashMap<String, Set<String>>();

    protected String getGroupMembershipAttrName(Connector connector) {
        ConnConfProperty groupMembership = (ConnConfProperty)IterableUtils.find((Iterable)connector.getConnInstance().getConf(), (Predicate)new Predicate<ConnConfProperty>(){

            public boolean evaluate(ConnConfProperty property) {
                return "groupMemberAttribute".equals(property.getSchema().getName()) && property.getValues() != null && !property.getValues().isEmpty();
            }
        });
        return groupMembership == null ? "uniquemember" : (String)groupMembership.getValues().get(0);
    }

    protected List<Object> getMembAttrValues(SyncDelta delta, Connector connector) {
        List result = Collections.emptyList();
        String groupMemberName = this.getGroupMembershipAttrName(connector);
        Attribute membAttr = delta.getObject().getAttributeByName(groupMemberName);
        if (membAttr == null) {
            OperationOptionsBuilder oob = new OperationOptionsBuilder();
            oob.setAttributesToGet(new String[]{groupMemberName});
            ConnectorObject remoteObj = connector.getObject(ObjectClass.GROUP, (Attribute)delta.getUid(), oob.build());
            if (remoteObj == null) {
                LOG.debug("Object for '{}' not found", (Object)delta.getUid().getUidValue());
            } else {
                membAttr = remoteObj.getAttributeByName(groupMemberName);
            }
        }
        if (membAttr != null && membAttr.getValue() != null) {
            result = membAttr.getValue();
        }
        return result;
    }

    protected void populateMemberships(ProvisioningProfile<?, ?> profile, SyncDelta delta, GroupTO groupTO) throws JobExecutionException {
        Connector connector = profile.getConnector();
        for (Object membValue : this.getMembAttrValues(delta, connector)) {
            Set<String> memb = this.memberships.get(membValue.toString());
            if (memb == null) {
                memb = new HashSet<String>();
                this.memberships.put(membValue.toString(), memb);
            }
            memb.add(groupTO.getKey());
        }
    }

    @Override
    public void after(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entity, ProvisioningReport result) throws JobExecutionException {
        if (!(profile.getTask() instanceof PullTask)) {
            return;
        }
        if (!(entity instanceof GroupTO) || profile.getTask().getResource().getProvision(this.anyTypeDAO.findUser()) == null || profile.getTask().getResource().getProvision(this.anyTypeDAO.findUser()).getMapping() == null) {
            super.after(profile, delta, entity, result);
        } else {
            this.populateMemberships(profile, delta, (GroupTO)entity);
        }
    }

    @Override
    public void afterAll(ProvisioningProfile<?, ?> profile) throws JobExecutionException {
        HashMap<String, Set<String>> resolvedMemberships = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : this.memberships.entrySet()) {
            String userKey = this.pullUtils.match(this.anyTypeDAO.findUser(), entry.getKey(), profile.getTask().getResource(), profile.getConnector());
            if (userKey == null) {
                LOG.warn("Could not find matching user for {}", (Object)entry.getKey());
                continue;
            }
            resolvedMemberships.put(userKey, entry.getValue());
        }
        HashMap<String, Object> jobMap = new HashMap<String, Object>();
        jobMap.put("memberships", resolvedMemberships);
        this.schedule(SetUMembershipsJob.class, jobMap);
    }
}

