/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.Collections;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.api.pushpull.UserPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractPullResultHandler;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultUserPullResultHandler
extends AbstractPullResultHandler
implements UserPullResultHandler {
    @Autowired
    private UserProvisioningManager userProvisioningManager;

    @Override
    protected AnyUtils getAnyUtils() {
        return this.anyUtilsFactory.getInstance(AnyTypeKind.USER);
    }

    @Override
    protected String getName(AnyTO anyTO) {
        return ((UserTO)UserTO.class.cast(anyTO)).getUsername();
    }

    @Override
    protected ProvisioningManager<?, ?> getProvisioningManager() {
        return this.userProvisioningManager;
    }

    @Override
    protected AnyTO getAnyTO(String key) {
        return this.userDataBinder.getUserTO(key);
    }

    @Override
    protected WorkflowResult<? extends AnyPatch> update(AnyPatch patch) {
        WorkflowResult update = this.uwfAdapter.update((UserPatch)patch);
        return new WorkflowResult(((Pair)update.getResult()).getLeft(), update.getPropByRes(), update.getPerformedTasks());
    }

    @Override
    protected AnyTO doCreate(AnyTO anyTO, SyncDelta delta) {
        UserTO userTO = (UserTO)UserTO.class.cast(anyTO);
        Boolean enabled = this.pullUtils.readEnabled(delta.getObject(), this.profile.getTask());
        Pair created = this.userProvisioningManager.create(userTO, true, true, enabled, Collections.singleton(((PullTask)this.profile.getTask()).getResource().getKey()), true);
        return this.getAnyTO((String)created.getKey());
    }

    @Override
    protected AnyPatch doUpdate(AnyTO before, AnyPatch anyPatch, SyncDelta delta, ProvisioningReport result) {
        UserPatch userPatch = (UserPatch)UserPatch.class.cast(anyPatch);
        Boolean enabled = this.pullUtils.readEnabled(delta.getObject(), this.profile.getTask());
        Pair updated = this.userProvisioningManager.update(userPatch, result, enabled, Collections.singleton(((PullTask)this.profile.getTask()).getResource().getKey()), true);
        return (AnyPatch)updated.getLeft();
    }

    @Override
    protected void doDelete(AnyTypeKind kind, String key) {
        try {
            this.userProvisioningManager.delete(key, Collections.singleton(((PullTask)this.profile.getTask()).getResource().getKey()), true);
        }
        catch (Exception e) {
            LOG.error("Could not propagate user " + key, (Throwable)e);
        }
        this.uwfAdapter.delete(key);
    }
}

