/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.TraceLevel;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Mapping;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.java.job.AbstractSchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.java.job.TaskJob;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractProvisioningJobDelegate<T extends ProvisioningTask>
extends AbstractSchedTaskJobDelegate {
    @Resource(name="adminUser")
    protected String adminUser;
    @Autowired
    protected ConnectorFactory connFactory;
    @Autowired
    protected AnyTypeDAO anyTypeDAO;
    @Autowired
    protected ExternalResourceDAO resourceDAO;
    @Autowired
    protected PolicyDAO policyDAO;

    protected String createReport(Collection<ProvisioningReport> provResults, ExternalResource resource, boolean dryRun) {
        boolean includeRealm;
        TraceLevel traceLevel = resource.getProvisioningTraceLevel();
        if (traceLevel == TraceLevel.NONE) {
            return null;
        }
        StringBuilder report = new StringBuilder();
        if (dryRun) {
            report.append("==> Dry run only, no modifications were made <==\n\n");
        }
        if (this.interrupted) {
            report.append("==> Execution was interrupted <==\n\n");
        }
        ArrayList<ProvisioningReport> rSuccCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> rFailCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> rSuccUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> rFailUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> rSuccDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> rFailDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> rSuccNone = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> rIgnore = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uSuccCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uFailCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uSuccUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uFailUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uSuccDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uFailDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uSuccNone = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uIgnore = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gSuccCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gFailCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gSuccUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gFailUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gSuccDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gFailDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gSuccNone = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gIgnore = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aSuccCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aFailCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aSuccUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aFailUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aSuccDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aFailDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aSuccNone = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aIgnore = new ArrayList<ProvisioningReport>();
        for (ProvisioningReport provResult : provResults) {
            AnyType anyType = this.anyTypeDAO.find(provResult.getAnyType());
            block0 : switch (provResult.getStatus()) {
                case SUCCESS: {
                    switch (provResult.getOperation()) {
                        case CREATE: {
                            if (anyType == null) {
                                rSuccCreate.add(provResult);
                                break block0;
                            }
                            switch (anyType.getKind()) {
                                case USER: {
                                    uSuccCreate.add(provResult);
                                    break block0;
                                }
                                case GROUP: {
                                    gSuccCreate.add(provResult);
                                    break block0;
                                }
                            }
                            aSuccCreate.add(provResult);
                            break block0;
                        }
                        case UPDATE: {
                            if (anyType == null) {
                                rSuccUpdate.add(provResult);
                                break block0;
                            }
                            switch (anyType.getKind()) {
                                case USER: {
                                    uSuccUpdate.add(provResult);
                                    break block0;
                                }
                                case GROUP: {
                                    gSuccUpdate.add(provResult);
                                    break block0;
                                }
                            }
                            aSuccUpdate.add(provResult);
                            break block0;
                        }
                        case DELETE: {
                            if (anyType == null) {
                                rSuccDelete.add(provResult);
                                break block0;
                            }
                            switch (anyType.getKind()) {
                                case USER: {
                                    uSuccDelete.add(provResult);
                                    break block0;
                                }
                                case GROUP: {
                                    gSuccDelete.add(provResult);
                                    break block0;
                                }
                            }
                            aSuccDelete.add(provResult);
                            break block0;
                        }
                        case NONE: {
                            if (anyType == null) {
                                rSuccNone.add(provResult);
                                break block0;
                            }
                            switch (anyType.getKind()) {
                                case USER: {
                                    uSuccNone.add(provResult);
                                    break block0;
                                }
                                case GROUP: {
                                    gSuccNone.add(provResult);
                                    break block0;
                                }
                            }
                            aSuccNone.add(provResult);
                            break block0;
                        }
                    }
                    break;
                }
                case FAILURE: {
                    switch (provResult.getOperation()) {
                        case CREATE: {
                            if (anyType == null) {
                                rFailCreate.add(provResult);
                                break block0;
                            }
                            switch (anyType.getKind()) {
                                case USER: {
                                    uFailCreate.add(provResult);
                                    break block0;
                                }
                                case GROUP: {
                                    gFailCreate.add(provResult);
                                    break block0;
                                }
                            }
                            aFailCreate.add(provResult);
                            break block0;
                        }
                        case UPDATE: {
                            if (anyType == null) {
                                rFailUpdate.add(provResult);
                                break block0;
                            }
                            switch (anyType.getKind()) {
                                case USER: {
                                    uFailUpdate.add(provResult);
                                    break block0;
                                }
                                case GROUP: {
                                    gFailUpdate.add(provResult);
                                    break block0;
                                }
                            }
                            aFailUpdate.add(provResult);
                            break block0;
                        }
                        case DELETE: {
                            if (anyType == null) {
                                rFailDelete.add(provResult);
                                break block0;
                            }
                            switch (anyType.getKind()) {
                                case USER: {
                                    uFailDelete.add(provResult);
                                    break block0;
                                }
                                case GROUP: {
                                    gFailDelete.add(provResult);
                                    break block0;
                                }
                            }
                            aFailDelete.add(provResult);
                            break block0;
                        }
                    }
                    break;
                }
                case IGNORE: {
                    if (anyType == null) {
                        rIgnore.add(provResult);
                        break;
                    }
                    switch (anyType.getKind()) {
                        case USER: {
                            uIgnore.add(provResult);
                            break block0;
                        }
                        case GROUP: {
                            gIgnore.add(provResult);
                            break block0;
                        }
                    }
                    aIgnore.add(provResult);
                    break;
                }
            }
        }
        boolean includeUser = resource.getProvision(this.anyTypeDAO.findUser()) != null;
        boolean includeGroup = resource.getProvision(this.anyTypeDAO.findGroup()) != null;
        boolean includeAnyObject = IterableUtils.matchesAny((Iterable)resource.getProvisions(), (Predicate)new Predicate<Provision>(){

            public boolean evaluate(Provision object) {
                return object.getAnyType().getKind() == AnyTypeKind.ANY_OBJECT;
            }
        });
        boolean bl = includeRealm = resource.getOrgUnit() != null;
        if (includeUser) {
            report.append("Users ").append("[created/failures]: ").append(uSuccCreate.size()).append('/').append(uFailCreate.size()).append(' ').append("[updated/failures]: ").append(uSuccUpdate.size()).append('/').append(uFailUpdate.size()).append(' ').append("[deleted/failures]: ").append(uSuccDelete.size()).append('/').append(uFailDelete.size()).append(' ').append("[no operation/ignored]: ").append(uSuccNone.size()).append('/').append(uIgnore.size()).append('\n');
        }
        if (includeGroup) {
            report.append("Groups ").append("[created/failures]: ").append(gSuccCreate.size()).append('/').append(gFailCreate.size()).append(' ').append("[updated/failures]: ").append(gSuccUpdate.size()).append('/').append(gFailUpdate.size()).append(' ').append("[deleted/failures]: ").append(gSuccDelete.size()).append('/').append(gFailDelete.size()).append(' ').append("[no operation/ignored]: ").append(gSuccNone.size()).append('/').append(gIgnore.size()).append('\n');
        }
        if (includeAnyObject) {
            report.append("Any objects ").append("[created/failures]: ").append(aSuccCreate.size()).append('/').append(aFailCreate.size()).append(' ').append("[updated/failures]: ").append(aSuccUpdate.size()).append('/').append(aFailUpdate.size()).append(' ').append("[deleted/failures]: ").append(aSuccDelete.size()).append('/').append(aFailDelete.size()).append(' ').append("[no operation/ignored]: ").append(aSuccNone.size()).append('/').append(aIgnore.size());
        }
        if (includeRealm) {
            report.append("Realms ").append("[created/failures]: ").append(rSuccCreate.size()).append('/').append(rFailCreate.size()).append(' ').append("[updated/failures]: ").append(rSuccUpdate.size()).append('/').append(rFailUpdate.size()).append(' ').append("[deleted/failures]: ").append(rSuccDelete.size()).append('/').append(rFailDelete.size()).append(' ').append("[no operation/ignored]: ").append(rSuccNone.size()).append('/').append(rIgnore.size());
        }
        if (traceLevel == TraceLevel.FAILURES || traceLevel == TraceLevel.ALL) {
            if (includeUser) {
                if (!uFailCreate.isEmpty()) {
                    report.append("\n\nUsers failed to create: ");
                    report.append(ProvisioningReport.generate(uFailCreate, (TraceLevel)traceLevel));
                }
                if (!uFailUpdate.isEmpty()) {
                    report.append("\nUsers failed to update: ");
                    report.append(ProvisioningReport.generate(uFailUpdate, (TraceLevel)traceLevel));
                }
                if (!uFailDelete.isEmpty()) {
                    report.append("\nUsers failed to delete: ");
                    report.append(ProvisioningReport.generate(uFailDelete, (TraceLevel)traceLevel));
                }
            }
            if (includeGroup) {
                if (!gFailCreate.isEmpty()) {
                    report.append("\n\nGroups failed to create: ");
                    report.append(ProvisioningReport.generate(gFailCreate, (TraceLevel)traceLevel));
                }
                if (!gFailUpdate.isEmpty()) {
                    report.append("\nGroups failed to update: ");
                    report.append(ProvisioningReport.generate(gFailUpdate, (TraceLevel)traceLevel));
                }
                if (!gFailDelete.isEmpty()) {
                    report.append("\nGroups failed to delete: ");
                    report.append(ProvisioningReport.generate(gFailDelete, (TraceLevel)traceLevel));
                }
            }
            if (includeAnyObject && !aFailCreate.isEmpty()) {
                report.append("\nAny objects failed to create: ");
                report.append(ProvisioningReport.generate(aFailCreate, (TraceLevel)traceLevel));
            }
            if (includeAnyObject && !aFailUpdate.isEmpty()) {
                report.append("\nAny objects failed to update: ");
                report.append(ProvisioningReport.generate(aFailUpdate, (TraceLevel)traceLevel));
            }
            if (includeAnyObject && !aFailDelete.isEmpty()) {
                report.append("\nAny objects failed to delete: ");
                report.append(ProvisioningReport.generate(aFailDelete, (TraceLevel)traceLevel));
            }
            if (includeRealm) {
                if (!rFailCreate.isEmpty()) {
                    report.append("\nRealms failed to create: ");
                    report.append(ProvisioningReport.generate(rFailCreate, (TraceLevel)traceLevel));
                }
                if (!rFailUpdate.isEmpty()) {
                    report.append("\nRealms failed to update: ");
                    report.append(ProvisioningReport.generate(rFailUpdate, (TraceLevel)traceLevel));
                }
                if (!rFailDelete.isEmpty()) {
                    report.append("\nRealms failed to delete: ");
                    report.append(ProvisioningReport.generate(rFailDelete, (TraceLevel)traceLevel));
                }
            }
        }
        if (traceLevel == TraceLevel.ALL) {
            if (includeUser) {
                if (!uSuccCreate.isEmpty()) {
                    report.append("\n\nUsers created:\n").append(ProvisioningReport.generate(uSuccCreate, (TraceLevel)traceLevel));
                }
                if (!uSuccUpdate.isEmpty()) {
                    report.append("\nUsers updated:\n").append(ProvisioningReport.generate(uSuccUpdate, (TraceLevel)traceLevel));
                }
                if (!uSuccDelete.isEmpty()) {
                    report.append("\nUsers deleted:\n").append(ProvisioningReport.generate(uSuccDelete, (TraceLevel)traceLevel));
                }
                if (!uSuccNone.isEmpty()) {
                    report.append("\nUsers no operation:\n").append(ProvisioningReport.generate(uSuccNone, (TraceLevel)traceLevel));
                }
                if (!uIgnore.isEmpty()) {
                    report.append("\nUsers ignored:\n").append(ProvisioningReport.generate(uIgnore, (TraceLevel)traceLevel));
                }
            }
            if (includeGroup) {
                if (!gSuccCreate.isEmpty()) {
                    report.append("\n\nGroups created:\n").append(ProvisioningReport.generate(gSuccCreate, (TraceLevel)traceLevel));
                }
                if (!gSuccUpdate.isEmpty()) {
                    report.append("\nGroups updated:\n").append(ProvisioningReport.generate(gSuccUpdate, (TraceLevel)traceLevel));
                }
                if (!gSuccDelete.isEmpty()) {
                    report.append("\nGroups deleted:\n").append(ProvisioningReport.generate(gSuccDelete, (TraceLevel)traceLevel));
                }
                if (!gSuccNone.isEmpty()) {
                    report.append("\nGroups no operation:\n").append(ProvisioningReport.generate(gSuccNone, (TraceLevel)traceLevel));
                }
                if (!gIgnore.isEmpty()) {
                    report.append("\nGroups ignored:\n").append(ProvisioningReport.generate(gIgnore, (TraceLevel)traceLevel));
                }
            }
            if (includeAnyObject) {
                if (!aSuccCreate.isEmpty()) {
                    report.append("\n\nAny objects created:\n").append(ProvisioningReport.generate(aSuccCreate, (TraceLevel)traceLevel));
                }
                if (!aSuccUpdate.isEmpty()) {
                    report.append("\nAny objects updated:\n").append(ProvisioningReport.generate(aSuccUpdate, (TraceLevel)traceLevel));
                }
                if (!aSuccDelete.isEmpty()) {
                    report.append("\nAny objects deleted:\n").append(ProvisioningReport.generate(aSuccDelete, (TraceLevel)traceLevel));
                }
                if (!aSuccNone.isEmpty()) {
                    report.append("\nAny objects no operation:\n").append(ProvisioningReport.generate(aSuccNone, (TraceLevel)traceLevel));
                }
                if (!aIgnore.isEmpty()) {
                    report.append("\nAny objects ignored:\n").append(ProvisioningReport.generate(aIgnore, (TraceLevel)traceLevel));
                }
            }
            if (includeRealm) {
                if (!rSuccCreate.isEmpty()) {
                    report.append("\n\nRealms created:\n").append(ProvisioningReport.generate(rSuccCreate, (TraceLevel)traceLevel));
                }
                if (!rSuccUpdate.isEmpty()) {
                    report.append("\nRealms updated:\n").append(ProvisioningReport.generate(rSuccUpdate, (TraceLevel)traceLevel));
                }
                if (!rSuccDelete.isEmpty()) {
                    report.append("\nRealms deleted:\n").append(ProvisioningReport.generate(rSuccDelete, (TraceLevel)traceLevel));
                }
                if (!rSuccNone.isEmpty()) {
                    report.append("\nRealms no operation:\n").append(ProvisioningReport.generate(rSuccNone, (TraceLevel)traceLevel));
                }
                if (!rIgnore.isEmpty()) {
                    report.append("\nRealms ignored:\n").append(ProvisioningReport.generate(rIgnore, (TraceLevel)traceLevel));
                }
            }
        }
        return report.toString();
    }

    @Override
    protected String doExecute(boolean dryRun) throws JobExecutionException {
        try {
            Connector connector;
            Class<T> clazz = this.getTaskClassReference();
            if (!clazz.isAssignableFrom(this.task.getClass())) {
                throw new JobExecutionException("Task " + this.task.getKey() + " isn't a ProvisioningTask");
            }
            ProvisioningTask provisioningTask = (ProvisioningTask)clazz.cast(this.task);
            try {
                connector = this.connFactory.getConnector(provisioningTask.getResource());
            }
            catch (Exception e) {
                String msg = String.format("Connector instance bean for resource %s and connInstance %s not found", provisioningTask.getResource(), provisioningTask.getResource().getConnector());
                throw new JobExecutionException(msg, (Throwable)e);
            }
            boolean noMapping = true;
            for (Provision provision : provisioningTask.getResource().getProvisions()) {
                Mapping mapping = provision.getMapping();
                if (mapping == null) continue;
                noMapping = false;
                if (mapping.getConnObjectKeyItem() != null) continue;
                throw new JobExecutionException("Invalid ConnObjectKey mapping for provision " + provision);
            }
            if (noMapping) {
                boolean bl = noMapping = provisioningTask.getResource().getOrgUnit() == null;
            }
            if (noMapping) {
                return "No provisions nor orgUnit available: aborting...";
            }
            return this.doExecuteProvisioning(provisioningTask, connector, dryRun);
        }
        catch (Throwable t) {
            LOG.error("While executing provisioning job {}", (Object)this.getClass().getName(), (Object)t);
            throw t;
        }
    }

    protected abstract String doExecuteProvisioning(T var1, Connector var2, boolean var3) throws JobExecutionException;

    @Override
    protected boolean hasToBeRegistered(TaskExec execution) {
        ProvisioningTask provTask = (ProvisioningTask)this.task;
        return TaskJob.Status.valueOf(execution.getStatus()) == TaskJob.Status.FAILURE && provTask.getResource().getProvisioningTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || provTask.getResource().getProvisioningTraceLevel().ordinal() >= TraceLevel.SUMMARY.ordinal();
    }

    protected Class<T> getTaskClassReference() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }
}

