/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.java.jexl.JexlUtils;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationActions;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class LDAPMembershipPropagationActions
extends DefaultPropagationActions {
    protected static final Logger LOG = LoggerFactory.getLogger(LDAPMembershipPropagationActions.class);
    @Autowired
    protected AnyTypeDAO anyTypeDAO;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;

    protected String getGroupMembershipAttrName() {
        return "ldapGroups";
    }

    @Override
    @Transactional(readOnly=true)
    public void before(PropagationTask task, ConnectorObject beforeObj) {
        super.before(task, beforeObj);
        Provision provision = task.getResource().getProvision(this.anyTypeDAO.findGroup());
        if (AnyTypeKind.USER == task.getAnyTypeKind() && provision != null && provision.getMapping() != null && StringUtils.isNotBlank((CharSequence)provision.getMapping().getConnObjectLink())) {
            User user = (User)this.userDAO.find(task.getEntityKey());
            if (user != null) {
                ArrayList<String> groupConnObjectLinks = new ArrayList<String>();
                for (String groupKey : this.userDAO.findAllGroupKeys(user)) {
                    Group group = (Group)this.groupDAO.find(groupKey);
                    if (group == null || !this.groupDAO.findAllResourceKeys(groupKey).contains(task.getResource().getKey())) continue;
                    LOG.debug("Evaluating connObjectLink for {}", (Object)group);
                    MapContext jexlContext = new MapContext();
                    JexlUtils.addFieldsToContext(group, (JexlContext)jexlContext);
                    JexlUtils.addPlainAttrsToContext(group.getPlainAttrs(), (JexlContext)jexlContext);
                    JexlUtils.addDerAttrsToContext(group, (JexlContext)jexlContext);
                    String groupConnObjectLinkLink = JexlUtils.evaluate(provision.getMapping().getConnObjectLink(), (JexlContext)jexlContext);
                    LOG.debug("ConnObjectLink for {} is '{}'", (Object)group, (Object)groupConnObjectLinkLink);
                    if (!StringUtils.isNotBlank((CharSequence)groupConnObjectLinkLink)) continue;
                    groupConnObjectLinks.add(groupConnObjectLinkLink);
                }
                LOG.debug("Group connObjectLinks to propagate for membership: {}", groupConnObjectLinks);
                HashSet<Attribute> attributes = new HashSet<Attribute>(task.getAttributes());
                HashSet<String> groups = new HashSet<String>(groupConnObjectLinks);
                Attribute ldapGroups = AttributeUtil.find((String)this.getGroupMembershipAttrName(), attributes);
                if (ldapGroups != null) {
                    for (Object obj : ldapGroups.getValue()) {
                        groups.add(obj.toString());
                    }
                    attributes.remove(ldapGroups);
                }
                attributes.add(AttributeBuilder.build((String)this.getGroupMembershipAttrName(), groups));
                task.setAttributes(attributes);
            }
        } else {
            LOG.debug("Not about user, or group mapping missing for resource: not doing anything");
        }
    }
}

