/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.ListUtils;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCacheValue;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Component
public class VirAttrHandlerImpl
implements VirAttrHandler {
    private static final Logger LOG = LoggerFactory.getLogger(VirAttrHandler.class);
    @Autowired
    private ConnectorFactory connFactory;
    @Autowired
    private VirAttrCache virAttrCache;
    @Autowired
    private MappingManager mappingManager;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;

    private Map<VirSchema, List<String>> getValues(Any<?> any, Set<VirSchema> schemas) {
        Set ownedResources = this.anyUtilsFactory.getInstance(any).getAllResources(any);
        HashMap<VirSchema, List<String>> result = new HashMap<VirSchema, List<String>>();
        HashMap<Provision, HashSet<VirSchema>> toRead = new HashMap<Provision, HashSet<VirSchema>>();
        for (VirSchema virSchema : schemas) {
            if (ownedResources.contains(virSchema.getProvision().getResource())) {
                VirAttrCacheValue virAttrCacheValue = this.virAttrCache.get(any.getType().getKey(), any.getKey(), virSchema.getKey());
                if (this.virAttrCache.isValidEntry(virAttrCacheValue)) {
                    LOG.debug("Values for {} found in cache: {}", (Object)virSchema, (Object)virAttrCacheValue);
                    result.put(virSchema, virAttrCacheValue.getValues());
                    continue;
                }
                HashSet<VirSchema> schemasToRead = (HashSet<VirSchema>)toRead.get(virSchema.getProvision());
                if (schemasToRead == null) {
                    schemasToRead = new HashSet<VirSchema>();
                    toRead.put(virSchema.getProvision(), schemasToRead);
                }
                schemasToRead.add(virSchema);
                continue;
            }
            LOG.debug("Not considering {} since {} is not assigned to {}", new Object[]{virSchema, any, virSchema.getProvision().getResource()});
        }
        for (Map.Entry entry : toRead.entrySet()) {
            String connObjectKeyValue;
            LOG.debug("About to read from {}: {}", entry.getKey(), entry.getValue());
            MappingItem connObjectKeyItem = MappingUtils.getConnObjectKeyItem((Provision)entry.getKey());
            String string = connObjectKeyValue = connObjectKeyItem == null ? null : this.mappingManager.getConnObjectKeyValue(any, (Provision)entry.getKey());
            if (connObjectKeyItem == null) {
                LOG.error("No ConnObjectKey found for {}, ignoring...", entry.getKey());
                continue;
            }
            HashSet<MappingItem> linkingMappingItems = new HashSet<MappingItem>();
            linkingMappingItems.add(connObjectKeyItem);
            for (VirSchema schema : (Set)entry.getValue()) {
                linkingMappingItems.add(schema.asLinkingMappingItem());
            }
            Connector connector = this.connFactory.getConnector(((Provision)entry.getKey()).getResource());
            try {
                ConnectorObject connectorObject = connector.getObject(((Provision)entry.getKey()).getObjectClass(), AttributeBuilder.build((String)connObjectKeyItem.getExtAttrName(), (Object[])new Object[]{connObjectKeyValue}), MappingUtils.buildOperationOptions(linkingMappingItems.iterator()));
                if (connectorObject == null) {
                    LOG.debug("No read from {} with filter '{} == {}'", new Object[]{entry.getKey(), connObjectKeyItem.getExtAttrName(), connObjectKeyValue});
                    continue;
                }
                for (VirSchema schema : (Set)entry.getValue()) {
                    Attribute attr = connectorObject.getAttributeByName(schema.getExtAttrName());
                    if (attr == null) continue;
                    VirAttrCacheValue virAttrCacheValue = new VirAttrCacheValue();
                    virAttrCacheValue.setValues((Collection)attr.getValue());
                    this.virAttrCache.put(any.getType().getKey(), any.getKey(), schema.getKey(), virAttrCacheValue);
                    LOG.debug("Values for {} set in cache: {}", (Object)schema, (Object)virAttrCacheValue);
                    result.put(schema, virAttrCacheValue.getValues());
                }
            }
            catch (Exception e) {
                LOG.error("Error reading from {}", entry.getKey(), (Object)e);
            }
        }
        return result;
    }

    public List<String> getValues(Any<?> any, VirSchema schema) {
        if (!this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).forSelfContains((Schema)schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, any);
            return Collections.emptyList();
        }
        return ListUtils.emptyIfNull(this.getValues(any, Collections.singleton(schema)).get(schema));
    }

    public List<String> getValues(Any<?> any, Membership<?> membership, VirSchema schema) {
        if (!this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).getForMembership((Group)membership.getRightEnd()).contains(schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, any);
            return Collections.emptyList();
        }
        return ListUtils.emptyIfNull(this.getValues(any, Collections.singleton(schema)).get(schema));
    }

    public Map<VirSchema, List<String>> getValues(Any<?> any) {
        return this.getValues(any, this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).getForSelf());
    }

    public Map<VirSchema, List<String>> getValues(Any<?> any, Membership<?> membership) {
        return this.getValues(any, this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).getForMembership((Group)membership.getRightEnd()));
    }
}

