/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.util;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.client.enduser.model.CustomAttribute;
import org.apache.syncope.client.enduser.model.CustomAttributesInfo;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserRequestValidator {
    private static final Logger LOG = LoggerFactory.getLogger(UserRequestValidator.class);

    private UserRequestValidator() {
    }

    public static boolean compliant(UserTO userTO, Map<String, CustomAttributesInfo> customForm, boolean checkDefaultValues) {
        if (customForm == null || customForm.isEmpty()) {
            return true;
        }
        return UserRequestValidator.validateAttributes(EntityTOUtils.buildAttrMap((Collection)userTO.getPlainAttrs()), customForm.get(SchemaType.PLAIN.name()), checkDefaultValues) && UserRequestValidator.validateAttributes(EntityTOUtils.buildAttrMap((Collection)userTO.getDerAttrs()), customForm.get(SchemaType.DERIVED.name()), checkDefaultValues) && UserRequestValidator.validateAttributes(EntityTOUtils.buildAttrMap((Collection)userTO.getVirAttrs()), customForm.get(SchemaType.VIRTUAL.name()), checkDefaultValues);
    }

    private static boolean validateAttributes(Map<String, AttrTO> attrMap, final CustomAttributesInfo customAttrInfo, final boolean checkDefaultValues) {
        return customAttrInfo == null || customAttrInfo.getAttributes().isEmpty() && customAttrInfo.isShow() != false || IterableUtils.matchesAll(attrMap.entrySet(), (Predicate)new Predicate<Map.Entry<String, AttrTO>>(){

            public boolean evaluate(Map.Entry<String, AttrTO> entry) {
                boolean compliant;
                String schemaKey = entry.getKey();
                AttrTO attrTO = entry.getValue();
                CustomAttribute customAttr = customAttrInfo.getAttributes().get(schemaKey);
                boolean bl = compliant = customAttr != null && (!checkDefaultValues || UserRequestValidator.isValid(attrTO, customAttr));
                if (!compliant) {
                    LOG.trace("Attribute [{}] or its values [{}] are not allowed by form customization rules", (Object)attrTO.getSchema(), (Object)attrTO.getValues());
                }
                return compliant;
            }
        });
    }

    private static boolean isValid(AttrTO attrTO, final CustomAttribute customAttribute) {
        return customAttribute.isReadonly() ? IterableUtils.matchesAll((Iterable)attrTO.getValues(), (Predicate)new Predicate<String>(){

            public boolean evaluate(String object) {
                return customAttribute.getDefaultValues().contains(object);
            }
        }) : true;
    }
}

