/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.model.CustomAttribute;
import org.apache.syncope.client.enduser.model.CustomAttributesInfo;
import org.apache.syncope.client.enduser.model.SchemaResponse;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.SchemaQuery;
import org.apache.syncope.common.rest.api.service.SchemaService;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

@Resource(key="schemas", path="/api/schemas")
public class SchemaResource
extends BaseResource {
    private static final long serialVersionUID = 6453101466981543020L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        LOG.debug("Search all {} any type kind related schemas", (Object)AnyTypeKind.USER.name());
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("application/json");
        try {
            List<SchemaTO> virSchemas;
            List<SchemaTO> derSchemas;
            List<SchemaTO> plainSchemas;
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            List classes = Collections.emptyList();
            String group = attributes.getParameters().get("group").toString();
            if (group != null) {
                try {
                    TypeExtensionTO typeExt = SyncopeEnduserSession.get().getService(SyncopeService.class).readUserTypeExtension(group);
                    classes = typeExt.getAuxClasses();
                }
                catch (Exception e) {
                    LOG.error("Could not read User type extension for Group {}", (Object)group);
                }
            } else {
                String anyTypeClass = attributes.getParameters().get("anyTypeClass").toString();
                classes = anyTypeClass != null ? Collections.singletonList(anyTypeClass) : SyncopeEnduserSession.get().getService(SyncopeService.class).platform().getUserClasses();
            }
            Map<String, CustomAttributesInfo> customForm = SyncopeEnduserApplication.get().getCustomForm();
            SchemaService schemaService = SyncopeEnduserSession.get().getService(SchemaService.class);
            List<SchemaTO> list = classes.isEmpty() ? Collections.emptyList() : (customForm == null || customForm.isEmpty() || customForm.get(SchemaType.PLAIN.name()) == null ? schemaService.search(new SchemaQuery.Builder().type(SchemaType.PLAIN).anyTypeClasses((Collection)classes).build()) : (plainSchemas = customForm.get(SchemaType.PLAIN.name()).isShow() != false ? this.customizeSchemas(schemaService.search(new SchemaQuery.Builder().type(SchemaType.PLAIN).anyTypeClasses((Collection)classes).build()), group, customForm.get(SchemaType.PLAIN.name()).getAttributes()) : Collections.emptyList()));
            List<SchemaTO> list2 = classes.isEmpty() ? Collections.emptyList() : (customForm == null || customForm.isEmpty() || customForm.get(SchemaType.DERIVED.name()) == null ? schemaService.search(new SchemaQuery.Builder().type(SchemaType.DERIVED).anyTypeClasses((Collection)classes).build()) : (derSchemas = customForm.get(SchemaType.DERIVED.name()).isShow() != false ? this.customizeSchemas(schemaService.search(new SchemaQuery.Builder().type(SchemaType.DERIVED).anyTypeClasses((Collection)classes).build()), group, customForm.get(SchemaType.DERIVED.name()).getAttributes()) : Collections.emptyList()));
            List<SchemaTO> list3 = classes.isEmpty() ? Collections.emptyList() : (customForm == null || customForm.isEmpty() || customForm.get(SchemaType.VIRTUAL.name()) == null ? schemaService.search(new SchemaQuery.Builder().type(SchemaType.VIRTUAL).anyTypeClasses((Collection)classes).build()) : (virSchemas = customForm.get(SchemaType.VIRTUAL.name()).isShow() != false ? this.customizeSchemas(schemaService.search(new SchemaQuery.Builder().type(SchemaType.VIRTUAL).anyTypeClasses((Collection)classes).build()), group, customForm.get(SchemaType.VIRTUAL.name()).getAttributes()) : Collections.emptyList()));
            if (group != null) {
                for (SchemaTO schema : plainSchemas) {
                    schema.setKey(this.compositeSchemaKey(group, schema.getKey()));
                }
                for (SchemaTO schema : derSchemas) {
                    schema.setKey(this.compositeSchemaKey(group, schema.getKey()));
                }
                for (SchemaTO schema : virSchemas) {
                    schema.setKey(this.compositeSchemaKey(group, schema.getKey()));
                }
            }
            response.setTextEncoding(StandardCharsets.UTF_8.name());
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)BaseResource.MAPPER.writeValueAsString((Object)new SchemaResponse().plainSchemas(plainSchemas).derSchemas(derSchemas).virSchemas(virSchemas)));
                }
            });
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving {} any type kind related schemas", (Object)AnyTypeKind.USER.name(), (Object)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }

    private List<SchemaTO> customizeSchemas(List<SchemaTO> schemaTOs, final String groupParam, final Map<String, CustomAttribute> customForm) {
        if (customForm.isEmpty()) {
            return schemaTOs;
        }
        final boolean isGroupBlank = StringUtils.isBlank((CharSequence)groupParam);
        CollectionUtils.filter(schemaTOs, (Predicate)new Predicate<SchemaTO>(){

            public boolean evaluate(SchemaTO object) {
                return customForm.containsKey(isGroupBlank ? object.getKey() : SchemaResource.this.compositeSchemaKey(groupParam, object.getKey()));
            }
        });
        Collections.sort(schemaTOs, new Comparator<SchemaTO>(){

            @Override
            public int compare(SchemaTO schemaTO1, SchemaTO schemaTO2) {
                ArrayList order = new ArrayList(customForm.keySet());
                return order.indexOf(isGroupBlank ? schemaTO1.getKey() : SchemaResource.this.compositeSchemaKey(groupParam, schemaTO1.getKey())) - order.indexOf(isGroupBlank ? schemaTO2.getKey() : SchemaResource.this.compositeSchemaKey(groupParam, schemaTO2.getKey()));
            }
        });
        return schemaTOs;
    }

    private String compositeSchemaKey(String prefix, String schemaKey) {
        return prefix + "#" + schemaKey;
    }
}

