/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.policy.DefaultPasswordRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.provisioning.api.utils.policy.InvalidPasswordRuleConf;
import org.apache.syncope.core.provisioning.api.utils.policy.PolicyPattern;
import org.apache.syncope.core.spring.security.PasswordGenerator;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.springframework.transaction.annotation.Transactional;

public class DefaultPasswordGenerator
implements PasswordGenerator {
    private static final char[] SPECIAL_CHARS = new char[]{'!', '\u00a3', '%', '&', '(', ')', '?', '#', '$'};
    private static final int VERY_MIN_LENGTH = 0;
    private static final int VERY_MAX_LENGTH = 64;
    private static final int MIN_LENGTH_IF_ZERO = 8;

    @Override
    @Transactional(readOnly=true)
    public String generate(ExternalResource resource) throws InvalidPasswordRuleConf {
        ArrayList<PasswordRuleConf> ruleConfs = new ArrayList<PasswordRuleConf>();
        if (resource.getPasswordPolicy() != null) {
            ruleConfs.addAll(resource.getPasswordPolicy().getRuleConfs());
        }
        return this.generate(ruleConfs);
    }

    @Override
    public String generate(List<PasswordRuleConf> ruleConfs) throws InvalidPasswordRuleConf {
        ArrayList<DefaultPasswordRuleConf> defaultRuleConfs = new ArrayList<DefaultPasswordRuleConf>();
        for (PasswordRuleConf ruleConf : ruleConfs) {
            if (!(ruleConf instanceof DefaultPasswordRuleConf)) continue;
            defaultRuleConfs.add((DefaultPasswordRuleConf)ruleConf);
        }
        DefaultPasswordRuleConf ruleConf = this.merge(defaultRuleConfs);
        this.check(ruleConf);
        return this.generate(ruleConf);
    }

    private DefaultPasswordRuleConf merge(List<DefaultPasswordRuleConf> defaultRuleConfs) {
        DefaultPasswordRuleConf result = new DefaultPasswordRuleConf();
        result.setMinLength(0);
        result.setMaxLength(64);
        for (DefaultPasswordRuleConf ruleConf : defaultRuleConfs) {
            if (ruleConf.getMinLength() > result.getMinLength()) {
                result.setMinLength(ruleConf.getMinLength());
            }
            if (ruleConf.getMaxLength() != 0 && ruleConf.getMaxLength() < result.getMaxLength()) {
                result.setMaxLength(ruleConf.getMaxLength());
            }
            result.getPrefixesNotPermitted().addAll(ruleConf.getPrefixesNotPermitted());
            result.getSuffixesNotPermitted().addAll(ruleConf.getSuffixesNotPermitted());
            if (!result.isNonAlphanumericRequired()) {
                result.setNonAlphanumericRequired(ruleConf.isNonAlphanumericRequired());
            }
            if (!result.isAlphanumericRequired()) {
                result.setAlphanumericRequired(ruleConf.isAlphanumericRequired());
            }
            if (!result.isDigitRequired()) {
                result.setDigitRequired(ruleConf.isDigitRequired());
            }
            if (!result.isLowercaseRequired()) {
                result.setLowercaseRequired(ruleConf.isLowercaseRequired());
            }
            if (!result.isUppercaseRequired()) {
                result.setUppercaseRequired(ruleConf.isUppercaseRequired());
            }
            if (!result.isMustStartWithDigit()) {
                result.setMustStartWithDigit(ruleConf.isMustStartWithDigit());
            }
            if (!result.isMustntStartWithDigit()) {
                result.setMustntStartWithDigit(ruleConf.isMustntStartWithDigit());
            }
            if (!result.isMustEndWithDigit()) {
                result.setMustEndWithDigit(ruleConf.isMustEndWithDigit());
            }
            if (result.isMustntEndWithDigit()) {
                result.setMustntEndWithDigit(ruleConf.isMustntEndWithDigit());
            }
            if (!result.isMustStartWithAlpha()) {
                result.setMustStartWithAlpha(ruleConf.isMustStartWithAlpha());
            }
            if (!result.isMustntStartWithAlpha()) {
                result.setMustntStartWithAlpha(ruleConf.isMustntStartWithAlpha());
            }
            if (!result.isMustStartWithNonAlpha()) {
                result.setMustStartWithNonAlpha(ruleConf.isMustStartWithNonAlpha());
            }
            if (!result.isMustntStartWithNonAlpha()) {
                result.setMustntStartWithNonAlpha(ruleConf.isMustntStartWithNonAlpha());
            }
            if (!result.isMustEndWithNonAlpha()) {
                result.setMustEndWithNonAlpha(ruleConf.isMustEndWithNonAlpha());
            }
            if (!result.isMustntEndWithNonAlpha()) {
                result.setMustntEndWithNonAlpha(ruleConf.isMustntEndWithNonAlpha());
            }
            if (!result.isMustEndWithAlpha()) {
                result.setMustEndWithAlpha(ruleConf.isMustEndWithAlpha());
            }
            if (!result.isMustntEndWithAlpha()) {
                result.setMustntEndWithAlpha(ruleConf.isMustntEndWithAlpha());
            }
            if (result.isUsernameAllowed()) continue;
            result.setUsernameAllowed(ruleConf.isUsernameAllowed());
        }
        if (result.getMinLength() == 0) {
            result.setMinLength(result.getMaxLength() < 8 ? result.getMaxLength() : 8);
        }
        return result;
    }

    private void check(DefaultPasswordRuleConf defaultPasswordRuleConf) throws InvalidPasswordRuleConf {
        if (defaultPasswordRuleConf.isMustEndWithAlpha() && defaultPasswordRuleConf.isMustntEndWithAlpha()) {
            throw new InvalidPasswordRuleConf("mustEndWithAlpha and mustntEndWithAlpha are both true");
        }
        if (defaultPasswordRuleConf.isMustEndWithAlpha() && defaultPasswordRuleConf.isMustEndWithDigit()) {
            throw new InvalidPasswordRuleConf("mustEndWithAlpha and mustEndWithDigit are both true");
        }
        if (defaultPasswordRuleConf.isMustEndWithDigit() && defaultPasswordRuleConf.isMustntEndWithDigit()) {
            throw new InvalidPasswordRuleConf("mustEndWithDigit and mustntEndWithDigit are both true");
        }
        if (defaultPasswordRuleConf.isMustEndWithNonAlpha() && defaultPasswordRuleConf.isMustntEndWithNonAlpha()) {
            throw new InvalidPasswordRuleConf("mustEndWithNonAlpha and mustntEndWithNonAlpha are both true");
        }
        if (defaultPasswordRuleConf.isMustStartWithAlpha() && defaultPasswordRuleConf.isMustntStartWithAlpha()) {
            throw new InvalidPasswordRuleConf("mustStartWithAlpha and mustntStartWithAlpha are both true");
        }
        if (defaultPasswordRuleConf.isMustStartWithAlpha() && defaultPasswordRuleConf.isMustStartWithDigit()) {
            throw new InvalidPasswordRuleConf("mustStartWithAlpha and mustStartWithDigit are both true");
        }
        if (defaultPasswordRuleConf.isMustStartWithDigit() && defaultPasswordRuleConf.isMustntStartWithDigit()) {
            throw new InvalidPasswordRuleConf("mustStartWithDigit and mustntStartWithDigit are both true");
        }
        if (defaultPasswordRuleConf.isMustStartWithNonAlpha() && defaultPasswordRuleConf.isMustntStartWithNonAlpha()) {
            throw new InvalidPasswordRuleConf("mustStartWithNonAlpha and mustntStartWithNonAlpha are both true");
        }
        if (defaultPasswordRuleConf.getMinLength() > defaultPasswordRuleConf.getMaxLength()) {
            throw new InvalidPasswordRuleConf("Minimun length (" + defaultPasswordRuleConf.getMinLength() + ")is greater than maximum length (" + defaultPasswordRuleConf.getMaxLength() + ")");
        }
    }

    private String generate(DefaultPasswordRuleConf ruleConf) {
        Object[] generatedPassword = new String[ruleConf.getMinLength()];
        for (int i = 0; i < generatedPassword.length; ++i) {
            generatedPassword[i] = "";
        }
        this.checkStartChar((String[])generatedPassword, ruleConf);
        this.checkEndChar((String[])generatedPassword, ruleConf);
        this.checkRequired((String[])generatedPassword, ruleConf);
        for (int firstEmptyChar = this.firstEmptyChar((String[])generatedPassword); firstEmptyChar < generatedPassword.length - 1; ++firstEmptyChar) {
            generatedPassword[firstEmptyChar] = SecureRandomUtils.generateRandomLetter();
        }
        this.checkPrefixAndSuffix((String[])generatedPassword, ruleConf);
        return StringUtils.join((Object[])generatedPassword);
    }

    private void checkStartChar(String[] generatedPassword, DefaultPasswordRuleConf ruleConf) {
        if (ruleConf.isMustStartWithAlpha()) {
            generatedPassword[0] = SecureRandomUtils.generateRandomLetter();
        }
        if (ruleConf.isMustStartWithNonAlpha() || ruleConf.isMustStartWithDigit()) {
            generatedPassword[0] = SecureRandomUtils.generateRandomNumber();
        }
        if (ruleConf.isMustntStartWithAlpha()) {
            generatedPassword[0] = SecureRandomUtils.generateRandomNumber();
        }
        if (ruleConf.isMustntStartWithDigit()) {
            generatedPassword[0] = SecureRandomUtils.generateRandomLetter();
        }
        if (ruleConf.isMustntStartWithNonAlpha()) {
            generatedPassword[0] = SecureRandomUtils.generateRandomLetter();
        }
        if ("".equals(generatedPassword[0])) {
            generatedPassword[0] = SecureRandomUtils.generateRandomLetter();
        }
    }

    private void checkEndChar(String[] generatedPassword, DefaultPasswordRuleConf ruleConf) {
        if (ruleConf.isMustEndWithAlpha()) {
            generatedPassword[ruleConf.getMinLength() - 1] = SecureRandomUtils.generateRandomLetter();
        }
        if (ruleConf.isMustEndWithNonAlpha() || ruleConf.isMustEndWithDigit()) {
            generatedPassword[ruleConf.getMinLength() - 1] = SecureRandomUtils.generateRandomNumber();
        }
        if (ruleConf.isMustntEndWithAlpha()) {
            generatedPassword[ruleConf.getMinLength() - 1] = SecureRandomUtils.generateRandomNumber();
        }
        if (ruleConf.isMustntEndWithDigit()) {
            generatedPassword[ruleConf.getMinLength() - 1] = SecureRandomUtils.generateRandomLetter();
        }
        if (ruleConf.isMustntEndWithNonAlpha()) {
            generatedPassword[ruleConf.getMinLength() - 1] = SecureRandomUtils.generateRandomLetter();
        }
        if ("".equals(generatedPassword[ruleConf.getMinLength() - 1])) {
            generatedPassword[ruleConf.getMinLength() - 1] = SecureRandomUtils.generateRandomLetter();
        }
    }

    private int firstEmptyChar(String[] generatedPStrings) {
        int index = 0;
        while (!generatedPStrings[index].isEmpty()) {
            ++index;
        }
        return index;
    }

    private void checkRequired(String[] generatedPassword, DefaultPasswordRuleConf ruleConf) {
        if (ruleConf.isDigitRequired() && !PolicyPattern.DIGIT.matcher(StringUtils.join((Object[])generatedPassword)).matches()) {
            generatedPassword[this.firstEmptyChar((String[])generatedPassword)] = SecureRandomUtils.generateRandomNumber();
        }
        if (ruleConf.isUppercaseRequired() && !PolicyPattern.ALPHA_UPPERCASE.matcher(StringUtils.join((Object[])generatedPassword)).matches()) {
            generatedPassword[this.firstEmptyChar((String[])generatedPassword)] = SecureRandomUtils.generateRandomLetter().toUpperCase();
        }
        if (ruleConf.isLowercaseRequired() && !PolicyPattern.ALPHA_LOWERCASE.matcher(StringUtils.join((Object[])generatedPassword)).matches()) {
            generatedPassword[this.firstEmptyChar((String[])generatedPassword)] = SecureRandomUtils.generateRandomLetter().toLowerCase();
        }
        if (ruleConf.isNonAlphanumericRequired() && !PolicyPattern.NON_ALPHANUMERIC.matcher(StringUtils.join((Object[])generatedPassword)).matches()) {
            generatedPassword[this.firstEmptyChar((String[])generatedPassword)] = SecureRandomUtils.generateRandomSpecialCharacter(SPECIAL_CHARS);
        }
    }

    private void checkPrefixAndSuffix(String[] generatedPassword, DefaultPasswordRuleConf ruleConf) {
        for (String prefix : ruleConf.getPrefixesNotPermitted()) {
            if (!StringUtils.join((Object[])generatedPassword).startsWith(prefix)) continue;
            this.checkStartChar(generatedPassword, ruleConf);
        }
        for (String suffix : ruleConf.getSuffixesNotPermitted()) {
            if (!StringUtils.join((Object[])generatedPassword).endsWith(suffix)) continue;
            this.checkEndChar(generatedPassword, ruleConf);
        }
    }
}

