/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.user;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.user.SecurityQuestion;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.URelationship;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.entity.AbstractAny;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGroupableRelatable;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyTypeClass;
import org.apache.syncope.core.persistence.jpa.entity.JPARole;
import org.apache.syncope.core.persistence.jpa.entity.JPASecurityQuestion;
import org.apache.syncope.core.persistence.jpa.entity.resource.JPAExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUMembership;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUPlainAttr;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAURelationship;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.SecureRandomUtils;

@Entity
@Table(name="SyncopeUser")
@Cacheable
public class JPAUser
extends AbstractGroupableRelatable<User, UMembership, UPlainAttr, AnyObject, URelationship>
implements User {
    private static final long serialVersionUID = -3905046855521446823L;
    public static final String TABLE = "SyncopeUser";
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    @Column(nullable=true)
    private String password;
    @Transient
    private String clearPassword;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    private List<JPARole> roles = new ArrayList<JPARole>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="owner")
    @Valid
    private List<JPAUPlainAttr> plainAttrs = new ArrayList<JPAUPlainAttr>();
    private String workflowId;
    @Column(nullable=true)
    private String status;
    @Lob
    private String token;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date tokenExpireTime;
    @Column(nullable=true)
    @Enumerated(value=EnumType.STRING)
    private CipherAlgorithm cipherAlgorithm;
    @ElementCollection
    @Column(name="passwordHistoryValue")
    @CollectionTable(name="SyncopeUser_passwordHistory", joinColumns={@JoinColumn(name="user_id", referencedColumnName="id")})
    private List<String> passwordHistory = new ArrayList<String>();
    @Column(nullable=true)
    private Integer failedLogins;
    @Column(unique=true)
    @NotNull(message="Blank username")
    private String username;
    @Column(nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastLoginDate;
    @Column(nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date changePwdDate;
    @Column(nullable=true)
    private String lastRecertificator;
    @Column(nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastRecertification;
    @Basic
    @Min(value=0L)
    @Max(value=1L)
    private Integer suspended = this.getBooleanAsInteger(Boolean.FALSE);
    @Basic
    @Min(value=0L)
    @Max(value=1L)
    private Integer mustChangePassword = this.getBooleanAsInteger(Boolean.FALSE);
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="resource_id")})
    private List<JPAExternalResource> resources = new ArrayList<JPAExternalResource>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="anyTypeClass_id")})
    private List<JPAAnyTypeClass> auxClasses = new ArrayList<JPAAnyTypeClass>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="leftEnd")
    @Valid
    private List<JPAURelationship> relationships = new ArrayList<JPAURelationship>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="leftEnd")
    @Valid
    private List<JPAUMembership> memberships = new ArrayList<JPAUMembership>();
    @ManyToOne(fetch=FetchType.EAGER)
    private JPASecurityQuestion securityQuestion;
    @Column(nullable=true)
    private String securityAnswer;
    private static int pcInheritedFieldCount = AbstractAny.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractAny;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$JPASecurityQuestion;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser;

    public AnyType getType() {
        return ((AnyTypeDAO)ApplicationContextProvider.getBeanFactory().getBean(AnyTypeDAO.class)).findUser();
    }

    public void setType(AnyType type) {
    }

    public boolean add(ExternalResource resource) {
        this.checkType(resource, JPAExternalResource.class);
        return JPAUser.pcGetresources(this).add((JPAExternalResource)resource);
    }

    public List<? extends ExternalResource> getResources() {
        return JPAUser.pcGetresources(this);
    }

    public boolean add(Role role) {
        this.checkType(role, JPARole.class);
        return JPAUser.pcGetroles(this).contains((JPARole)role) || JPAUser.pcGetroles(this).add((JPARole)role);
    }

    public List<? extends Role> getRoles() {
        return JPAUser.pcGetroles(this);
    }

    public String getPassword() {
        return JPAUser.pcGetpassword(this);
    }

    public String getClearPassword() {
        return this.clearPassword;
    }

    public void setClearPassword(String clearPassword) {
        this.clearPassword = clearPassword;
    }

    public void removeClearPassword() {
        this.setClearPassword(null);
    }

    public void setEncodedPassword(String password, CipherAlgorithm cipherAlgoritm) {
        this.clearPassword = null;
        JPAUser.pcSetpassword(this, password);
        JPAUser.pcSetcipherAlgorithm(this, cipherAlgoritm);
        this.setMustChangePassword(false);
    }

    public void setPassword(String password, CipherAlgorithm cipherAlgoritm) {
        this.clearPassword = password;
        try {
            JPAUser.pcSetpassword(this, ENCRYPTOR.encode(password, cipherAlgoritm));
            JPAUser.pcSetcipherAlgorithm(this, cipherAlgoritm);
            this.setMustChangePassword(false);
        }
        catch (Exception e) {
            LOG.error("Could not encode password", (Throwable)e);
            JPAUser.pcSetpassword(this, null);
        }
    }

    public CipherAlgorithm getCipherAlgorithm() {
        return JPAUser.pcGetcipherAlgorithm(this);
    }

    public boolean canDecodePassword() {
        return JPAUser.pcGetcipherAlgorithm(this) != null && JPAUser.pcGetcipherAlgorithm(this).isInvertible();
    }

    public boolean add(UPlainAttr attr) {
        this.checkType(attr, JPAUPlainAttr.class);
        return JPAUser.pcGetplainAttrs(this).add((JPAUPlainAttr)attr);
    }

    @Override
    protected List<? extends UPlainAttr> internalGetPlainAttrs() {
        return JPAUser.pcGetplainAttrs(this);
    }

    @Override
    public String getWorkflowId() {
        return JPAUser.pcGetworkflowId(this);
    }

    @Override
    public void setWorkflowId(String workflowId) {
        JPAUser.pcSetworkflowId(this, workflowId);
    }

    @Override
    public String getStatus() {
        return JPAUser.pcGetstatus(this);
    }

    @Override
    public void setStatus(String status) {
        JPAUser.pcSetstatus(this, status);
    }

    public void generateToken(int tokenLength, int tokenExpireTime) {
        JPAUser.pcSettoken(this, SecureRandomUtils.generateRandomPassword((int)tokenLength));
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, tokenExpireTime);
        JPAUser.pcSettokenExpireTime(this, calendar.getTime());
    }

    public void removeToken() {
        JPAUser.pcSettoken(this, null);
        JPAUser.pcSettokenExpireTime(this, null);
    }

    public String getToken() {
        return JPAUser.pcGettoken(this);
    }

    public Date getTokenExpireTime() {
        return JPAUser.pcGettokenExpireTime(this) == null ? null : new Date(JPAUser.pcGettokenExpireTime(this).getTime());
    }

    public boolean checkToken(String token) {
        return JPAUser.pcGettoken(this) == null ? token == null : JPAUser.pcGettoken(this).equals(token) && !this.hasTokenExpired();
    }

    public boolean hasTokenExpired() {
        return JPAUser.pcGettokenExpireTime(this) == null ? false : JPAUser.pcGettokenExpireTime(this).before(new Date());
    }

    public void setCipherAlgorithm(CipherAlgorithm cipherAlgorithm) {
        JPAUser.pcSetcipherAlgorithm(this, cipherAlgorithm);
    }

    public List<String> getPasswordHistory() {
        return JPAUser.pcGetpasswordHistory(this);
    }

    public Date getChangePwdDate() {
        return JPAUser.pcGetchangePwdDate(this) == null ? null : new Date(JPAUser.pcGetchangePwdDate(this).getTime());
    }

    public void setChangePwdDate(Date changePwdDate) {
        JPAUser.pcSetchangePwdDate(this, changePwdDate == null ? null : new Date(changePwdDate.getTime()));
    }

    public Integer getFailedLogins() {
        return JPAUser.pcGetfailedLogins(this) == null ? Integer.valueOf(0) : JPAUser.pcGetfailedLogins(this);
    }

    public void setFailedLogins(Integer failedLogins) {
        JPAUser.pcSetfailedLogins(this, failedLogins);
    }

    public Date getLastLoginDate() {
        return JPAUser.pcGetlastLoginDate(this) == null ? null : new Date(JPAUser.pcGetlastLoginDate(this).getTime());
    }

    public void setLastLoginDate(Date lastLoginDate) {
        JPAUser.pcSetlastLoginDate(this, lastLoginDate == null ? null : new Date(lastLoginDate.getTime()));
    }

    public String getLastRecertificator() {
        return JPAUser.pcGetlastRecertificator(this);
    }

    public void setLastRecertificator(String lastRecertificator) {
        JPAUser.pcSetlastRecertificator(this, lastRecertificator);
    }

    public Date getLastRecertification() {
        if (JPAUser.pcGetlastRecertification(this) != null) {
            return new Date(JPAUser.pcGetlastRecertification(this).getTime());
        }
        return null;
    }

    public void setLastRecertification(Date lastRecertification) {
        if (lastRecertification != null) {
            JPAUser.pcSetlastRecertification(this, new Date(lastRecertification.getTime()));
        } else {
            JPAUser.pcSetlastRecertification(this, null);
        }
    }

    public String getUsername() {
        return JPAUser.pcGetusername(this);
    }

    public void setUsername(String username) {
        JPAUser.pcSetusername(this, username);
    }

    public void setSuspended(Boolean suspended) {
        JPAUser.pcSetsuspended(this, this.getBooleanAsInteger(suspended));
    }

    public Boolean isSuspended() {
        return JPAUser.pcGetsuspended(this) == null ? null : Boolean.valueOf(this.isBooleanAsInteger(JPAUser.pcGetsuspended(this)));
    }

    public void setMustChangePassword(boolean mustChangePassword) {
        JPAUser.pcSetmustChangePassword(this, this.getBooleanAsInteger(mustChangePassword));
    }

    public boolean isMustChangePassword() {
        return this.isBooleanAsInteger(JPAUser.pcGetmustChangePassword(this));
    }

    public boolean verifyPasswordHistory(String password, int size) {
        boolean res = false;
        if (size > 0) {
            try {
                res = JPAUser.pcGetpasswordHistory(this).subList(size >= JPAUser.pcGetpasswordHistory(this).size() ? 0 : JPAUser.pcGetpasswordHistory(this).size() - size, JPAUser.pcGetpasswordHistory(this).size()).contains(JPAUser.pcGetcipherAlgorithm(this) == null ? password : ENCRYPTOR.encode(password, JPAUser.pcGetcipherAlgorithm(this)));
            }
            catch (Exception e) {
                LOG.error("Error evaluating password history", (Throwable)e);
            }
        }
        return res;
    }

    public SecurityQuestion getSecurityQuestion() {
        return JPAUser.pcGetsecurityQuestion(this);
    }

    public void setSecurityQuestion(SecurityQuestion securityQuestion) {
        this.checkType(securityQuestion, JPASecurityQuestion.class);
        JPAUser.pcSetsecurityQuestion(this, (JPASecurityQuestion)securityQuestion);
    }

    public String getSecurityAnswer() {
        return JPAUser.pcGetsecurityAnswer(this);
    }

    public void setSecurityAnswer(String securityAnswer) {
        JPAUser.pcSetsecurityAnswer(this, securityAnswer);
    }

    public boolean add(AnyTypeClass auxClass) {
        this.checkType(auxClass, JPAAnyTypeClass.class);
        return JPAUser.pcGetauxClasses(this).add((JPAAnyTypeClass)auxClass);
    }

    public List<? extends AnyTypeClass> getAuxClasses() {
        return JPAUser.pcGetauxClasses(this);
    }

    public boolean add(URelationship relationship) {
        this.checkType(relationship, JPAURelationship.class);
        return JPAUser.pcGetrelationships(this).add((JPAURelationship)relationship);
    }

    public URelationship getRelationship(final RelationshipType relationshipType, final String otherEndKey) {
        return (URelationship)IterableUtils.find(this.getRelationships(), (Predicate)new Predicate<URelationship>(){

            public boolean evaluate(URelationship relationship) {
                return relationshipType.equals(relationship.getType()) && otherEndKey != null && otherEndKey.equals(((AnyObject)relationship.getRightEnd()).getKey());
            }
        });
    }

    public List<? extends URelationship> getRelationships() {
        return JPAUser.pcGetrelationships(this);
    }

    public boolean add(UMembership membership) {
        this.checkType(membership, JPAUMembership.class);
        return JPAUser.pcGetmemberships(this).add((JPAUMembership)membership);
    }

    public List<? extends UMembership> getMemberships() {
        return JPAUser.pcGetmemberships(this);
    }

    static {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractAny != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractAny : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractAny = JPAUser.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractAny"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"auxClasses", "changePwdDate", "cipherAlgorithm", "failedLogins", "lastLoginDate", "lastRecertification", "lastRecertificator", "memberships", "mustChangePassword", "password", "passwordHistory", "plainAttrs", "relationships", "resources", "roles", "securityAnswer", "securityQuestion", "status", "suspended", "token", "tokenExpireTime", "username", "workflowId"};
        Class[] classArray = new Class[23];
        Class clazz2 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAUser.class$("java.util.List"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = JPAUser.class$("java.util.Date"));
        classArray[1] = clazz3;
        Class clazz4 = class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm != null ? class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm : (class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm = JPAUser.class$("org.apache.syncope.common.lib.types.CipherAlgorithm"));
        classArray[2] = clazz4;
        Class clazz5 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = JPAUser.class$("java.lang.Integer"));
        classArray[3] = clazz5;
        classArray[4] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = JPAUser.class$("java.util.Date"));
        classArray[5] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = JPAUser.class$("java.util.Date"));
        Class clazz6 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        classArray[6] = clazz6;
        classArray[7] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAUser.class$("java.util.List"));
        classArray[8] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = JPAUser.class$("java.lang.Integer"));
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        classArray[10] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAUser.class$("java.util.List"));
        classArray[11] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAUser.class$("java.util.List"));
        classArray[12] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAUser.class$("java.util.List"));
        classArray[13] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAUser.class$("java.util.List"));
        classArray[14] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAUser.class$("java.util.List"));
        classArray[15] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        Class clazz7 = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPASecurityQuestion != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPASecurityQuestion : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPASecurityQuestion = JPAUser.class$("org.apache.syncope.core.persistence.jpa.entity.JPASecurityQuestion"));
        classArray[16] = clazz7;
        classArray[17] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        classArray[18] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = JPAUser.class$("java.lang.Integer"));
        classArray[19] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        classArray[20] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = JPAUser.class$("java.util.Date"));
        classArray[21] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        classArray[22] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{5, 26, 26, 26, 26, 26, 26, 5, 26, 26, 5, 5, 5, 10, 10, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz8 = class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser : (class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser = JPAUser.class$("org.apache.syncope.core.persistence.jpa.entity.user.JPAUser"));
        PCRegistry.register((Class)clazz8, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAUser", (PersistenceCapable)new JPAUser());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1674154;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.auxClasses = null;
        this.changePwdDate = null;
        this.cipherAlgorithm = null;
        this.failedLogins = null;
        this.lastLoginDate = null;
        this.lastRecertification = null;
        this.lastRecertificator = null;
        this.memberships = null;
        this.mustChangePassword = null;
        this.password = null;
        this.passwordHistory = null;
        this.plainAttrs = null;
        this.relationships = null;
        this.resources = null;
        this.roles = null;
        this.securityAnswer = null;
        this.securityQuestion = null;
        this.status = null;
        this.suspended = null;
        this.token = null;
        this.tokenExpireTime = null;
        this.username = null;
        this.workflowId = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAUser jPAUser = new JPAUser();
        if (bl) {
            jPAUser.pcClearFields();
        }
        jPAUser.pcStateManager = stateManager;
        jPAUser.pcCopyKeyFieldsFromObjectId(object);
        return jPAUser;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAUser jPAUser = new JPAUser();
        if (bl) {
            jPAUser.pcClearFields();
        }
        jPAUser.pcStateManager = stateManager;
        return jPAUser;
    }

    protected static int pcGetManagedFieldCount() {
        return 23 + AbstractAny.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.auxClasses = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.changePwdDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.cipherAlgorithm = (CipherAlgorithm)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.failedLogins = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.lastLoginDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.lastRecertification = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.lastRecertificator = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.memberships = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.mustChangePassword = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.passwordHistory = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.plainAttrs = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.relationships = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.resources = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.roles = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.securityAnswer = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.securityQuestion = (JPASecurityQuestion)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.status = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.suspended = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this.token = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 20: {
                this.tokenExpireTime = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 21: {
                this.username = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 22: {
                this.workflowId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.auxClasses);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.changePwdDate);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.cipherAlgorithm);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.failedLogins);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastLoginDate);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastRecertification);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.lastRecertificator);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.memberships);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.mustChangePassword);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.passwordHistory);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.plainAttrs);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.relationships);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.resources);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.roles);
                return;
            }
            case 15: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.securityAnswer);
                return;
            }
            case 16: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.securityQuestion);
                return;
            }
            case 17: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.status);
                return;
            }
            case 18: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.suspended);
                return;
            }
            case 19: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.token);
                return;
            }
            case 20: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.tokenExpireTime);
                return;
            }
            case 21: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.username);
                return;
            }
            case 22: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.workflowId);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPAUser jPAUser, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAUser, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.auxClasses = jPAUser.auxClasses;
                return;
            }
            case 1: {
                this.changePwdDate = jPAUser.changePwdDate;
                return;
            }
            case 2: {
                this.cipherAlgorithm = jPAUser.cipherAlgorithm;
                return;
            }
            case 3: {
                this.failedLogins = jPAUser.failedLogins;
                return;
            }
            case 4: {
                this.lastLoginDate = jPAUser.lastLoginDate;
                return;
            }
            case 5: {
                this.lastRecertification = jPAUser.lastRecertification;
                return;
            }
            case 6: {
                this.lastRecertificator = jPAUser.lastRecertificator;
                return;
            }
            case 7: {
                this.memberships = jPAUser.memberships;
                return;
            }
            case 8: {
                this.mustChangePassword = jPAUser.mustChangePassword;
                return;
            }
            case 9: {
                this.password = jPAUser.password;
                return;
            }
            case 10: {
                this.passwordHistory = jPAUser.passwordHistory;
                return;
            }
            case 11: {
                this.plainAttrs = jPAUser.plainAttrs;
                return;
            }
            case 12: {
                this.relationships = jPAUser.relationships;
                return;
            }
            case 13: {
                this.resources = jPAUser.resources;
                return;
            }
            case 14: {
                this.roles = jPAUser.roles;
                return;
            }
            case 15: {
                this.securityAnswer = jPAUser.securityAnswer;
                return;
            }
            case 16: {
                this.securityQuestion = jPAUser.securityQuestion;
                return;
            }
            case 17: {
                this.status = jPAUser.status;
                return;
            }
            case 18: {
                this.suspended = jPAUser.suspended;
                return;
            }
            case 19: {
                this.token = jPAUser.token;
                return;
            }
            case 20: {
                this.tokenExpireTime = jPAUser.tokenExpireTime;
                return;
            }
            case 21: {
                this.username = jPAUser.username;
                return;
            }
            case 22: {
                this.workflowId = jPAUser.workflowId;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAUser jPAUser = (JPAUser)object;
        if (jPAUser.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPAUser, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser : (class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser = JPAUser.class$("org.apache.syncope.core.persistence.jpa.entity.user.JPAUser"));
        return clazz;
    }

    private static final List pcGetauxClasses(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.auxClasses;
        }
        int n = pcInheritedFieldCount + 0;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.auxClasses;
    }

    private static final void pcSetauxClasses(JPAUser jPAUser, List list) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.auxClasses = list;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 0, jPAUser.auxClasses, (Object)list, 0);
    }

    private static final Date pcGetchangePwdDate(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.changePwdDate;
        }
        int n = pcInheritedFieldCount + 1;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.changePwdDate;
    }

    private static final void pcSetchangePwdDate(JPAUser jPAUser, Date date) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.changePwdDate = date;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 1, (Object)jPAUser.changePwdDate, (Object)date, 0);
    }

    private static final CipherAlgorithm pcGetcipherAlgorithm(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.cipherAlgorithm;
        }
        int n = pcInheritedFieldCount + 2;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.cipherAlgorithm;
    }

    private static final void pcSetcipherAlgorithm(JPAUser jPAUser, CipherAlgorithm cipherAlgorithm) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.cipherAlgorithm = cipherAlgorithm;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 2, (Object)jPAUser.cipherAlgorithm, (Object)cipherAlgorithm, 0);
    }

    private static final Integer pcGetfailedLogins(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.failedLogins;
        }
        int n = pcInheritedFieldCount + 3;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.failedLogins;
    }

    private static final void pcSetfailedLogins(JPAUser jPAUser, Integer n) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.failedLogins = n;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 3, (Object)jPAUser.failedLogins, (Object)n, 0);
    }

    private static final Date pcGetlastLoginDate(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.lastLoginDate;
        }
        int n = pcInheritedFieldCount + 4;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.lastLoginDate;
    }

    private static final void pcSetlastLoginDate(JPAUser jPAUser, Date date) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.lastLoginDate = date;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 4, (Object)jPAUser.lastLoginDate, (Object)date, 0);
    }

    private static final Date pcGetlastRecertification(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.lastRecertification;
        }
        int n = pcInheritedFieldCount + 5;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.lastRecertification;
    }

    private static final void pcSetlastRecertification(JPAUser jPAUser, Date date) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.lastRecertification = date;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 5, (Object)jPAUser.lastRecertification, (Object)date, 0);
    }

    private static final String pcGetlastRecertificator(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.lastRecertificator;
        }
        int n = pcInheritedFieldCount + 6;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.lastRecertificator;
    }

    private static final void pcSetlastRecertificator(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.lastRecertificator = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 6, jPAUser.lastRecertificator, string, 0);
    }

    private static final List pcGetmemberships(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.memberships;
        }
        int n = pcInheritedFieldCount + 7;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.memberships;
    }

    private static final void pcSetmemberships(JPAUser jPAUser, List list) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.memberships = list;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 7, jPAUser.memberships, (Object)list, 0);
    }

    private static final Integer pcGetmustChangePassword(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.mustChangePassword;
        }
        int n = pcInheritedFieldCount + 8;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.mustChangePassword;
    }

    private static final void pcSetmustChangePassword(JPAUser jPAUser, Integer n) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.mustChangePassword = n;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 8, (Object)jPAUser.mustChangePassword, (Object)n, 0);
    }

    private static final String pcGetpassword(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.password;
        }
        int n = pcInheritedFieldCount + 9;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.password;
    }

    private static final void pcSetpassword(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.password = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 9, jPAUser.password, string, 0);
    }

    private static final List pcGetpasswordHistory(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.passwordHistory;
        }
        int n = pcInheritedFieldCount + 10;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.passwordHistory;
    }

    private static final void pcSetpasswordHistory(JPAUser jPAUser, List list) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.passwordHistory = list;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 10, jPAUser.passwordHistory, (Object)list, 0);
    }

    private static final List pcGetplainAttrs(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.plainAttrs;
        }
        int n = pcInheritedFieldCount + 11;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.plainAttrs;
    }

    private static final void pcSetplainAttrs(JPAUser jPAUser, List list) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.plainAttrs = list;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 11, jPAUser.plainAttrs, (Object)list, 0);
    }

    private static final List pcGetrelationships(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.relationships;
        }
        int n = pcInheritedFieldCount + 12;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.relationships;
    }

    private static final void pcSetrelationships(JPAUser jPAUser, List list) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.relationships = list;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 12, jPAUser.relationships, (Object)list, 0);
    }

    private static final List pcGetresources(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.resources;
        }
        int n = pcInheritedFieldCount + 13;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.resources;
    }

    private static final void pcSetresources(JPAUser jPAUser, List list) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.resources = list;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 13, jPAUser.resources, (Object)list, 0);
    }

    private static final List pcGetroles(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.roles;
        }
        int n = pcInheritedFieldCount + 14;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.roles;
    }

    private static final void pcSetroles(JPAUser jPAUser, List list) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.roles = list;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 14, jPAUser.roles, (Object)list, 0);
    }

    private static final String pcGetsecurityAnswer(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.securityAnswer;
        }
        int n = pcInheritedFieldCount + 15;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.securityAnswer;
    }

    private static final void pcSetsecurityAnswer(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.securityAnswer = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 15, jPAUser.securityAnswer, string, 0);
    }

    private static final JPASecurityQuestion pcGetsecurityQuestion(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.securityQuestion;
        }
        int n = pcInheritedFieldCount + 16;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.securityQuestion;
    }

    private static final void pcSetsecurityQuestion(JPAUser jPAUser, JPASecurityQuestion jPASecurityQuestion) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.securityQuestion = jPASecurityQuestion;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 16, (Object)jPAUser.securityQuestion, (Object)jPASecurityQuestion, 0);
    }

    private static final String pcGetstatus(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.status;
        }
        int n = pcInheritedFieldCount + 17;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.status;
    }

    private static final void pcSetstatus(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.status = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 17, jPAUser.status, string, 0);
    }

    private static final Integer pcGetsuspended(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.suspended;
        }
        int n = pcInheritedFieldCount + 18;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.suspended;
    }

    private static final void pcSetsuspended(JPAUser jPAUser, Integer n) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.suspended = n;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 18, (Object)jPAUser.suspended, (Object)n, 0);
    }

    private static final String pcGettoken(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.token;
        }
        int n = pcInheritedFieldCount + 19;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.token;
    }

    private static final void pcSettoken(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.token = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 19, jPAUser.token, string, 0);
    }

    private static final Date pcGettokenExpireTime(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.tokenExpireTime;
        }
        int n = pcInheritedFieldCount + 20;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.tokenExpireTime;
    }

    private static final void pcSettokenExpireTime(JPAUser jPAUser, Date date) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.tokenExpireTime = date;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 20, (Object)jPAUser.tokenExpireTime, (Object)date, 0);
    }

    private static final String pcGetusername(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.username;
        }
        int n = pcInheritedFieldCount + 21;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.username;
    }

    private static final void pcSetusername(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.username = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 21, jPAUser.username, string, 0);
    }

    private static final String pcGetworkflowId(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.workflowId;
        }
        int n = pcInheritedFieldCount + 22;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.workflowId;
    }

    private static final void pcSetworkflowId(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.workflowId = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 22, jPAUser.workflowId, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

