/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.dao.MalformedPathException;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PullPolicy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPARealm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JPARealmDAO
extends AbstractDAO<Realm>
implements RealmDAO {
    @Autowired
    private RoleDAO roleDAO;

    public Realm getRoot() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE e.parent IS NULL", Realm.class);
        Realm result = null;
        try {
            result = (Realm)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("Root realm not found", (Throwable)e);
        }
        return result;
    }

    @Transactional(readOnly=true)
    public Realm find(String key) {
        return (Realm)this.entityManager().find(JPARealm.class, (Object)key);
    }

    @Transactional(readOnly=true)
    public Realm findByFullPath(String fullPath) {
        if ("/".equals(fullPath)) {
            return this.getRoot();
        }
        if (StringUtils.isBlank((CharSequence)fullPath) || !PATH_PATTERN.matcher(fullPath).matches()) {
            throw new MalformedPathException(fullPath);
        }
        Realm root = this.getRoot();
        if (root == null) {
            return null;
        }
        Realm current = root;
        for (final String pathElement : fullPath.substring(1).split("/")) {
            if ((current = (Realm)IterableUtils.find(this.findChildren(current), (Predicate)new Predicate<Realm>(){

                public boolean evaluate(Realm realm) {
                    return pathElement.equals(realm.getName());
                }
            })) != null) continue;
            return null;
        }
        return current;
    }

    private <T extends Policy> List<Realm> findSamePolicyChildren(Realm realm, T policy) {
        ArrayList<Realm> result = new ArrayList<Realm>();
        for (Realm child : this.findChildren(realm)) {
            if (!(policy instanceof AccountPolicy && child.getAccountPolicy() == null || policy.equals(child.getAccountPolicy()) || policy instanceof PasswordPolicy && child.getPasswordPolicy() == null) && !policy.equals(child.getPasswordPolicy())) continue;
            result.add(child);
            result.addAll(this.findSamePolicyChildren(child, policy));
        }
        return result;
    }

    public List<Realm> findByName(String name) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE e.name=:name", Realm.class);
        query.setParameter("name", (Object)name);
        return query.getResultList();
    }

    public List<Realm> findByResource(ExternalResource resource) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE :resource MEMBER OF e.resources", Realm.class);
        query.setParameter("resource", (Object)resource);
        return query.getResultList();
    }

    public <T extends Policy> List<Realm> findByPolicy(T policy) {
        if (PullPolicy.class.isAssignableFrom(policy.getClass())) {
            return Collections.emptyList();
        }
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE e." + (policy instanceof AccountPolicy ? "accountPolicy" : "passwordPolicy") + "=:policy", Realm.class);
        query.setParameter("policy", policy);
        ArrayList<Realm> result = new ArrayList<Realm>();
        for (Realm realm : query.getResultList()) {
            result.add(realm);
            result.addAll(this.findSamePolicyChildren(realm, policy));
        }
        return result;
    }

    private void findAncestors(List<Realm> result, Realm realm) {
        if (realm.getParent() != null && !result.contains(realm.getParent())) {
            result.add(realm.getParent());
            this.findAncestors(result, realm.getParent());
        }
    }

    public List<Realm> findAncestors(Realm realm) {
        ArrayList<Realm> result = new ArrayList<Realm>();
        result.add(realm);
        this.findAncestors(result, realm);
        return result;
    }

    public List<Realm> findChildren(Realm realm) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE e.parent=:realm", Realm.class);
        query.setParameter("realm", (Object)realm);
        return query.getResultList();
    }

    private void findDescendants(List<Realm> result, Realm realm) {
        result.add(realm);
        List<Realm> children = this.findChildren(realm);
        if (children != null) {
            for (Realm child : children) {
                this.findDescendants(result, child);
            }
        }
    }

    public List<Realm> findDescendants(Realm realm) {
        ArrayList<Realm> result = new ArrayList<Realm>();
        this.findDescendants(result, realm);
        return result;
    }

    @Transactional(readOnly=true)
    public List<Realm> findAll() {
        return this.findDescendants(this.getRoot());
    }

    public Realm save(Realm realm) {
        return (Realm)this.entityManager().merge((Object)realm);
    }

    public void delete(Realm realm) {
        for (Realm toBeDeleted : this.findDescendants(realm)) {
            for (Role role : this.roleDAO.findByRealm(toBeDeleted)) {
                role.getRealms().remove(toBeDeleted);
            }
            toBeDeleted.setParent(null);
            this.entityManager().remove((Object)toBeDeleted);
        }
    }

    public void delete(String key) {
        Realm realm = this.find(key);
        if (realm == null) {
            return;
        }
        this.delete(realm);
    }
}

