/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Collections;
import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.IterableUtils;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.entity.MailTemplate;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPANotification;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JPANotificationDAO
extends AbstractDAO<Notification>
implements NotificationDAO {
    @Autowired
    private TaskDAO taskDAO;

    @Transactional(readOnly=true)
    public Notification find(String key) {
        return (Notification)this.entityManager().find(JPANotification.class, (Object)key);
    }

    @Transactional(readOnly=true)
    public List<Notification> findByTemplate(MailTemplate template) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPANotification.class.getSimpleName() + " e WHERE e.template=:template", Notification.class);
        query.setParameter("template", (Object)template);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<Notification> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPANotification.class.getSimpleName() + " e", Notification.class);
        return query.getResultList();
    }

    public Notification save(Notification notification) {
        return (Notification)this.entityManager().merge((Object)notification);
    }

    public void delete(String key) {
        Notification notification = this.find(key);
        if (notification == null) {
            return;
        }
        IterableUtils.forEach((Iterable)this.taskDAO.findAll(TaskType.NOTIFICATION, null, notification, null, null, -1, -1, Collections.emptyList()), (Closure)new Closure<Task>(){

            public void execute(Task input) {
                JPANotificationDAO.this.delete(input.getKey());
            }
        });
        this.entityManager().remove((Object)notification);
    }
}

