/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.policy.HaveIBeenPwnedPasswordRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.dao.PasswordRule;
import org.apache.syncope.core.persistence.api.dao.PasswordRuleConfClass;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.utils.policy.PasswordPolicyException;
import org.apache.syncope.core.spring.security.Encryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@PasswordRuleConfClass(value=HaveIBeenPwnedPasswordRuleConf.class)
public class HaveIBeenPwnedPasswordRule
implements PasswordRule {
    protected static final Logger LOG = LoggerFactory.getLogger(HaveIBeenPwnedPasswordRule.class);
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();

    public void enforce(PasswordRuleConf conf, User user) {
        String clearPassword = user.getClearPassword();
        String password = user.getPassword();
        if (password != null && clearPassword != null) {
            try {
                final String sha1 = ENCRYPTOR.encode(clearPassword, CipherAlgorithm.SHA1);
                HttpHeaders headers = new HttpHeaders();
                headers.set("User-Agent", "Apache Syncope");
                ResponseEntity response = new RestTemplate().exchange(URI.create("https://api.pwnedpasswords.com/range/" + sha1.substring(0, 5)), HttpMethod.GET, new HttpEntity(null, (MultiValueMap)headers), String.class);
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)response.getBody())) && IterableUtils.matchesAny(Arrays.asList(((String)response.getBody()).split("\\n")), (Predicate)new Predicate<String>(){

                    public boolean evaluate(String line) {
                        return sha1.equals(sha1.substring(0, 5) + StringUtils.substringBefore((String)line, (String)":"));
                    }
                })) {
                    throw new PasswordPolicyException("Password pwned");
                }
            }
            catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                LOG.error("Could not encode the password value as SHA1", (Throwable)e);
            }
            catch (HttpStatusCodeException e) {
                LOG.error("Error while contacting the PwnedPasswords service", (Throwable)e);
            }
        }
    }
}

