/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.activiti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.engine.impl.persistence.entity.UserEntity;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;

public class SyncopeUserQueryImpl
implements UserQuery {
    private final UserDAO userDAO;
    private final GroupDAO groupDAO;
    private String username;
    private String memberOf;
    private List<User> result;

    public SyncopeUserQueryImpl(UserDAO userDAO, GroupDAO groupDAO) {
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
    }

    public UserQuery userId(String id) {
        this.username = id;
        return this;
    }

    public UserQuery userFirstName(String firstName) {
        return this;
    }

    public UserQuery userFirstNameLike(String firstNameLike) {
        return this;
    }

    public UserQuery userLastName(String lastName) {
        return this;
    }

    public UserQuery userLastNameLike(String lastNameLike) {
        return this;
    }

    public UserQuery userFullNameLike(String fullNameLike) {
        return this;
    }

    public UserQuery userEmail(String email) {
        return this;
    }

    public UserQuery userEmailLike(String emailLike) {
        return this;
    }

    public UserQuery memberOfGroup(String groupId) {
        this.memberOf = groupId;
        return this;
    }

    public UserQuery orderByUserId() {
        return this;
    }

    public UserQuery orderByUserFirstName() {
        return this;
    }

    public UserQuery orderByUserLastName() {
        return this;
    }

    public UserQuery orderByUserEmail() {
        return this;
    }

    public UserQuery asc() {
        return this;
    }

    public UserQuery desc() {
        return this;
    }

    private User fromSyncopeUser(org.apache.syncope.core.persistence.api.entity.user.User user) {
        return new UserEntity(user.getUsername());
    }

    private void execute() {
        if (this.username != null) {
            org.apache.syncope.core.persistence.api.entity.user.User user = this.userDAO.findByUsername(this.username);
            if (user == null) {
                this.result = Collections.emptyList();
            } else if (this.memberOf == null || this.userDAO.findAllGroupNames(user).contains(this.memberOf)) {
                this.result = Collections.singletonList(this.fromSyncopeUser(user));
            }
        }
        if (this.memberOf != null) {
            Group group = this.groupDAO.findByName(this.memberOf);
            if (group == null) {
                this.result = Collections.emptyList();
            } else {
                this.result = new ArrayList<User>();
                List memberships = this.groupDAO.findUMemberships(group);
                for (UMembership membership : memberships) {
                    User user = this.fromSyncopeUser((org.apache.syncope.core.persistence.api.entity.user.User)membership.getLeftEnd());
                    if (this.result.contains(user)) continue;
                    this.result.add(user);
                }
            }
        }
        if (this.result == null) {
            this.result = new ArrayList<User>();
            for (int page = 1; page <= this.userDAO.count() / 500 + 1; ++page) {
                CollectionUtils.collect((Iterable)this.userDAO.findAll(page, 500), (Transformer)new Transformer<org.apache.syncope.core.persistence.api.entity.user.User, User>(){

                    public User transform(org.apache.syncope.core.persistence.api.entity.user.User user) {
                        return SyncopeUserQueryImpl.this.fromSyncopeUser(user);
                    }
                }, this.result);
            }
        }
    }

    public long count() {
        if (this.result == null) {
            this.execute();
        }
        return this.result.size();
    }

    public User singleResult() {
        if (this.result == null) {
            this.execute();
        }
        if (this.result.isEmpty()) {
            throw new ActivitiException("Empty result");
        }
        return this.result.get(0);
    }

    public List<User> list() {
        if (this.result == null) {
            this.execute();
        }
        return this.result;
    }

    public List<User> listPage(int firstResult, int maxResults) {
        if (this.result == null) {
            this.execute();
        }
        return this.result.subList(firstResult, firstResult + maxResults - 1);
    }

    public UserQuery potentialStarter(String string) {
        throw new UnsupportedOperationException();
    }
}

