/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.to.WorkflowFormTO;
import org.apache.syncope.common.lib.to.WorkflowTaskTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UserWorkflowLogic
extends AbstractTransactionalLogic<WorkflowFormTO> {
    @Autowired
    private UserWorkflowAdapter uwfAdapter;
    @Autowired
    private PropagationManager propagationManager;
    @Autowired
    private PropagationTaskExecutor taskExecutor;
    @Autowired
    private UserDataBinder binder;
    @Autowired
    private UserDAO userDAO;

    @PreAuthorize(value="hasRole('WORKFLOW_FORM_CLAIM')")
    public WorkflowFormTO claimForm(String taskId) {
        return this.uwfAdapter.claimForm(taskId);
    }

    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public UserTO executeWorkflowTask(UserTO userTO, String taskId) {
        WorkflowResult updated = this.uwfAdapter.execute(userTO, taskId);
        UserPatch userPatch = new UserPatch();
        userPatch.setKey(userTO.getKey());
        List tasks = this.propagationManager.getUserUpdateTasks(new WorkflowResult((Object)Pair.of((Object)userPatch, null), updated.getPropByRes(), updated.getPerformedTasks()));
        this.taskExecutor.execute((Collection)tasks, false);
        return this.binder.getUserTO((String)updated.getResult());
    }

    @PreAuthorize(value="hasRole('WORKFLOW_FORM_READ') and hasRole('USER_READ')")
    @Transactional(readOnly=true)
    public WorkflowFormTO getFormForUser(String key) {
        User user = (User)this.userDAO.authFind(key);
        return this.uwfAdapter.getForm(user.getWorkflowId());
    }

    @PreAuthorize(value="hasRole('WORKFLOW_FORM_LIST')")
    @Transactional(readOnly=true)
    public List<WorkflowFormTO> getForms() {
        return this.uwfAdapter.getForms();
    }

    @PreAuthorize(value="hasRole('WORKFLOW_TASK_LIST') and hasRole('USER_READ')")
    public List<WorkflowTaskTO> getAvailableTasks(String key) {
        User user = (User)this.userDAO.authFind(key);
        return this.uwfAdapter.getAvailableTasks(user.getWorkflowId());
    }

    @PreAuthorize(value="hasRole('WORKFLOW_FORM_SUBMIT')")
    public UserTO submitForm(WorkflowFormTO form) {
        WorkflowResult updated = this.uwfAdapter.submitForm(form);
        if (updated.getResult() instanceof UserPatch && updated.getPropByRes() != null && !updated.getPropByRes().isEmpty()) {
            List tasks = this.propagationManager.getUserUpdateTasks(new WorkflowResult((Object)Pair.of((Object)((UserPatch)updated.getResult()), (Object)Boolean.TRUE), updated.getPropByRes(), updated.getPerformedTasks()));
            this.taskExecutor.execute((Collection)tasks, false);
        }
        return this.binder.getUserTO(((AnyPatch)updated.getResult()).getKey());
    }

    @Override
    protected WorkflowFormTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

