/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.SecurityQuestionTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.user.SecurityQuestion;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.data.SecurityQuestionDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SecurityQuestionLogic
extends AbstractTransactionalLogic<SecurityQuestionTO> {
    @Autowired
    private SecurityQuestionDAO securityQuestionDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private SecurityQuestionDataBinder binder;

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<SecurityQuestionTO> list() {
        return (List)CollectionUtils.collect((Iterable)this.securityQuestionDAO.findAll(), (Transformer)new Transformer<SecurityQuestion, SecurityQuestionTO>(){

            public SecurityQuestionTO transform(SecurityQuestion input) {
                return SecurityQuestionLogic.this.binder.getSecurityQuestionTO(input);
            }
        }, new ArrayList());
    }

    @PreAuthorize(value="hasRole('SECURITY_QUESTION_READ')")
    @Transactional(readOnly=true)
    public SecurityQuestionTO read(String key) {
        SecurityQuestion securityQuestion = this.securityQuestionDAO.find(key);
        if (securityQuestion == null) {
            LOG.error("Could not find security question '" + key + "'");
            throw new NotFoundException(String.valueOf(key));
        }
        return this.binder.getSecurityQuestionTO(securityQuestion);
    }

    @PreAuthorize(value="hasRole('SECURITY_QUESTION_CREATE')")
    public SecurityQuestionTO create(SecurityQuestionTO securityQuestionTO) {
        return this.binder.getSecurityQuestionTO(this.securityQuestionDAO.save(this.binder.create(securityQuestionTO)));
    }

    @PreAuthorize(value="hasRole('SECURITY_QUESTION_UPDATE')")
    public SecurityQuestionTO update(SecurityQuestionTO securityQuestionTO) {
        SecurityQuestion securityQuestion = this.securityQuestionDAO.find(securityQuestionTO.getKey());
        if (securityQuestion == null) {
            LOG.error("Could not find security question '" + securityQuestionTO.getKey() + "'");
            throw new NotFoundException(String.valueOf(securityQuestionTO.getKey()));
        }
        this.binder.update(securityQuestion, securityQuestionTO);
        securityQuestion = this.securityQuestionDAO.save(securityQuestion);
        return this.binder.getSecurityQuestionTO(securityQuestion);
    }

    @PreAuthorize(value="hasRole('SECURITY_QUESTION_DELETE')")
    public SecurityQuestionTO delete(String key) {
        SecurityQuestion securityQuestion = this.securityQuestionDAO.find(key);
        if (securityQuestion == null) {
            LOG.error("Could not find security question '" + key + "'");
            throw new NotFoundException(String.valueOf(key));
        }
        SecurityQuestionTO deleted = this.binder.getSecurityQuestionTO(securityQuestion);
        this.securityQuestionDAO.delete(key);
        return deleted;
    }

    @PreAuthorize(value="isAnonymous() or hasRole('ANONYMOUS')")
    public SecurityQuestionTO readByUser(String username) {
        if (username == null) {
            throw new NotFoundException("Null username");
        }
        User user = this.userDAO.findByUsername(username);
        if (user == null) {
            throw new NotFoundException("User " + username);
        }
        if (user.getSecurityQuestion() == null) {
            LOG.error("Could not find security question for user '" + username + "'");
            throw new NotFoundException("Security question for user " + username);
        }
        return this.binder.getSecurityQuestionTO(user.getSecurityQuestion());
    }

    @Override
    protected SecurityQuestionTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof SecurityQuestionTO)) continue;
                key = ((SecurityQuestionTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getSecurityQuestionTO(this.securityQuestionDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

