/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.core.logic.AbstractLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.java.job.AfterHandlingJob;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Aspect
public class LogicInvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LogicInvocationHandler.class);
    @Autowired
    private NotificationManager notificationManager;
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private SchedulerFactoryBean scheduler;

    @Around(value="execution(* org.apache.syncope.core.logic.AbstractLogic+.*(..))")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Class<?> clazz = joinPoint.getTarget().getClass();
        Object[] input = joinPoint.getArgs();
        String category = clazz.getSimpleName();
        MethodSignature ms = (MethodSignature)joinPoint.getSignature();
        Method method = ms.getMethod();
        String event = joinPoint.getSignature().getName();
        boolean notificationsAvailable = this.notificationManager.notificationsAvailable(AuditElements.EventCategoryType.LOGIC, category, null, event);
        boolean auditRequested = this.auditManager.auditRequested(AuditElements.EventCategoryType.LOGIC, category, null, event);
        AuditElements.Result condition = null;
        Object output = null;
        Object before = null;
        try {
            LOG.debug("Before {}.{}({})", new Object[]{clazz.getSimpleName(), event, input == null || input.length == 0 ? "" : Arrays.asList(input)});
            if (notificationsAvailable || auditRequested) {
                try {
                    before = ((AbstractLogic)joinPoint.getTarget()).resolveBeanReference(method, input);
                }
                catch (UnresolvedReferenceException ignore) {
                    LOG.debug("Unresolved bean reference ...");
                }
            }
            output = joinPoint.proceed();
            condition = AuditElements.Result.SUCCESS;
            LOG.debug("After returning {}.{}: {}", new Object[]{clazz.getSimpleName(), event, output});
            Object ignore = output;
            return ignore;
        }
        catch (Throwable t) {
            output = t;
            condition = AuditElements.Result.FAILURE;
            LOG.debug("After throwing {}.{}", (Object)clazz.getSimpleName(), (Object)event);
            throw t;
        }
        finally {
            if (notificationsAvailable || auditRequested) {
                HashMap<String, AfterHandlingEvent> jobMap = new HashMap<String, AfterHandlingEvent>();
                jobMap.put("AfterHandlingEvent", new AfterHandlingEvent(AuditElements.EventCategoryType.LOGIC, category, null, event, condition, before, output, input));
                AfterHandlingJob.schedule((SchedulerFactoryBean)this.scheduler, jobMap);
            }
        }
    }
}

