/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.idp;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthContext;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServerJoseJwtProducer;
import org.apache.cxf.rs.security.oauth2.utils.OAuthContextUtils;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.common.UserInfo;
import org.apache.cxf.rs.security.oidc.idp.OidcUserSubject;
import org.apache.cxf.rs.security.oidc.idp.UserInfoProvider;

@Path(value="/userinfo")
public class UserInfoService
extends OAuthServerJoseJwtProducer {
    private UserInfoProvider userInfoProvider;
    private OAuthDataProvider oauthDataProvider;
    private List<String> additionalClaims = Collections.emptyList();
    private boolean convertClearUserInfoToString;
    @Context
    private MessageContext mc;

    @GET
    @Produces(value={"application/json", "application/jwt"})
    public Response getUserInfo() {
        OidcUserSubject oidcUserSubject;
        OAuthContext oauth = OAuthContextUtils.getContext((MessageContext)this.mc);
        UserInfo userInfo = null;
        if (this.userInfoProvider != null) {
            userInfo = this.userInfoProvider.getUserInfo(oauth.getClientId(), oauth.getSubject(), OAuthUtils.convertPermissionsToScopeList((List)oauth.getPermissions()));
        } else if (oauth.getSubject() instanceof OidcUserSubject && (userInfo = (oidcUserSubject = (OidcUserSubject)oauth.getSubject()).getUserInfo()) == null) {
            userInfo = this.createFromIdToken(oidcUserSubject.getIdToken());
        }
        if (userInfo == null) {
            return Response.serverError().build();
        }
        Object responseEntity = null;
        if (super.isJwsRequired() || super.isJweRequired()) {
            Client client = null;
            if (this.oauthDataProvider != null) {
                client = this.oauthDataProvider.getClient(oauth.getClientId());
            }
            responseEntity = super.processJwt(new JwtToken((JwtClaims)userInfo), client);
        } else {
            responseEntity = this.convertUserInfoToResponseEntity(userInfo);
        }
        return Response.ok((Object)responseEntity).build();
    }

    protected Object convertUserInfoToResponseEntity(UserInfo userInfo) {
        return this.convertClearUserInfoToString ? JwtUtils.claimsToJson((JwtClaims)userInfo) : userInfo;
    }

    protected UserInfo createFromIdToken(IdToken idToken) {
        UserInfo userInfo = new UserInfo();
        userInfo.setSubject(idToken.getSubject());
        if (super.isJwsRequired()) {
            userInfo.setIssuer(idToken.getIssuer());
            userInfo.setAudience(idToken.getAudience());
        }
        if (idToken.getPreferredUserName() != null) {
            userInfo.setPreferredUserName(idToken.getPreferredUserName());
        }
        if (idToken.getName() != null) {
            userInfo.setName(idToken.getName());
        }
        if (idToken.getGivenName() != null) {
            userInfo.setGivenName(idToken.getGivenName());
        }
        if (idToken.getFamilyName() != null) {
            userInfo.setFamilyName(idToken.getFamilyName());
        }
        if (idToken.getEmail() != null) {
            userInfo.setEmail(idToken.getEmail());
        }
        if (idToken.getNickName() != null) {
            userInfo.setNickName(idToken.getNickName());
        }
        if (this.additionalClaims != null && !this.additionalClaims.isEmpty()) {
            for (String additionalClaim : this.additionalClaims) {
                if (!idToken.containsProperty(additionalClaim)) continue;
                userInfo.setClaim(additionalClaim, idToken.getClaim(additionalClaim));
            }
        }
        return userInfo;
    }

    public void setUserInfoProvider(UserInfoProvider userInfoProvider) {
        this.userInfoProvider = userInfoProvider;
    }

    public void setOauthDataProvider(OAuthDataProvider oauthDataProvider) {
        this.oauthDataProvider = oauthDataProvider;
    }

    public void setAdditionalClaims(List<String> additionalClaims) {
        this.additionalClaims = additionalClaims;
    }

    public void setConvertClearUserInfoToString(boolean convertClearUserInfoToString) {
        this.convertClearUserInfoToString = convertClearUserInfoToString;
    }
}

